/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import jdk.xml.internal.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPoolGen
implements Serializable {
    protected int size = 1024;
    protected Constant[] constants = new Constant[this.size];
    protected int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private static final long serialVersionUID = -4422321281142141817L;
    private HashMap<String, Index> stringTable = new HashMap();
    private HashMap<String, Index> classTable = new HashMap();
    private HashMap<String, Index> utf8Table = new HashMap();
    private HashMap<String, Index> natTable = new HashMap();
    private HashMap<String, Index> cpTable = new HashMap();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("size", Integer.TYPE), new ObjectStreamField("constants", Constant[].class), new ObjectStreamField("index", Integer.TYPE), new ObjectStreamField("string_table", java.util.HashMap.class), new ObjectStreamField("class_table", java.util.HashMap.class), new ObjectStreamField("utf8_table", java.util.HashMap.class), new ObjectStreamField("n_a_t_table", java.util.HashMap.class), new ObjectStreamField("cp_table", java.util.HashMap.class)};

    public ConstantPoolGen(Constant[] constantArray) {
        if (constantArray.length > this.size) {
            this.size = constantArray.length;
            this.constants = new Constant[this.size];
        }
        System.arraycopy(constantArray, 0, this.constants, 0, constantArray.length);
        if (constantArray.length > 0) {
            this.index = constantArray.length;
        }
        for (int i = 1; i < this.index; ++i) {
            Constant constant;
            Constant constant2;
            Constant constant3;
            Constant constant4 = this.constants[i];
            if (constant4 instanceof ConstantString) {
                constant3 = (ConstantString)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantString)constant3).getStringIndex()];
                this.stringTable.put(((ConstantUtf8)constant2).getBytes(), new Index(i));
                continue;
            }
            if (constant4 instanceof ConstantClass) {
                constant3 = (ConstantClass)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantClass)constant3).getNameIndex()];
                this.classTable.put(((ConstantUtf8)constant2).getBytes(), new Index(i));
                continue;
            }
            if (constant4 instanceof ConstantNameAndType) {
                constant3 = (ConstantNameAndType)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant3).getNameIndex()];
                constant = (ConstantUtf8)this.constants[((ConstantNameAndType)constant3).getSignatureIndex()];
                this.natTable.put(((ConstantUtf8)constant2).getBytes() + NAT_DELIM + ((ConstantUtf8)constant).getBytes(), new Index(i));
                continue;
            }
            if (constant4 instanceof ConstantUtf8) {
                constant3 = (ConstantUtf8)constant4;
                this.utf8Table.put(((ConstantUtf8)constant3).getBytes(), new Index(i));
                continue;
            }
            if (!(constant4 instanceof ConstantCP)) continue;
            constant3 = (ConstantCP)constant4;
            constant2 = (ConstantClass)this.constants[((ConstantCP)constant3).getClassIndex()];
            constant = (ConstantNameAndType)this.constants[((ConstantCP)constant3).getNameAndTypeIndex()];
            ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constants[((ConstantClass)constant2).getNameIndex()];
            String string = constantUtf8.getBytes().replace('/', '.');
            constantUtf8 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getNameIndex()];
            String string2 = constantUtf8.getBytes();
            constantUtf8 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getSignatureIndex()];
            String string3 = constantUtf8.getBytes();
            String string4 = METHODREF_DELIM;
            if (constant4 instanceof ConstantInterfaceMethodref) {
                string4 = IMETHODREF_DELIM;
            } else if (constant4 instanceof ConstantFieldref) {
                string4 = FIELDREF_DELIM;
            }
            this.cpTable.put(string + string4 + string2 + string4 + string3, new Index(i));
        }
    }

    public ConstantPoolGen(ConstantPool constantPool) {
        this(constantPool.getConstantPool());
    }

    public ConstantPoolGen() {
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] constantArray = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(constantArray, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String string) {
        Index index = this.stringTable.get(string);
        return index != null ? index.index : -1;
    }

    public int addString(String string) {
        int n = this.lookupString(string);
        if (n != -1) {
            return n;
        }
        int n2 = this.addUtf8(string);
        this.adjustSize();
        ConstantString constantString = new ConstantString(n2);
        n = this.index;
        this.constants[this.index++] = constantString;
        this.stringTable.put(string, new Index(n));
        return n;
    }

    public int lookupClass(String string) {
        Index index = this.classTable.get(string.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private int addClass_(String string) {
        int n = this.lookupClass(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        ConstantClass constantClass = new ConstantClass(this.addUtf8(string));
        n = this.index;
        this.constants[this.index++] = constantClass;
        this.classTable.put(string, new Index(n));
        return n;
    }

    public int addClass(String string) {
        return this.addClass_(string.replace('.', '/'));
    }

    public int addClass(ObjectType objectType) {
        return this.addClass(objectType.getClassName());
    }

    public int addArrayClass(ArrayType arrayType) {
        return this.addClass_(arrayType.getSignature());
    }

    public int lookupInteger(int n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger constantInteger;
            if (!(this.constants[i] instanceof ConstantInteger) || (constantInteger = (ConstantInteger)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int addInteger(int n) {
        int n2 = this.lookupInteger(n);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return n2;
    }

    public int lookupFloat(float f) {
        int n = Float.floatToIntBits(f);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat constantFloat;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((constantFloat = (ConstantFloat)this.constants[i]).getBytes()) != n) continue;
            return i;
        }
        return -1;
    }

    public int addFloat(float f) {
        int n = this.lookupFloat(f);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantFloat(f);
        return n;
    }

    public int lookupUtf8(String string) {
        Index index = this.utf8Table.get(string);
        return index != null ? index.index : -1;
    }

    public int addUtf8(String string) {
        int n = this.lookupUtf8(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantUtf8(string);
        this.utf8Table.put(string, new Index(n));
        return n;
    }

    public int lookupLong(long l) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong constantLong;
            if (!(this.constants[i] instanceof ConstantLong) || (constantLong = (ConstantLong)this.constants[i]).getBytes() != l) continue;
            return i;
        }
        return -1;
    }

    public int addLong(long l) {
        int n = this.lookupLong(l);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantLong(l);
        this.index += 2;
        return n;
    }

    public int lookupDouble(double d) {
        long l = Double.doubleToLongBits(d);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble constantDouble;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((constantDouble = (ConstantDouble)this.constants[i]).getBytes()) != l) continue;
            return i;
        }
        return -1;
    }

    public int addDouble(double d) {
        int n = this.lookupDouble(d);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantDouble(d);
        this.index += 2;
        return n;
    }

    public int lookupNameAndType(String string, String string2) {
        Index index = this.natTable.get(string + NAT_DELIM + string2);
        return index != null ? index.index : -1;
    }

    public int addNameAndType(String string, String string2) {
        int n = this.lookupNameAndType(string, string2);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addUtf8(string);
        int n3 = this.addUtf8(string2);
        n = this.index;
        this.constants[this.index++] = new ConstantNameAndType(n2, n3);
        this.natTable.put(string + NAT_DELIM + string2, new Index(n));
        return n;
    }

    public int lookupMethodref(String string, String string2, String string3) {
        Index index = this.cpTable.get(string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int lookupMethodref(MethodGen methodGen) {
        return this.lookupMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addMethodref(String string, String string2, String string3) {
        int n = this.lookupMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addNameAndType(string2, string3);
        int n3 = this.addClass(string);
        n = this.index;
        this.constants[this.index++] = new ConstantMethodref(n3, n2);
        this.cpTable.put(string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3, new Index(n));
        return n;
    }

    public int addMethodref(MethodGen methodGen) {
        return this.addMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupInterfaceMethodref(String string, String string2, String string3) {
        Index index = this.cpTable.get(string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen methodGen) {
        return this.lookupInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addInterfaceMethodref(String string, String string2, String string3) {
        int n = this.lookupInterfaceMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(n2, n3);
        this.cpTable.put(string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3, new Index(n));
        return n;
    }

    public int addInterfaceMethodref(MethodGen methodGen) {
        return this.addInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupFieldref(String string, String string2, String string3) {
        Index index = this.cpTable.get(string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int addFieldref(String string, String string2, String string3) {
        int n = this.lookupFieldref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.index;
        this.constants[this.index++] = new ConstantFieldref(n2, n3);
        this.cpTable.put(string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3, new Index(n));
        return n;
    }

    public Constant getConstant(int n) {
        return this.constants[n];
    }

    public void setConstant(int n, Constant constant) {
        this.constants[n] = constant;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] constantArray = new Constant[this.index];
        System.arraycopy(this.constants, 0, constantArray, 0, this.index);
        return new ConstantPool(constantArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.index; ++i) {
            stringBuffer.append(i + ")" + this.constants[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public int addConstant(Constant constant, ConstantPoolGen constantPoolGen) {
        Constant[] constantArray = constantPoolGen.getConstantPool().getConstantPool();
        switch (constant.getTag()) {
            case 8: {
                ConstantString constantString = (ConstantString)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantString.getStringIndex()];
                return this.addString(constantUtf8.getBytes());
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                return this.addClass(constantUtf8.getBytes());
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf82 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                return this.addNameAndType(constantUtf8.getBytes(), constantUtf82.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)constant).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)constant).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)constant).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)constant).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)constant).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP constantCP = (ConstantCP)constant;
                ConstantClass constantClass = (ConstantClass)constantArray[constantCP.getClassIndex()];
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantCP.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                String string = constantUtf8.getBytes().replace('/', '.');
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                String string2 = constantUtf8.getBytes();
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                String string3 = constantUtf8.getBytes();
                switch (constant.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(string, string2, string3);
                    }
                    case 10: {
                        return this.addMethodref(string, string2, string3);
                    }
                    case 9: {
                        return this.addFieldref(string, string2, string3);
                    }
                }
                throw new RuntimeException("Unknown constant type " + constant);
            }
        }
        throw new RuntimeException("Unknown constant type " + constant);
    }

    private java.util.HashMap<String, Index> createCompatibleHashMap(HashMap<String, Index> hashMap) {
        java.util.HashMap<String, Index> hashMap2 = new java.util.HashMap<String, Index>();
        if (hashMap != null) {
            hashMap2.putAll(hashMap);
        }
        return hashMap2;
    }

    private HashMap<String, Index> createJaxpHashMap(java.util.HashMap<String, Index> hashMap) {
        HashMap<String, Index> hashMap2 = new HashMap<String, Index>();
        if (hashMap != null) {
            hashMap2.putAll(hashMap);
        }
        return hashMap2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        java.util.HashMap<String, Index> hashMap = this.createCompatibleHashMap(this.stringTable);
        java.util.HashMap<String, Index> hashMap2 = this.createCompatibleHashMap(this.classTable);
        java.util.HashMap<String, Index> hashMap3 = this.createCompatibleHashMap(this.utf8Table);
        java.util.HashMap<String, Index> hashMap4 = this.createCompatibleHashMap(this.natTable);
        java.util.HashMap<String, Index> hashMap5 = this.createCompatibleHashMap(this.cpTable);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("size", this.size);
        putField.put("constants", this.constants);
        putField.put("index", this.index);
        putField.put("string_table", hashMap);
        putField.put("class_table", hashMap2);
        putField.put("utf8_table", hashMap3);
        putField.put("n_a_t_table", hashMap4);
        putField.put("cp_table", hashMap5);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.size = getField.get("size", 1024);
        this.constants = (Constant[])getField.get("constants", null);
        if (this.constants == null) {
            this.constants = new Constant[this.size];
        }
        this.index = getField.get("index", 1);
        this.stringTable = this.createJaxpHashMap((java.util.HashMap)getField.get("string_table", null));
        this.classTable = this.createJaxpHashMap((java.util.HashMap)getField.get("class_table", null));
        this.utf8Table = this.createJaxpHashMap((java.util.HashMap)getField.get("utf8_table", null));
        this.natTable = this.createJaxpHashMap((java.util.HashMap)getField.get("n_a_t_table", null));
        this.cpTable = this.createJaxpHashMap((java.util.HashMap)getField.get("cp_table", null));
    }

    private static class Index
    implements Serializable {
        int index;

        Index(int n) {
            this.index = n;
        }
    }
}

