/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.MissingFieldException;
import java.net.MalformedURLException;
import java.net.URL;

public class XMLUtils {
    public static int getIntAttribute(String string, XMLNode xMLNode, String string2, String string3, int n) throws BadFieldException {
        String string4 = XMLUtils.getAttribute(xMLNode, string2, string3);
        if (string4 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3, string4);
        }
    }

    public static int getRequiredIntAttribute(String string, XMLNode xMLNode, String string2, String string3) throws BadFieldException, MissingFieldException {
        String string4 = XMLUtils.getAttribute(xMLNode, string2, string3);
        if (string4 == null) {
            throw new MissingFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3);
        }
        try {
            return Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3, string4);
        }
    }

    public static String getAttribute(XMLNode xMLNode, String string, String string2) throws BadFieldException {
        return XMLUtils.getAttribute(xMLNode, string, string2, null);
    }

    public static String getRequiredAttributeEmptyOK(String string, XMLNode xMLNode, String string2, String string3) throws MissingFieldException {
        String string4 = null;
        XMLNode xMLNode2 = XMLUtils.findElementPath(xMLNode, string2);
        if (xMLNode2 != null) {
            string4 = xMLNode2.getAttribute(string3);
        }
        if (string4 == null) {
            throw new MissingFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3);
        }
        return string4;
    }

    public static String getRequiredAttribute(String string, XMLNode xMLNode, String string2, String string3) throws MissingFieldException, BadFieldException {
        String string4 = XMLUtils.getAttribute(xMLNode, string2, string3, null);
        if (string4 == null) {
            throw new MissingFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3);
        }
        return (string4 = string4.trim()).length() == 0 ? null : string4;
    }

    public static String getAttribute(XMLNode xMLNode, String string, String string2, String string3) throws BadFieldException {
        XMLNode xMLNode2 = XMLUtils.findElementPath(xMLNode, string);
        if (xMLNode2 == null) {
            return string3;
        }
        String string4 = xMLNode2.getAttribute(string2);
        if (string4 != null && string4.contains("\u0000")) {
            Trace.println((String)("invalid " + string2 + ": " + string4 + " - it contains null"), (TraceLevel)TraceLevel.SECURITY);
            throw new BadFieldException("", string + string2, string4);
        }
        return string4 == null || string4.length() == 0 ? string3 : string4;
    }

    public static URL getAttributeURL(String string, URL uRL, XMLNode xMLNode, String string2, String string3) throws BadFieldException {
        String string4 = XMLUtils.getAttribute(xMLNode, string2, string3);
        if (string4 == null) {
            return null;
        }
        try {
            int n;
            if (string4.startsWith("jar:") && (n = string4.indexOf("!/")) > 0) {
                String string5 = string4.substring(n);
                String string6 = string4.substring(4, n);
                URL uRL2 = uRL == null ? new URL(string6) : new URL(uRL, string6);
                return new URL("jar:" + uRL2.toString() + string5);
            }
            return uRL == null ? new URL(string4) : new URL(uRL, string4);
        }
        catch (MalformedURLException malformedURLException) {
            if (malformedURLException.getMessage().indexOf("https") != -1) {
                throw new BadFieldException(string, "<jnlp>", "https");
            }
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3, string4);
        }
    }

    public static URL getAttributeURL(String string, XMLNode xMLNode, String string2, String string3) throws BadFieldException {
        return XMLUtils.getAttributeURL(string, null, xMLNode, string2, string3);
    }

    public static URL getRequiredURL(String string, URL uRL, XMLNode xMLNode, String string2, String string3) throws BadFieldException, MissingFieldException {
        URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, string2, string3);
        if (uRL2 == null) {
            throw new MissingFieldException(string, XMLUtils.getPathString(xMLNode) + string2 + string3);
        }
        return uRL2;
    }

    public static URL getRequiredURL(String string, XMLNode xMLNode, String string2, String string3) throws BadFieldException, MissingFieldException {
        return XMLUtils.getRequiredURL(string, null, xMLNode, string2, string3);
    }

    public static boolean isElementPath(XMLNode xMLNode, String string) {
        return XMLUtils.findElementPath(xMLNode, string) != null;
    }

    public static URL getElementURL(String string, XMLNode xMLNode, String string2) throws BadFieldException {
        String string3 = XMLUtils.getElementContents(xMLNode, string2);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + string2, string3);
        }
    }

    public static String getPathString(XMLNode xMLNode) {
        return xMLNode == null || !xMLNode.isElement() ? "" : XMLUtils.getPathString(xMLNode.getParent()) + "<" + xMLNode.getName() + ">";
    }

    public static String getElementContentsWithAttribute(XMLNode xMLNode, String string, String string2, String string3, String string4) throws BadFieldException, MissingFieldException {
        XMLNode xMLNode2 = XMLUtils.getElementWithAttribute(xMLNode, string, string2, string3);
        if (xMLNode2 == null) {
            return string4;
        }
        return XMLUtils.getElementContents(xMLNode2, "", string4);
    }

    public static URL getAttributeURLWithAttribute(String string, XMLNode xMLNode, String string2, String string3, String string4, String string5, URL uRL) throws BadFieldException, MissingFieldException {
        XMLNode xMLNode2 = XMLUtils.getElementWithAttribute(xMLNode, string2, string3, string4);
        if (xMLNode2 == null) {
            return uRL;
        }
        URL uRL2 = XMLUtils.getAttributeURL(string, xMLNode2, "", string5);
        if (uRL2 == null) {
            return uRL;
        }
        return uRL2;
    }

    public static XMLNode getElementWithAttribute(XMLNode xMLNode, String string, final String string2, final String string3) throws BadFieldException, MissingFieldException {
        final XMLNode[] xMLNodeArray = new XMLNode[]{null};
        XMLUtils.visitElements(xMLNode, string, new ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                if (xMLNodeArray[0] == null && xMLNode.getAttribute(string2).equals(string3)) {
                    xMLNodeArray[0] = xMLNode;
                }
            }
        });
        return xMLNodeArray[0];
    }

    public static String getElementContents(XMLNode xMLNode, String string) {
        return XMLUtils.getElementContents(xMLNode, string, null);
    }

    public static String getElementContents(XMLNode xMLNode, String string, String string2) {
        XMLNode xMLNode2 = XMLUtils.findElementPath(xMLNode, string);
        if (xMLNode2 == null) {
            return string2;
        }
        XMLNode xMLNode3 = xMLNode2.getNested();
        if (xMLNode3 != null && !xMLNode3.isElement()) {
            return xMLNode3.getName();
        }
        return string2;
    }

    public static XMLNode findElementPath(XMLNode xMLNode, String string) {
        if (xMLNode == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return xMLNode;
        }
        int n = string.indexOf(62);
        if (string.charAt(0) != '<') {
            throw new IllegalArgumentException("bad path. Missing begin tag");
        }
        if (n == -1) {
            throw new IllegalArgumentException("bad path. Missing end tag");
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        return XMLUtils.findElementPath(XMLUtils.findChildElement(xMLNode, string2), string3);
    }

    public static XMLNode findChildElement(XMLNode xMLNode, String string) {
        for (XMLNode xMLNode2 = xMLNode.getNested(); xMLNode2 != null; xMLNode2 = xMLNode2.getNext()) {
            if (!xMLNode2.isElement() || !xMLNode2.getName().equals(string)) continue;
            return xMLNode2;
        }
        return null;
    }

    public static void visitElements(XMLNode xMLNode, String string, ElementVisitor elementVisitor) throws BadFieldException, MissingFieldException {
        int n = string.lastIndexOf(60);
        if (n == -1) {
            throw new IllegalArgumentException("bad path. Must contain atleast one tag");
        }
        if (string.length() == 0 || string.charAt(string.length() - 1) != '>') {
            throw new IllegalArgumentException("bad path. Must end with a >");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        XMLNode xMLNode2 = XMLUtils.findElementPath(xMLNode, string2);
        if (xMLNode2 == null) {
            return;
        }
        for (XMLNode xMLNode3 = xMLNode2.getNested(); xMLNode3 != null; xMLNode3 = xMLNode3.getNext()) {
            if (!xMLNode3.isElement() || !xMLNode3.getName().equals(string3)) continue;
            elementVisitor.visitElement(xMLNode3);
        }
    }

    public static void visitChildrenElements(XMLNode xMLNode, ElementVisitor elementVisitor) throws BadFieldException, MissingFieldException {
        for (XMLNode xMLNode2 = xMLNode.getNested(); xMLNode2 != null; xMLNode2 = xMLNode2.getNext()) {
            if (!xMLNode2.isElement()) continue;
            elementVisitor.visitElement(xMLNode2);
        }
    }

    public static abstract class ElementVisitor {
        public abstract void visitElement(XMLNode var1) throws BadFieldException, MissingFieldException;
    }
}

