/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import hr.iii.fiskal.xml.QRCodeRequest;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.Response;
import hr.iii.fiskal.xml.XmlRecord;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumMap;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QRCodeResponse
extends Response {
    public static final String TAG = "tns:QRCodeResponse";

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public XmlRecord createAnswer(Request request) {
        XmlRecord xml = this.createXml(request);
        Node nodeResponse = xml.getDocument().getElementsByTagName("Response").item(0);
        try {
            String base64 = QRCodeResponse.getQrCode(request);
            Element QRelement = xml.getDocument().createElement("QRCode");
            QRelement.setTextContent(base64);
            nodeResponse.appendChild(QRelement);
            FileOutputStream fileOuputStream = null;
            try {
                QRCodeRequest qrCodeRequest = (QRCodeRequest)request;
                fileOuputStream = new FileOutputStream("qrcode." + qrCodeRequest.getBitMapType());
                fileOuputStream.write(Base64.decodeBase64(base64));
                fileOuputStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Element nodeSifraGreske = xml.getDocument().createElement("SifraGreske");
            nodeSifraGreske.setTextContent("I99");
            nodeResponse.appendChild(nodeSifraGreske);
            Element nodePorukaGreske = xml.getDocument().createElement("PorukaGreske");
            nodePorukaGreske.setTextContent(e.getMessage());
            nodeResponse.appendChild(nodePorukaGreske);
        }
        return xml;
    }

    public static String getQrCode(Request request) throws Exception {
        QRCodeRequest qrCodeRequest = (QRCodeRequest)request;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String qrString = qrCodeRequest.getText();
        EnumMap<EncodeHintType, Integer> hints = null;
        hints = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
        hints.put(EncodeHintType.MARGIN, qrCodeRequest.getBorder());
        BitMatrix bitMatrix = new QRCodeWriter().encode(qrString, BarcodeFormat.QR_CODE, qrCodeRequest.getWidth(), qrCodeRequest.getHeight(), hints);
        MatrixToImageWriter.writeToStream(bitMatrix, qrCodeRequest.getBitMapType(), out);
        return new String(Base64.encodeBase64(out.toByteArray()));
    }
}

