/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.DateFileHandler;
import hr.iii.fiskal.LogFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Proxy {
    private boolean running = true;
    private static Proxy proxy = new Proxy();
    private String[] args;

    public static void windowsService(String[] args) {
        String cmd = "start";
        if (args.length > 0) {
            cmd = args[0];
        }
        if ("start".equals(cmd)) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.S ");
                String strDate = formatter.format(new Date());
                System.out.println(strDate + " Pokretanje I3Fiskal servisa");
                proxy.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            proxy.stop();
        }
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    private boolean getRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.S ");
        String strDate = formatter.format(new Date());
        System.out.println(strDate + " Zaustavljanje I3Fiskal servisa");
        this.setRunning(false);
        Proxy proxy = this;
        synchronized (proxy) {
            this.notify();
        }
    }

    private void start() throws Exception {
        if (AppContext.getContext().getDebugSSL() > 0) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.conn", "DEBUG");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.client", "DEBUG");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.client", "DEBUG");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "DEBUG");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "DEBUG");
        }
        System.setProperty("hr.iii.fiskal.DateFileHandler.encoding", "UTF-8");
        Logger logger = Logger.getLogger("com.sun.net.httpserver");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new LogFormatter());
        consoleHandler.setEncoding("UTF-8");
        DateFileHandler fileHandler = null;
        try {
            System.out.println(AppContext.getLogDir() + "i3fiskal-http-%d.log Max Log Days=" + AppContext.getContext().getMaxLogDays().toString());
            fileHandler = new DateFileHandler(AppContext.getLogDir() + "i3fiskal-http-%d.log", AppContext.getContext().getMaxLogDays());
            fileHandler.setFormatter(new LogFormatter());
            fileHandler.setEncoding("UTF-8");
            logger.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.setLevel(Level.ALL);
        Logger reqLogger = Logger.getLogger("hr.iii.fiskal.request");
        DateFileHandler reqFileHandler = null;
        try {
            reqFileHandler = new DateFileHandler(AppContext.getLogDir() + "request-%d.log", AppContext.getContext().getMaxLogDays());
            reqFileHandler.setEncoding("UTF-8");
            reqFileHandler.setFormatter(new LogFormatter());
            reqLogger.addHandler(reqFileHandler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        reqLogger.setLevel(Level.ALL);
        Logger appLogger = Logger.getLogger("hr.iii.fiskal.proxy");
        DateFileHandler appFileHandler = null;
        try {
            appFileHandler = new DateFileHandler(AppContext.getLogDir() + "proxy-%d.log", AppContext.getContext().getMaxLogDays());
            appFileHandler.setFormatter(new LogFormatter());
            appFileHandler.setEncoding("UTF-8");
            appLogger.addHandler(appFileHandler);
            appLogger.addHandler(consoleHandler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        appLogger.info("Pokretanje I3Fiskala");
        appLogger.info("\u0161\u0111\u010d\u0107\u017e\u0160\u0110\u010c\u0106\u017d");
        appLogger.setLevel(Level.ALL);
        AppContext.getContext().startUIServer();
        AppContext.getContext().startProxyServer();
        this.PreloadClasses(false);
        appLogger.info("I3Fiskal je pokrenut");
        long startTimer = System.currentTimeMillis();
        this.setRunning(true);
        int minutes = 0;
        X509Certificate cert = AppContext.getContext().getServerCertificate("serverapp");
        while (this.getRunning()) {
            if (System.currentTimeMillis() - startTimer > 60000L) {
                startTimer = System.currentTimeMillis();
                this.PreloadClasses(true);
                if (minutes > 9) {
                    minutes = 0;
                    AppContext.getContext().checkServerCertificates();
                }
                ++minutes;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        appLogger.info("Zaustavljanje I3Fiskal servisa");
        AppContext.getContext().stopProxyServer();
        AppContext.getContext().getHttpsClient(new URL(AppContext.getContext().getServerURL())).getConnectionManager().shutdown();
        AppContext.getContext().stopUIServer();
        appLogger.info("I3Fiskal servis je zaustavljen");
        for (Handler h : appLogger.getHandlers()) {
            h.close();
        }
        for (Handler h : reqLogger.getHandlers()) {
            h.close();
        }
        for (Handler h : logger.getHandlers()) {
            h.close();
        }
    }

    private void PreloadClasses(boolean onlyEcho) {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        if (!onlyEcho) {
            logger.info("Inicijalno u\u010ditavanje java klasa");
            ArrayList<String> listOfClassNamesToLoad = new ArrayList<String>(Arrays.asList("hr.iii.fiskal.AppContext", "hr.iii.fiskal.RequestHandler", "hr.iii.fiskal.xml.RacunRequest", "hr.iii.fiskal.xml.ProstorRequest", "hr.iii.fiskal.xml.RacunResponse", "hr.iii.fiskal.xml.ProstorResponse", "hr.iii.fiskal.soapssl.SoapMessage", "hr.iii.fiskal.soapssl.SSLClient", "javax.net.ssl.HttpsURLConnection", "javax.net.ssl.SSLContext", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.TrustManagerFactory"));
            for (String className : listOfClassNamesToLoad) {
                try {
                    Class<?> clazz = Class.forName(className);
                    String n = clazz.getName();
                    Compiler.compileClass(clazz);
                }
                catch (Exception e) {
                    System.err.println("Could not load class: " + className);
                    System.err.println(e);
                    logger.warning("Nije uspjelo u\u010ditavanje klase: " + className + ": " + e.getMessage());
                }
            }
        }
        logger.info("Slanje Echo poruke fiskalizacijskom serveru");
        try {
            String line;
            String echoStr = "<tns:EchoRequest xmlns:tns=\"http://www.apis-it.hr/fin/2012/types/f73\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.apis-it.hr/fin/2012/types/f73 FiskalizacijaSchema.xsd \">Provjera</tns:EchoRequest>";
            Integer serverPort = AppContext.getContext().getHttpPort();
            URL url = new URL("http://127.0.0.1:" + serverPort.toString() + "/");
            HttpURLConnection con = null;
            con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            BufferedWriter wr = null;
            wr = new BufferedWriter(new OutputStreamWriter(con.getOutputStream()));
            wr.write(echoStr);
            wr.flush();
            wr.close();
            InputStream is = null;
            int responseCode = con.getResponseCode();
            is = responseCode == 200 ? con.getInputStream() : con.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
            }
            con.disconnect();
        }
        catch (Exception e) {
            System.err.println("Class preloader: " + e.getMessage());
            e.printStackTrace();
            logger.warning("Nije uspjelo slanje Echo poruke fiskalizacijskom serveru: " + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equalsIgnoreCase("version")) {
            System.out.println("I3Fiskal");
            System.out.println("Ver: " + AppContext.getContext().getVersion());
            System.out.println("Log dir: " + AppContext.getLogDir());
            return;
        }
        proxy.start();
        System.exit(0);
    }
}

