/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpServer;
import hr.iii.fiskal.AppKeyStoreException;
import hr.iii.fiskal.RequestHandler;
import hr.iii.fiskal.Statistics;
import hr.iii.fiskal.ui.KeyStoreHandler;
import hr.iii.fiskal.ui.LogsHandler;
import hr.iii.fiskal.ui.MenuHandler;
import hr.iii.fiskal.ui.ParamHandler;
import hr.iii.fiskal.ui.StatsHandler;
import hr.iii.fiskal.ui.UIParamHandler;
import hr.iii.util.http.server.DefaultHttpHandler;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class AppContext {
    private String verzija = "4.0.3";
    private String keystoreCrypted = "ceab8d96b9cecab4bece";
    private String testOIB = "";
    private String userInfo = "DEMO";
    private HttpServer httpServer = null;
    private HttpServer httpsServer = null;
    private Integer httpPort = 8080;
    private Integer httpsPort = 8081;
    private Integer debugSSL = 5;
    private String qrCodeURL = "https://porezna.gov.hr/rn";
    private String serverUrl = "https://cistest.apis-it.hr:8449/FiskalizacijaServiceTest";
    private Integer sslTimeout = 2000;
    private Integer poolSize = 5;
    private Integer persistentConnections = 5;
    static final String clientKeyStoreName = "client.jks";
    static final String serverKeyStoreName = "server.jks";
    static String keyStorePassword = "";
    static String adminPassword = "";
    private Boolean keyStoreAccess = false;
    private Boolean serverKeyStoreAccess = false;
    private Boolean propertiesAccess = false;
    private Boolean httpsClientAccess = false;
    private KeyStore keyStore = null;
    private KeyStore serverKeyStore = null;
    private Statistics stats = null;
    private HttpClient httpsClient = null;
    private static AppContext appContext = null;
    private Integer maxLogDays = 60;

    public static String getLogDir() {
        String logDir = System.getProperty("log.dir");
        if (null == logDir) {
            return "";
        }
        if (logDir.endsWith(System.getProperty("file.separator"))) {
            return logDir;
        }
        return logDir + System.getProperty("file.separator");
    }

    public static synchronized AppContext getContext() {
        if (appContext == null) {
            appContext = new AppContext();
            try {
                appContext.loadProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return appContext;
    }

    private String decrypt(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            int n = i / 2;
            data[n] = ~data[n];
        }
        return new String(data);
    }

    private String encrypt(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = (byte)(a[n] ^ 0xFF);
            sb.append(Character.forDigit((a[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(a[i] & 0xF, 16));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() throws IOException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        FileInputStream fIn = null;
        fIn = new FileInputStream("i3fiskal.properties");
        Properties properties = new Properties();
        properties.load(fIn);
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            try {
                logger.fine("U\u010ditavanje parametara servisa");
                this.testOIB = properties.getProperty("test-oib", "");
                this.userInfo = properties.getProperty("user-info", "");
                keyStorePassword = this.decrypt(this.keystoreCrypted);
                adminPassword = this.decrypt(properties.getProperty("ui-secret", ""));
                this.serverUrl = properties.getProperty("fiskal-server-url", "https://cistest.apis-it.hr:8449/FiskalizacijaServiceTest");
                this.sslTimeout = Integer.parseInt(properties.getProperty("fiskal-server-timeout", "2000"));
                this.persistentConnections = Integer.parseInt(properties.getProperty("fiskal-server-persistents", "5"));
                this.httpPort = Integer.parseInt(properties.getProperty("proxy-http-port", "8080"));
                this.httpsPort = Integer.parseInt(properties.getProperty("proxy-https-port", "8081"));
                this.poolSize = Integer.parseInt(properties.getProperty("proxy-pool-size", "5"));
                this.debugSSL = Integer.parseInt(properties.getProperty("debug-ssl", "0"));
                this.maxLogDays = Integer.parseInt(properties.getProperty("max-log-days", "60"));
                this.qrCodeURL = properties.getProperty("qrcode-url", "https://porezna.gov.hr/rn");
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri u\u010ditavanju parametara: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperties() throws IOException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        FileOutputStream fOut = null;
        fOut = new FileOutputStream("i3fiskal.properties");
        Properties properties = new Properties();
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            logger.fine("Spremanje parametara servisa");
            properties.put("test-oib", this.testOIB);
            properties.put("user-info", this.userInfo);
            properties.put("ui-secret", this.encrypt(adminPassword.getBytes()));
            properties.put("fiskal-server-url", this.serverUrl);
            properties.put("fiskal-server-timeout", this.sslTimeout.toString());
            properties.put("fiskal-server-persistents", this.persistentConnections.toString());
            properties.put("proxy-https-port", this.httpsPort.toString());
            properties.put("proxy-http-port", this.httpPort.toString());
            properties.put("proxy-pool-size", this.poolSize.toString());
            properties.put("debug-ssl", this.debugSSL.toString());
            properties.put("max-log-days", this.maxLogDays.toString());
            properties.put("qrcode-url", this.qrCodeURL);
            properties.store(fOut, "Spremljeno kroz UI su\u010delje");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore() throws AppKeyStoreException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.keyStoreAccess;
        synchronized (bl) {
            if (this.keyStore != null) {
                return this.keyStore;
            }
            try {
                logger.fine("U\u010ditavanje aplikacijskih certifikata");
                this.keyStore = KeyStore.getInstance("JKS");
                this.keyStore.load(new FileInputStream(clientKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.keyStore = null;
                logger.warning("Gre\u0161ka pri u\u010ditavanju aplikacijskih certifikata: " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            return this.keyStore;
        }
    }

    public String getAdminPassword() {
        return adminPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdminPassword(String val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            adminPassword = val;
        }
    }

    public Integer getMaxLogDays() {
        return this.maxLogDays;
    }

    public String getQrCodeURL() {
        return this.qrCodeURL;
    }

    public void setMaxLogDays(int maxLogDays) {
        this.maxLogDays = maxLogDays;
    }

    public String getKeyStorePassword() {
        return keyStorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getServerKeyStore() throws AppKeyStoreException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.serverKeyStoreAccess;
        synchronized (bl) {
            if (this.serverKeyStore != null) {
                return this.serverKeyStore;
            }
            try {
                logger.info("U\u010ditavanje certifikata porezne uprave");
                this.serverKeyStore = KeyStore.getInstance("JKS");
                this.serverKeyStore.load(new FileInputStream(serverKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                try {
                    this.serverKeyStore = KeyStore.getInstance("JKS");
                    this.serverKeyStore.load(null, keyStorePassword.toCharArray());
                    this.serverKeyStore.store(new FileOutputStream(serverKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e1) {
                    logger.warning("Gre\u0161ka pri u\u010ditavanju u certifikata porezne uprave: " + e.getMessage());
                    throw new AppKeyStoreException(e.getMessage(), e.getCause());
                }
            }
            return this.serverKeyStore;
        }
    }

    public X509Certificate getServerCertificate(String alias) {
        Enumeration<String> entries = null;
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            entries = this.getServerKeyStore().aliases();
            X509Certificate prevCert = null;
            X509Certificate cert = null;
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement();
                if (!entry.startsWith(alias)) continue;
                cert = (X509Certificate)AppContext.getContext().getServerKeyStore().getCertificate(entry);
                Date today = new Date();
                System.out.println(entry + ": " + formatter.format(cert.getNotBefore()) + " - " + formatter.format(cert.getNotAfter()));
                if (today.after(cert.getNotAfter()) || today.before(cert.getNotBefore())) {
                    cert = prevCert;
                    continue;
                }
                if (null != prevCert && cert.getNotBefore().after(prevCert.getNotBefore())) {
                    cert = prevCert;
                    continue;
                }
                prevCert = cert;
            }
            return cert;
        }
        catch (Exception e) {
            return null;
        }
    }

    public KeyStore.PrivateKeyEntry getPrivateKey(String alias) throws AppKeyStoreException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.PrivateKeyEntry keyEntry = null;
        KeyStore keyStore = AppContext.getContext().getKeyStore();
        Enumeration<String> entries = keyStore.aliases();
        while (entries.hasMoreElements()) {
            String entry = entries.nextElement();
            if (!entry.startsWith(alias)) continue;
            Date today = new Date();
            keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(entry, new KeyStore.PasswordProtection(AppContext.getContext().getKeyStorePassword().toCharArray()));
            X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
            if (!today.after(cert.getNotAfter()) && !today.before(cert.getNotBefore())) break;
            keyEntry = null;
        }
        if (keyEntry == null) {
            throw new AppKeyStoreException("Nije prona\u0111en va\u017ee\u0107i  certifikat");
        }
        return keyEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrivateKey(String alias) throws AppKeyStoreException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.keyStoreAccess;
        synchronized (bl) {
            KeyStore tmpStore = null;
            Object keyEntry = null;
            try {
                logger.fine("Brisanje aplikacijskog certifikata");
                tmpStore = KeyStore.getInstance("JKS");
                try {
                    tmpStore.load(new FileInputStream(clientKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    tmpStore.load(null, keyStorePassword.toCharArray());
                }
                tmpStore.deleteEntry(alias);
                tmpStore.store(new FileOutputStream(clientKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri brisanju  certifikata " + alias + ": " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            this.keyStore = tmpStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrivateKey(String alias, KeyStore.PrivateKeyEntry key) throws AppKeyStoreException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.keyStoreAccess;
        synchronized (bl) {
            KeyStore tmpStore = null;
            try {
                logger.fine("Spremanje aplikacijskog certifikata " + alias);
                tmpStore = KeyStore.getInstance("JKS");
                try {
                    tmpStore.load(new FileInputStream(clientKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    tmpStore.load(null, keyStorePassword.toCharArray());
                }
                Integer index = 0;
                Enumeration<String> entries = tmpStore.aliases();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement();
                    int nextIndex = 0;
                    if (entry.startsWith(alias)) {
                        nextIndex = entry.lastIndexOf(35) > 0 ? Integer.parseInt(entry.substring(entry.lastIndexOf(35) + 1)) : 0;
                        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)tmpStore.getEntry(entry, new KeyStore.PasswordProtection(AppContext.getContext().getKeyStorePassword().toCharArray()));
                        X509Certificate certOld = (X509Certificate)keyEntry.getCertificate();
                        X509Certificate certNew = (X509Certificate)key.getCertificate();
                        if (certOld.getSerialNumber() == certNew.getSerialNumber()) {
                            index = nextIndex;
                            break;
                        }
                    }
                    if (index > nextIndex) continue;
                    index = nextIndex + 1;
                }
                tmpStore.setEntry(alias + "#" + index.toString(), key, new KeyStore.PasswordProtection(this.getKeyStorePassword().toCharArray()));
                tmpStore.store(new FileOutputStream(clientKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri spremanju aplikacijskog certifikata " + alias + ": " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            this.keyStore = tmpStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificate(String alias) throws AppKeyStoreException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.serverKeyStoreAccess;
        synchronized (bl) {
            logger.fine("Brisanje certifikata  " + alias);
            KeyStore tmpStore = null;
            try {
                tmpStore = KeyStore.getInstance("JKS");
                try {
                    tmpStore.load(new FileInputStream(serverKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    tmpStore.load(null, keyStorePassword.toCharArray());
                }
                tmpStore.deleteEntry(alias);
                tmpStore.store(new FileOutputStream(serverKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri brisanju  certifikata " + alias + ": " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            this.serverKeyStore = tmpStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertifikate(String alias, X509Certificate cert) throws AppKeyStoreException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.serverKeyStoreAccess;
        synchronized (bl) {
            logger.fine("Spremanje certifikata  " + alias);
            KeyStore tmpStore = null;
            try {
                tmpStore = KeyStore.getInstance("JKS");
                try {
                    tmpStore.load(new FileInputStream(serverKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    tmpStore.load(null, keyStorePassword.toCharArray());
                }
                Integer index = 0;
                Enumeration<String> entries = tmpStore.aliases();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement();
                    int nextIndex = 0;
                    if (entry.startsWith(alias)) {
                        nextIndex = entry.lastIndexOf(35) > 0 ? Integer.parseInt(entry.substring(entry.lastIndexOf(35) + 1)) : 0;
                        X509Certificate certOld = (X509Certificate)AppContext.getContext().getServerKeyStore().getCertificate(entry);
                        if (certOld.getSerialNumber() == cert.getSerialNumber()) {
                            index = nextIndex;
                            break;
                        }
                    }
                    if (index > nextIndex) continue;
                    index = nextIndex + 1;
                }
                tmpStore.setCertificateEntry(alias + "#" + index.toString(), cert);
                tmpStore.store(new FileOutputStream(serverKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri spremanju certifikata " + alias + ": " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            this.serverKeyStore = tmpStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldCertificates() throws AppKeyStoreException {
        KeyStore tmpStore;
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        Boolean bl = this.serverKeyStoreAccess;
        synchronized (bl) {
            logger.fine("Brisanje isteklih serverskih certifikata");
            tmpStore = null;
            try {
                tmpStore = KeyStore.getInstance("JKS");
                try {
                    tmpStore.load(new FileInputStream(serverKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    tmpStore.load(null, keyStorePassword.toCharArray());
                }
                Integer index = 0;
                Enumeration<String> entries = tmpStore.aliases();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement();
                    Date today = new Date();
                    X509Certificate cert = (X509Certificate)AppContext.getContext().getServerKeyStore().getCertificate(entry);
                    if (!today.after(cert.getNotAfter())) continue;
                    logger.fine("Brisanje certifikata: " + entry);
                    tmpStore.deleteEntry(entry);
                }
                tmpStore.store(new FileOutputStream(serverKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri brisanju serverskih certifikata: " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            try {
                if (this.httpsClient != null) {
                    this.httpsClient.getConnectionManager().shutdown();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.httpsClient = null;
            this.serverKeyStore = tmpStore;
        }
        bl = this.keyStoreAccess;
        synchronized (bl) {
            tmpStore = null;
            KeyStore.PrivateKeyEntry keyEntry = null;
            try {
                logger.fine("Brisanje isteklih aplikacijskih certifikata");
                tmpStore = KeyStore.getInstance("JKS");
                try {
                    tmpStore.load(new FileInputStream(clientKeyStoreName), keyStorePassword.toCharArray());
                }
                catch (Exception e) {
                    tmpStore.load(null, keyStorePassword.toCharArray());
                }
                Integer index = 0;
                Enumeration<String> entries = tmpStore.aliases();
                while (entries.hasMoreElements()) {
                    Date today = new Date();
                    String entry = entries.nextElement();
                    keyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(entry, new KeyStore.PasswordProtection(AppContext.getContext().getKeyStorePassword().toCharArray()));
                    X509Certificate keyCert = (X509Certificate)keyEntry.getCertificate();
                    if (!today.after(keyCert.getNotAfter())) continue;
                    logger.fine("Brisanje certifikata: " + entry);
                    tmpStore.deleteEntry(entry);
                }
                tmpStore.store(new FileOutputStream(clientKeyStoreName), keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                logger.warning("Gre\u0161ka pri brisanju aplikacijskih certifikata: " + e.getMessage());
                throw new AppKeyStoreException(e.getMessage(), e.getCause());
            }
            this.keyStore = tmpStore;
        }
    }

    public void checkServerCertificates() {
    }

    public int getMaxPersistentConnections() {
        return this.persistentConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPersistentConnections(Integer val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.persistentConnections = val;
        }
    }

    public String getServerURL() {
        return this.serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerURL(String val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.serverUrl = val;
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpPort(Integer val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.httpPort = val;
        }
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpsPort(Integer val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.httpsPort = val;
        }
    }

    public synchronized Statistics getStatistics() {
        if (this.stats == null) {
            this.stats = new Statistics();
        }
        return this.stats;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolSize(Integer val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.poolSize = val;
        }
    }

    public int getSSLTimeout() {
        return this.sslTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSSLTimeout(Integer val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.sslTimeout = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServer startProxyServer() throws IOException {
        if (this.httpServer != null) {
            HttpServer httpServer = this.httpServer;
            synchronized (httpServer) {
                this.stopProxyServer();
            }
        }
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        logger.info("Pokretanje Proxy servera na portu: " + this.getHttpPort());
        this.loadProperties();
        this.httpServer = HttpServer.create(new InetSocketAddress(this.getHttpPort()), 1000);
        this.httpServer.createContext("/", new RequestHandler());
        this.httpServer.setExecutor(Executors.newFixedThreadPool(this.getPoolSize()));
        this.httpServer.start();
        return this.httpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProxyServer() {
        if (this.httpServer != null) {
            HttpServer httpServer = this.httpServer;
            synchronized (httpServer) {
                Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
                logger.info("Zaustavljanje Proxy servera");
                this.httpServer.stop(0);
                ((ThreadPoolExecutor)this.httpServer.getExecutor()).shutdownNow();
                this.httpServer = null;
                try {
                    if (this.httpsClient != null) {
                        this.httpsClient.getConnectionManager().shutdown();
                    }
                }
                catch (Exception e) {
                    logger.info("Problem pri zaustavljanju Proxy servera: " + e.getMessage());
                }
                this.httpsClient = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServer startUIServer() throws Exception {
        if (this.httpsServer != null) {
            HttpServer httpServer = this.httpsServer;
            synchronized (httpServer) {
                this.stopUIServer();
            }
        }
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        logger.info("Pokretanje UI servera na portu: " + this.getHttpsPort());
        this.loadProperties();
        try {
            HttpsAuthenticator httpsAuth = new HttpsAuthenticator("I3Fiskal - Prijava korisnika");
            this.httpsServer = HttpServer.create(new InetSocketAddress(this.getHttpsPort()), 10);
            this.httpsServer.setExecutor(Executors.newFixedThreadPool(3));
            this.httpsServer.createContext("/", new MenuHandler());
            this.httpsServer.createContext("/logs", new LogsHandler()).setAuthenticator(httpsAuth);
            this.httpsServer.createContext("/param", new ParamHandler()).setAuthenticator(httpsAuth);
            this.httpsServer.createContext("/uiparam", new UIParamHandler()).setAuthenticator(httpsAuth);
            this.httpsServer.createContext("/stats", new StatsHandler());
            this.httpsServer.createContext("/ks", new KeyStoreHandler()).setAuthenticator(httpsAuth);
            this.httpsServer.createContext("/js", new DefaultHttpHandler());
            this.httpsServer.createContext("/res", new DefaultHttpHandler());
            this.httpsServer.createContext("/css", new DefaultHttpHandler());
            this.httpsServer.createContext("/download", new DefaultHttpHandler());
            this.httpsServer.start();
        }
        catch (Exception e) {
            logger.warning("Neuspjelo pokretanje https servera: " + e.getMessage());
            throw new Exception(e.getMessage(), e.getCause());
        }
        return this.httpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUIServer() {
        if (this.httpsServer != null) {
            HttpServer httpServer = this.httpsServer;
            synchronized (httpServer) {
                Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
                logger.info("Zaustavljanje UI servera");
                this.httpsServer.stop(0);
                ((ThreadPoolExecutor)this.httpsServer.getExecutor()).shutdownNow();
                this.httpsServer = null;
            }
        }
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserInfo(String val) {
        Boolean bl = this.propertiesAccess;
        synchronized (bl) {
            this.userInfo = val;
        }
    }

    public String getTestOIB() {
        return this.testOIB;
    }

    public String getVersion() {
        return this.verzija;
    }

    public Integer getDebugSSL() {
        return this.debugSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpsClient(URL serverUrl) throws AppKeyStoreException {
        Boolean bl = this.httpsClientAccess;
        synchronized (bl) {
            if (this.httpsClient == null) {
                Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
                logger.fine("Kreiranje connection pool-a za " + serverUrl.toString() + " (veli\u010dina pool-a: " + this.getMaxPersistentConnections() + ")");
                SSLSocketFactory sslFactory = null;
                try {
                    TrustStrategy acceptingTrustStrategy = new TrustStrategy(){

                        @Override
                        public boolean isTrusted(X509Certificate[] certificate, String authType) {
                            return true;
                        }
                    };
                    sslFactory = this.getServerCertificate("serverssl") != null ? new SSLSocketFactory("TLSv1.2", this.getKeyStore(), keyStorePassword, this.getServerKeyStore(), null, acceptingTrustStrategy, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new SSLSocketFactory("TLSv1.2", this.getKeyStore(), keyStorePassword, null, null, acceptingTrustStrategy, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                }
                catch (Exception e) {
                    logger.warning("Gre\u0161ka pri kreiranju connection pool-a za " + serverUrl.toString() + ": " + e.getMessage());
                    throw new AppKeyStoreException(e.getMessage(), e.getCause());
                }
                Scheme sch = new Scheme(serverUrl.getProtocol(), serverUrl.getPort(), sslFactory);
                PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
                cm.setMaxTotal(100);
                cm.setDefaultMaxPerRoute(this.getMaxPersistentConnections());
                this.httpsClient = new DefaultHttpClient(cm);
                this.httpsClient.getConnectionManager().getSchemeRegistry().register(sch);
                HttpParams params = this.httpsClient.getParams();
                HttpConnectionParams.setConnectionTimeout(params, this.getSSLTimeout());
                HttpConnectionParams.setSoTimeout(params, this.getSSLTimeout() * 3);
                params.setParameter("http.connection.timeout", this.getSSLTimeout());
                params.setParameter("http.socket.timeout", this.getSSLTimeout() * 3);
            }
            return this.httpsClient;
        }
    }

    static class HttpsAuthenticator
    extends BasicAuthenticator {
        public HttpsAuthenticator(String arg0) {
            super(arg0);
        }

        @Override
        public boolean checkCredentials(String username, String password) {
            return username.toLowerCase().equals("iii") ? password.equals(AppContext.getContext().getKeyStorePassword()) : username.toLowerCase().equals("admin") && password.equals(AppContext.getContext().getAdminPassword());
        }
    }
}

