/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.association.utility.DesktopEntryFile;
import com.sun.deploy.association.utility.GnomeAssociationUtil;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.IcoEncoder;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class UnixInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "installed.desktop";
    private static final String INSTALLED_DESKTOP_SHORTCUT_GNOME26_KEY = "installed.desktop.gnome26";
    private static final String INSTALLED_DIRECTORY_KEY = "installed.directory";
    private static final String INSTALLED_GNOME_START_MENU_KEY = "installed.menu";
    private static final String INSTALLED_UNINSTALL_KEY = "installed.uninstalled";
    private static final String INSTALLED_RC_KEY = "installed.rc";
    private final String nameBadChars = "\"\\/|:?*<>#";
    private final String dirBadChars = "\"|:?*<>#";

    public boolean isShortcutExists(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String string2 = localApplicationProperties.get(INSTALLED_GNOME_START_MENU_KEY);
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_GNOME26_KEY);
        }
        if (string != null) {
            bl = new DesktopEntryFile(string).exists();
        }
        if (string2 != null) {
            bl2 = new DesktopEntryFile(string2).exists();
        }
        if (string != null && string2 != null) {
            return bl && bl2;
        }
        return bl || bl2;
    }

    public boolean[] whichShortcutsExist(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String string2 = localApplicationProperties.get(INSTALLED_GNOME_START_MENU_KEY);
        if (string == null) {
            string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_GNOME26_KEY);
        }
        boolean[] blArray = new boolean[]{string != null && new DesktopEntryFile(string).exists(), string2 != null && new DesktopEntryFile(string2).exists()};
        return blArray;
    }

    public String getAssociationPrintCommand(String string) {
        return null;
    }

    public String getAssociationOpenCommand(String string) {
        return Config.getJavawsCommand() + " " + string + " -open";
    }

    public void registerAssociationInternal(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Environment.isSystemCacheMode()) {
            associationService.registerSystemAssociation(association);
        } else {
            associationService.registerUserAssociation(association);
        }
    }

    public void unregisterAssociationInternal(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Environment.isSystemCacheMode()) {
            associationService.unregisterSystemAssociation(association);
        } else {
            associationService.unregisterUserAssociation(association);
        }
    }

    public boolean hasAssociation(Association association) {
        AssociationService associationService = new AssociationService();
        return associationService.hasAssociation(association);
    }

    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        Trace.println((String)"createShortcuts called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        File file = null;
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        boolean bl = shortcutDesc == null ? true : shortcutDesc.getDesktop();
        boolean bl2 = shortcutDesc == null ? true : shortcutDesc.getMenu();
        boolean bl3 = false;
        boolean bl4 = true;
        if (Environment.isSystemCacheMode()) {
            bl = false;
            bl3 = true;
        }
        if (blArray != null) {
            bl = bl && blArray[0];
            boolean bl5 = bl2 = bl2 && blArray[1];
        }
        if (!new DesktopEntryFile("applications-all-users:///").exists()) {
            Trace.println((String)"Found old gnome vfs api, don't create start menu", (TraceLevel)TraceLevel.TEMP);
            bl2 = false;
        }
        if (this.isShortcutExists(localApplicationProperties) && !UnixInstallHandler.shouldInstallOverExisting(launchDesc)) {
            return false;
        }
        if (bl2 || bl) {
            String[] stringArray;
            try {
                file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            if (file == null) {
                bl4 = false;
            }
            if (bl && bl4) {
                String string;
                stringArray = this.getGnomePre26DesktopPath();
                String string2 = null;
                String string3 = null;
                if (new File((String)stringArray).exists() && (string2 = this.createDesktopShortcut(launchDesc, file, "file://" + (String)stringArray)) != null) {
                    localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, string2);
                }
                if (new File(string = this.getGnome26DesktopPath()).exists() && (string3 = this.createDesktopShortcut(launchDesc, file, "file://" + string)) != null) {
                    localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_GNOME26_KEY, string3);
                }
                if (string2 == null && string3 == null) {
                    bl4 = false;
                }
            }
            if (bl2 && bl4) {
                stringArray = this.createStartMenuShortcut(launchDesc, file, bl3);
                if (stringArray[0] != null) {
                    localApplicationProperties.put(INSTALLED_GNOME_START_MENU_KEY, stringArray[0]);
                    if (stringArray[1] != null) {
                        localApplicationProperties.put(INSTALLED_DIRECTORY_KEY, stringArray[1]);
                    }
                    if (stringArray[2] != null) {
                        localApplicationProperties.put(INSTALLED_UNINSTALL_KEY, stringArray[2]);
                    }
                    if (stringArray[3] != null) {
                        localApplicationProperties.put(INSTALLED_RC_KEY, stringArray[3]);
                    }
                } else {
                    bl4 = false;
                    this.removeShortcuts(launchDesc, localApplicationProperties, bl);
                }
            }
            if (bl4) {
                localApplicationProperties.setLocallyInstalled(true);
                UnixInstallHandler.save(localApplicationProperties);
            } else {
                this.installFailed(launchDesc);
            }
        }
        return bl4;
    }

    protected void registerWithInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    public String getDefaultIconPath() {
        return Config.getJavaHome() + File.separator + "lib" + File.separator + "deploy" + File.separator + "java-icon.ico";
    }

    private String getIcon(LaunchDesc launchDesc, boolean bl) {
        String string = IcoEncoder.getIconPath(launchDesc, bl);
        if (string == null) {
            string = this.getDefaultIconPath();
        }
        return string;
    }

    private String getRCIcon(RContentDesc rContentDesc, LaunchDesc launchDesc) {
        URL uRL = rContentDesc.getIcon();
        String string = null;
        if (uRL != null) {
            string = IcoEncoder.getIconPath(uRL, null);
        }
        if (string == null) {
            string = this.getIcon(launchDesc, false);
        }
        return string;
    }

    private String[] createStartMenuShortcut(LaunchDesc launchDesc, File file, boolean bl) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String[] stringArray = new String[5];
        String string = this.nameFilter(informationDesc.getTitle());
        String string2 = this.getIcon(launchDesc, false);
        String string3 = "";
        String string4 = this.getMenuEntryDirPath(launchDesc, bl);
        if (informationDesc.supportsOfflineOperation() && shortcutDesc != null && !shortcutDesc.getOnline()) {
            string3 = "-offline";
        }
        stringArray[0] = this.createDesktopFile(launchDesc, string, string2, string4, file.getAbsolutePath(), string3);
        stringArray[1] = string4;
        if (this.addUninstallShortcut()) {
            stringArray[2] = this.createDesktopFile(launchDesc, ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (String)string), string2, string4, file.getAbsolutePath(), "-uninstall");
        }
        Trace.println((String)("directoryFileName: " + stringArray[1]), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)("desktopFileName: " + stringArray[0]), (TraceLevel)TraceLevel.BASIC);
        RContentDesc[] rContentDescArray = informationDesc.getRelatedContent();
        if (rContentDescArray != null) {
            StringBuffer stringBuffer = new StringBuffer(512 * rContentDescArray.length);
            for (int i = 0; i < rContentDescArray.length; ++i) {
                String string5;
                URL uRL = rContentDescArray[i].getHref();
                if (uRL != null && uRL.toString().endsWith(".jnlp") || (string5 = this.createRCDesktopFile(rContentDescArray[i], this.getRCIcon(rContentDescArray[i], launchDesc), string4)) == null) continue;
                stringBuffer.append(string5);
                stringBuffer.append(";");
            }
            stringArray[3] = stringBuffer.toString();
        }
        return stringArray;
    }

    private String getFolderName(LaunchDesc launchDesc) {
        String string = null;
        if (launchDesc.getInformation().getShortcut() != null) {
            string = launchDesc.getInformation().getShortcut().getSubmenu();
        }
        if (string == null) {
            string = this.nameFilter(launchDesc.getInformation().getTitle());
        }
        string = string.replace('<', '-');
        string = string.replace('>', '-');
        return string;
    }

    private String createDesktopShortcut(LaunchDesc launchDesc, File file, String string) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string2 = this.nameFilter(informationDesc.getTitle());
        String string3 = this.getIcon(launchDesc, true);
        String string4 = "";
        Trace.println((String)("iconPath: " + string3), (TraceLevel)TraceLevel.TEMP);
        if (informationDesc.supportsOfflineOperation() && shortcutDesc != null && !shortcutDesc.getOnline()) {
            string4 = "-offline";
        }
        String string5 = "-localfile " + string4;
        return this.createDesktopFile(launchDesc, string2, string3, string, file.getAbsolutePath(), string5);
    }

    private String getGnomeDesktopPath() {
        return GnomeAssociationUtil.isGnome260OrLater() ? this.getGnomePre26DesktopPath() : this.getGnome26DesktopPath();
    }

    private String getGnome26DesktopPath() {
        return System.getProperty("user.home") + File.separator + "Desktop";
    }

    private String getGnomePre26DesktopPath() {
        return System.getProperty("user.home") + File.separator + ".gnome-desktop";
    }

    private String getMenuEntryDirPath(LaunchDesc launchDesc, boolean bl) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string = null;
        if (shortcutDesc != null) {
            string = this.dirFilter(shortcutDesc.getSubmenu());
        }
        if (string == null) {
            string = this.dirFilter(informationDesc.getTitle());
        }
        if (bl) {
            if (string.startsWith("applications://")) {
                String string2 = "applications://";
                string = "applications-all-users://" + string.substring(string.indexOf(string2), string2.length());
            } else {
                string = "applications-all-users://" + File.separator + string;
            }
        } else if (!string.startsWith("applications://")) {
            string = "applications://" + File.separator + string;
        }
        return string;
    }

    private String getRCCommand(URL uRL) {
        String string;
        File file = null;
        try {
            file = DownloadEngine.getCachedFileNative((URL)uRL);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        String string2 = "";
        if (uRL.toString().endsWith(".jnlp")) {
            return Config.getJavawsCommand() + " " + uRL.toString();
        }
        if (file != null) {
            Action action;
            AssociationService associationService;
            Association association;
            string = file.getAbsolutePath();
            String string3 = string.substring(string.lastIndexOf("."), string.length());
            if (this.isAssociationSupported() && !string3.equals(".html") && (association = (associationService = new AssociationService()).getFileExtensionAssociation(string3)) != null && (action = association.getActionByVerb("open")) != null) {
                String string4 = action.getCommand();
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                string2 = string4;
            }
            if (string2 == "") {
                string2 = Config.getProperty((String)"deployment.browser.path");
            }
        } else {
            string = uRL.toString();
            string2 = Config.getProperty((String)"deployment.browser.path");
        }
        return string2 + " " + string;
    }

    private String createRCDesktopFile(RContentDesc rContentDesc, String string, String string2) {
        URL uRL = rContentDesc.getHref();
        String string3 = this.nameFilter(rContentDesc.getTitle());
        DesktopEntry desktopEntry = new DesktopEntry();
        desktopEntry.setType("Application");
        desktopEntry.setExec(this.getRCCommand(uRL));
        desktopEntry.setIcon(string);
        desktopEntry.setTerminal(false);
        desktopEntry.setName(string3);
        desktopEntry.setComment(rContentDesc.getDescription());
        desktopEntry.setCategories("Applications;" + string3);
        String string4 = string2 + File.separator + this.uniqDesktopFileName(string3);
        try {
            new DesktopEntryFile(string4).writeEntry(desktopEntry);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
        return string4;
    }

    private String createDesktopFile(LaunchDesc launchDesc, String string, String string2, String string3, String string4, String string5) {
        String string6;
        InformationDesc informationDesc = launchDesc.getInformation();
        String string7 = this.getFolderName(launchDesc);
        String string8 = informationDesc.getDescription(0);
        String string9 = informationDesc.getDescription(3);
        String string10 = string6 = string9 == null ? string8 : string9;
        if (string5 == null) {
            string5 = "";
        } else if (string5.length() > 0 && !string5.endsWith(" ")) {
            string5 = string5 + " ";
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(string3).append(File.separator).append(this.uniqDesktopFileName(string));
        Trace.println((String)("desktopFilePath: " + stringBuffer), (TraceLevel)TraceLevel.BASIC);
        DesktopEntry desktopEntry = new DesktopEntry();
        desktopEntry.setEncoding("UTF-8");
        desktopEntry.setType("Application");
        desktopEntry.setExec(Config.getJavawsCommand() + " " + string5 + string4);
        desktopEntry.setIcon(string2);
        desktopEntry.setTerminal(false);
        desktopEntry.setName(string);
        desktopEntry.setComment(string6);
        desktopEntry.setCategories("Applications;" + string7);
        try {
            Trace.println((String)("fileContents: " + desktopEntry), (TraceLevel)TraceLevel.TEMP);
            new DesktopEntryFile(stringBuffer.toString()).writeEntry(desktopEntry);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
        return stringBuffer.toString();
    }

    private String uniqDesktopFileName(String string) {
        return "jws_app_shortcut_" + System.currentTimeMillis() + ".desktop";
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                UIFactory.showErrorDialog(null, (String)ResourceManager.getString((String)"install.installFailed", (String)UnixInstallHandler.this.nameFilter(launchDesc.getInformation().getTitle())), (String)ResourceManager.getString((String)"install.installFailedTitle"));
            }
        };
        UnixInstallHandler.invokeRunnable(runnable);
    }

    public boolean removePathShortcut(String string) {
        DesktopEntryFile desktopEntryFile = new DesktopEntryFile(string);
        if (desktopEntryFile.exists()) {
            return desktopEntryFile.delete();
        }
        return false;
    }

    protected boolean removeShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        Object object;
        String string;
        boolean bl2 = false;
        if (Environment.isSystemCacheMode()) {
            bl = false;
            bl2 = true;
        }
        Trace.println((String)"uninstall called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        if (bl) {
            string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
            object = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_GNOME26_KEY);
            if (string != null) {
                new DesktopEntryFile(string).delete();
                Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
            }
            if (object != null) {
                new DesktopEntryFile((String)object).delete();
                Trace.println((String)("file removed: " + (String)object), (TraceLevel)TraceLevel.BASIC);
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_GNOME26_KEY, null);
            }
        }
        if ((string = localApplicationProperties.get(INSTALLED_GNOME_START_MENU_KEY)) != null) {
            new DesktopEntryFile(string).delete();
            Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
            localApplicationProperties.put(INSTALLED_GNOME_START_MENU_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_UNINSTALL_KEY)) != null) {
            new DesktopEntryFile(string).delete();
            Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
            localApplicationProperties.put(INSTALLED_UNINSTALL_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_RC_KEY)) != null) {
            object = new StringTokenizer(string, ";");
            while (((StringTokenizer)object).hasMoreElements()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2 == null || string2.trim().length() == 0) continue;
                new DesktopEntryFile(string2).delete();
                Trace.println((String)("file removed: " + string2), (TraceLevel)TraceLevel.BASIC);
            }
            localApplicationProperties.put(INSTALLED_RC_KEY, null);
        }
        if ((object = localApplicationProperties.get(INSTALLED_DIRECTORY_KEY)) != null) {
            new DesktopEntryFile((String)object).deleteToNonEmptyParent();
            Trace.println((String)("directory removed: " + (String)object), (TraceLevel)TraceLevel.BASIC);
            localApplicationProperties.put(INSTALLED_DIRECTORY_KEY, null);
        }
        localApplicationProperties.setLocallyInstalled(false);
        UnixInstallHandler.save(localApplicationProperties);
        return true;
    }

    public boolean isLocalInstallSupported() {
        return Config.getInstance().isLocalInstallSupported();
    }

    boolean isAssociationFileExtSupported(String string) {
        return true;
    }

    public boolean isAssociationSupported() {
        return GnomeAssociationUtil.isAssociationSupported();
    }

    private int compareVersion(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n == 0) {
            if (stringTokenizer2.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken()) - Integer.parseInt(stringTokenizer2.nextToken());
                continue;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        while (n == 0 && stringTokenizer2.hasMoreTokens()) {
            n = 0 - Integer.parseInt(stringTokenizer2.nextToken());
        }
        return n;
    }

    private String nameFilter(String string) {
        return this.Filter(string, "\"\\/|:?*<>#", '-');
    }

    private String dirFilter(String string) {
        String string2 = this.Filter(string, "\"|:?*<>#", '-');
        return this.Filter(string2, "/\\", File.separatorChar);
    }

    private String Filter(String string, String string2, char c) {
        if (string == null) {
            return null;
        }
        return this.checkTitleString(string, string2, c);
    }
}

