/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherWithWrappingSpi
extends CipherSpi {
    protected final byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.engineDoFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return byArray;
    }

    protected final Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        Key key = null;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException();
        }
        switch (n) {
            case 3: {
                key = this.constructSecretKey(byArray2, string);
                break;
            }
            case 2: {
                key = this.constructPrivateKey(byArray2, string);
                break;
            }
            case 1: {
                key = this.constructPublicKey(byArray2, string);
            }
        }
        return key;
    }

    private final PublicKey constructPublicKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, "SunJCE");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + string + "algorithm");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return publicKey;
    }

    private final PrivateKey constructPrivateKey(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, "SunJCE");
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + string + "algorithm");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return privateKey;
    }

    private final SecretKey constructSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }
}

