/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ntlm;

import java.util.Arrays;
import java.util.Locale;
import sun.security.ntlm.NTLM;
import sun.security.ntlm.NTLMException;
import sun.security.ntlm.Version;

public abstract class Server
extends NTLM {
    private final String domain;
    private final boolean allVersion;

    public Server(String string, String string2) throws NTLMException {
        super(string);
        if (string2 == null) {
            throw new NTLMException(6, "domain cannot be null");
        }
        this.allVersion = string == null;
        this.domain = string2;
        this.debug("NTLM Server: (t,version) = (%s,%s)\n", new Object[]{string2, string});
    }

    public byte[] type2(byte[] byArray, byte[] byArray2) throws NTLMException {
        if (byArray2 == null) {
            throw new NTLMException(6, "nonce cannot be null");
        }
        this.debug("NTLM Server: Type 1 received\n", new Object[0]);
        if (byArray != null) {
            this.debug(byArray);
        }
        NTLM.Writer writer = new NTLM.Writer(2, 32);
        int n = 590341;
        writer.writeSecurityBuffer(12, this.domain, true);
        writer.writeInt(20, n);
        writer.writeBytes(24, byArray2);
        this.debug("NTLM Server: Type 2 created\n", new Object[0]);
        this.debug(writer.getBytes());
        return writer.getBytes();
    }

    public String[] verify(byte[] byArray, byte[] byArray2) throws NTLMException {
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        if (byArray == null || byArray2 == null) {
            throw new NTLMException(6, "type1 or nonce cannot be null");
        }
        this.debug("NTLM Server: Type 3 received\n", new Object[0]);
        if (byArray != null) {
            this.debug(byArray);
        }
        NTLM.Reader reader = new NTLM.Reader(byArray);
        String string = reader.readSecurityBuffer(36, true);
        String string2 = reader.readSecurityBuffer(44, true);
        String string3 = reader.readSecurityBuffer(28, true);
        boolean bl = false;
        char[] cArray = this.getPassword(string3, string);
        if (cArray == null) {
            throw new NTLMException(3, "Unknown user");
        }
        byte[] byArray7 = reader.readSecurityBuffer(12);
        byte[] byArray8 = reader.readSecurityBuffer(20);
        if (!bl && (this.allVersion || this.v == Version.NTLM)) {
            if (byArray7.length > 0 && Arrays.equals(byArray6 = this.calcResponse(byArray5 = this.calcLMHash(byArray4 = Server.getP1(cArray)), byArray2), byArray7)) {
                bl = true;
            }
            if (byArray8.length > 0 && Arrays.equals(byArray6 = this.calcResponse(byArray5 = this.calcNTHash(byArray4 = Server.getP2(cArray)), byArray2), byArray8)) {
                bl = true;
            }
            this.debug("NTLM Server: verify using NTLM: " + bl + "\n", new Object[0]);
        }
        if (!bl && (this.allVersion || this.v == Version.NTLM2)) {
            byArray4 = Server.getP2(cArray);
            byArray5 = this.calcNTHash(byArray4);
            byArray3 = this.ntlm2NTLM(byArray5, byArray6 = Arrays.copyOf(byArray7, 8), byArray2);
            if (Arrays.equals(byArray8, byArray3)) {
                bl = true;
            }
            this.debug("NTLM Server: verify using NTLM2: " + bl + "\n", new Object[0]);
        }
        if (!bl && (this.allVersion || this.v == Version.NTLMv2)) {
            byArray4 = Server.getP2(cArray);
            byArray5 = this.calcNTHash(byArray4);
            if (byArray7.length > 0) {
                byArray6 = Arrays.copyOfRange(byArray7, 16, byArray7.length);
                byArray3 = this.calcV2(byArray5, string.toUpperCase(Locale.US) + string3, byArray6, byArray2);
                if (Arrays.equals(byArray3, byArray7)) {
                    bl = true;
                }
            }
            if (byArray8.length > 0) {
                byArray6 = Arrays.copyOfRange(byArray8, 16, byArray8.length);
                byArray3 = this.calcV2(byArray5, string.toUpperCase(Locale.US) + string3, byArray6, byArray2);
                if (Arrays.equals(byArray3, byArray8)) {
                    bl = true;
                }
            }
            this.debug("NTLM Server: verify using NTLMv2: " + bl + "\n", new Object[0]);
        }
        if (!bl) {
            throw new NTLMException(4, "None of LM and NTLM verified");
        }
        return new String[]{string, string2};
    }

    public abstract char[] getPassword(String var1, String var2);
}

