/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.ServiceName;
import sun.security.krb5.internal.CredentialsUtil;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;

public class Credentials {
    Ticket ticket;
    PrincipalName client;
    PrincipalName server;
    EncryptionKey key;
    TicketFlags flags;
    KerberosTime authTime;
    KerberosTime startTime;
    KerberosTime endTime;
    KerberosTime renewTill;
    HostAddresses cAddr;
    EncryptionKey serviceKey;
    private static boolean DEBUG = Krb5.DEBUG;
    private static CredentialsCache cache;
    static boolean alreadyLoaded;
    private static boolean alreadyTried;

    private static native Credentials acquireDefaultNativeCreds();

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.ticket = ticket;
        this.client = principalName;
        this.server = principalName2;
        this.key = encryptionKey;
        this.flags = ticketFlags;
        this.authTime = kerberosTime;
        this.startTime = kerberosTime2;
        this.endTime = kerberosTime3;
        this.renewTill = kerberosTime4;
        this.cAddr = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string, 1), new PrincipalName(string2), new EncryptionKey(n, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public final PrincipalName getClient() {
        return this.client;
    }

    public final PrincipalName getServer() {
        return this.server;
    }

    public final EncryptionKey getSessionKey() {
        return this.key;
    }

    public final Date getAuthTime() {
        if (this.authTime != null) {
            return this.authTime.toDate();
        }
        return null;
    }

    public final Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.renewTill != null) {
            return this.renewTill.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.flags == null) {
            return null;
        }
        return this.flags.toBooleanArray();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.cAddr == null) {
            return null;
        }
        return this.cAddr.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.ticket.asn1Encode();
            }
            catch (Asn1Exception asn1Exception) {
                if (DEBUG) {
                    System.out.println(asn1Exception);
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block4;
                System.out.println(iOException);
            }
        }
        return byArray;
    }

    public boolean isForwardable() {
        return this.flags.get(1);
    }

    public boolean isRenewable() {
        return this.flags.get(8);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public boolean checkDelegate() {
        return this.flags.get(13);
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions kDCOptions = new KDCOptions();
        kDCOptions.set(30, true);
        kDCOptions.set(8, true);
        KrbTgsReq krbTgsReq = new KrbTgsReq(kDCOptions, this, this.server, null, null, null, null, this.cAddr, null, null, null);
        String string = null;
        KrbTgsRep krbTgsRep = null;
        try {
            string = krbTgsReq.send();
            krbTgsRep = krbTgsReq.getReply();
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbTgsReq.send(this.server.getRealmString(), string, true);
                krbTgsRep = krbTgsReq.getReply();
            }
            throw krbException;
        }
        return krbTgsRep.getCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        Object object;
        if (string == null && ((String)(object = AccessController.doPrivileged(new GetPropertyAction("os.name")))).toUpperCase().startsWith("WINDOWS")) {
            Credentials credentials = Credentials.acquireDefaultCreds();
            if (credentials == null) {
                if (DEBUG) {
                    System.out.println(">>> Found no TGT's in LSA");
                }
                return null;
            }
            if (principalName != null) {
                if (credentials.getClient().equals(principalName)) {
                    if (DEBUG) {
                        System.out.println(">>> Obtained TGT from LSA: " + credentials);
                    }
                    return credentials;
                }
                if (DEBUG) {
                    System.out.println(">>> LSA contains TGT for " + credentials.getClient() + " not " + principalName);
                }
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> Obtained TGT from LSA: " + credentials);
            }
            return credentials;
        }
        object = CredentialsCache.getInstance(principalName, string);
        if (object == null) {
            return null;
        }
        sun.security.krb5.internal.ccache.Credentials credentials = ((CredentialsCache)object).getDefaultCreds();
        if (credentials == null) {
            return null;
        }
        if (EType.isSupported(credentials.getEType())) {
            return credentials.setKrbCreds();
        }
        if (DEBUG) {
            System.out.println(">>> unsupported key type found the default TGT: " + credentials.getEType());
        }
        return null;
    }

    public static Credentials acquireTGT(PrincipalName principalName, EncryptionKey[] encryptionKeyArray, char[] cArray) throws KrbException, IOException {
        if (principalName == null) {
            throw new IllegalArgumentException("Cannot have null principal to do AS-Exchange");
        }
        if (encryptionKeyArray == null) {
            throw new IllegalArgumentException("Cannot have null secretKey to do AS-Exchange");
        }
        KrbAsRep krbAsRep = null;
        try {
            krbAsRep = Credentials.sendASRequest(principalName, encryptionKeyArray, null);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 24 || krbException.returnCode() == 25) {
                KRBError kRBError;
                String string;
                if (DEBUG) {
                    System.out.println("AcquireTGT: PREAUTH FAILED/REQUIRED, re-send AS-REQ");
                }
                if ((string = (kRBError = krbException.getError()).getSalt()) != null && string.length() > 0) {
                    principalName.setSalt(string);
                }
                if (cArray != null) {
                    encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, principalName.getSalt(), true, kRBError.getEType(), kRBError.getParams());
                }
                krbAsRep = Credentials.sendASRequest(principalName, encryptionKeyArray, krbException.getError());
            }
            throw krbException;
        }
        return krbAsRep.getCreds();
    }

    private static KrbAsRep sendASRequest(PrincipalName principalName, EncryptionKey[] encryptionKeyArray, KRBError kRBError) throws KrbException, IOException {
        KrbAsReq krbAsReq = null;
        krbAsReq = kRBError == null ? new KrbAsReq(principalName, encryptionKeyArray) : new KrbAsReq(principalName, encryptionKeyArray, true, kRBError.getEType(), kRBError.getSalt(), kRBError.getParams());
        String string = null;
        KrbAsRep krbAsRep = null;
        try {
            string = krbAsReq.send();
            krbAsRep = krbAsReq.getReply(encryptionKeyArray);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbAsReq.send(principalName.getRealmString(), string, true);
                krbAsRep = krbAsReq.getReply(encryptionKeyArray);
            }
            throw krbException;
        }
        return krbAsRep;
    }

    public static synchronized Credentials acquireDefaultCreds() {
        sun.security.krb5.internal.ccache.Credentials credentials;
        Credentials credentials2 = null;
        if (cache == null) {
            cache = CredentialsCache.getInstance();
        }
        if (cache != null && (credentials = cache.getDefaultCreds()) != null) {
            if (DEBUG) {
                System.out.println(">>> KrbCreds found the default ticket granting ticket in credential cache.");
            }
            if (EType.isSupported(credentials.getEType())) {
                credentials2 = credentials.setKrbCreds();
            } else if (DEBUG) {
                System.out.println(">>> unsupported key type found the default TGT: " + credentials.getEType());
            }
        }
        if (credentials2 == null) {
            if (!alreadyTried) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("Can not load credentials cache");
                        exception.printStackTrace();
                    }
                    alreadyTried = true;
                }
            }
            if (alreadyLoaded) {
                if (DEBUG) {
                    System.out.println(">> Acquire default native Credentials");
                }
                credentials2 = Credentials.acquireDefaultNativeCreds();
            }
        }
        return credentials2;
    }

    public static Credentials getServiceCreds(String string, File file) {
        Object object;
        EncryptionKey encryptionKey = null;
        PrincipalName principalName = null;
        Credentials credentials = null;
        try {
            principalName = new PrincipalName(string);
            if (principalName.getRealm() == null) {
                object = Config.getInstance().getDefaultRealm();
                if (object == null) {
                    return null;
                }
                principalName.setRealm((String)object);
            }
        }
        catch (RealmException realmException) {
            if (DEBUG) {
                realmException.printStackTrace();
            }
            return null;
        }
        catch (KrbException krbException) {
            if (DEBUG) {
                krbException.printStackTrace();
            }
            return null;
        }
        object = file == null ? KeyTab.getInstance() : KeyTab.getInstance(file);
        if (object != null && ((KeyTab)object).findServiceEntry(principalName)) {
            encryptionKey = ((KeyTab)object).readServiceKey(principalName);
            credentials = new Credentials(null, principalName, null, null, null, null, null, null, null, null);
            credentials.serviceKey = encryptionKey;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireServiceCreds(string, credentials);
    }

    private static Credentials serviceCreds(ServiceName serviceName, Credentials credentials) throws KrbException, IOException {
        KrbTgsReq krbTgsReq = new KrbTgsReq(new KDCOptions(), credentials, serviceName, null, null, null, null, null, null, null, null);
        String string = null;
        KrbTgsRep krbTgsRep = null;
        try {
            string = krbTgsReq.send();
            krbTgsRep = krbTgsReq.getReply();
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbTgsReq.send(serviceName.getRealmString(), string, true);
                krbTgsRep = krbTgsReq.getReply();
            }
            throw krbException;
        }
        return krbTgsRep.getCreds();
    }

    public CredentialsCache getCache() {
        return cache;
    }

    public EncryptionKey getServiceKey() {
        return this.serviceKey;
    }

    public static void printDebug(Credentials credentials) {
        System.out.println(">>> DEBUG: ----Credentials----");
        System.out.println("\tclient: " + credentials.client.toString());
        System.out.println("\tserver: " + credentials.server.toString());
        System.out.println("\tticket: realm: " + credentials.ticket.realm.toString());
        System.out.println("\t        sname: " + credentials.ticket.sname.toString());
        if (credentials.startTime != null) {
            System.out.println("\tstartTime: " + credentials.startTime.getTime());
        }
        System.out.println("\tendTime: " + credentials.endTime.getTime());
        System.out.println("        ----Credentials end----");
    }

    static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("w2k_lsa_auth");
                return null;
            }
        });
        alreadyLoaded = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Credentials:");
        stringBuffer.append("\nclient=").append(this.client);
        stringBuffer.append("\nserver=").append(this.server);
        if (this.authTime != null) {
            stringBuffer.append("\nauthTime=").append(this.authTime);
        }
        if (this.startTime != null) {
            stringBuffer.append("\nstartTime=").append(this.startTime);
        }
        stringBuffer.append("\nendTime=").append(this.endTime);
        stringBuffer.append("\nrenewTill=").append(this.renewTill);
        stringBuffer.append("\nflags: ").append(this.flags);
        stringBuffer.append("\nEType (int): ").append(this.key.getEType());
        return stringBuffer.toString();
    }

    static {
        alreadyLoaded = false;
        alreadyTried = false;
    }
}

