/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Random;
import sun.misc.BASE64Decoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.B64Encoder;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.NTLMAuthenticationCallback;
import sun.security.action.GetPropertyAction;
import sun.security.ntlm.Client;
import sun.security.ntlm.NTLMException;

class NTLMAuthentication
extends AuthenticationInfo {
    static char NTLM_AUTH = (char)78;
    private static final NTLMAuthenticationCallback NTLMAuthCallback = NTLMAuthenticationCallback.getNTLMAuthenticationCallback();
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", ""));
    PasswordAuthentication pw;
    Client client;

    static boolean supportsTransparentAuth() {
        return false;
    }

    public static boolean isTrustedSite(URL uRL) {
        return NTLMAuthCallback.isTrustedSite(uRL);
    }

    private void init0() {
        this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string;
                try {
                    string = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
                return string;
            }
        });
    }

    public NTLMAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', NTLM_AUTH, uRL, "");
        this.init(passwordAuthentication);
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        String string;
        String string2;
        this.pw = passwordAuthentication;
        String string3 = passwordAuthentication.getUserName();
        int n = string3.indexOf(92);
        if (n == -1) {
            string2 = string3;
            string = defaultDomain;
        } else {
            string = string3.substring(0, n).toUpperCase();
            string2 = string3.substring(n + 1);
        }
        char[] cArray = passwordAuthentication.getPassword();
        this.init0();
        try {
            this.client = new Client(System.getProperty("ntlm.version"), this.hostname, string2, string, cArray);
        }
        catch (NTLMException nTLMException) {
            try {
                this.client = new Client(null, this.hostname, string2, string, cArray);
            }
            catch (NTLMException nTLMException2) {
                throw new AssertionError((Object)"Really?");
            }
        }
    }

    public NTLMAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', NTLM_AUTH, string, n, "");
        this.init(passwordAuthentication);
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String string) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            String string2;
            if (string.length() < 6) {
                string2 = this.buildType1Msg();
            } else {
                String string3 = string.substring(5);
                string2 = this.buildType3Msg(string3);
            }
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }

    private String buildType1Msg() {
        byte[] byArray = this.client.type1();
        String string = "NTLM " + new B64Encoder().encode(byArray);
        return string;
    }

    private String buildType3Msg(String string) throws GeneralSecurityException, IOException {
        byte[] byArray = new BASE64Decoder().decodeBuffer(string);
        byte[] byArray2 = new byte[8];
        new Random().nextBytes(byArray2);
        byte[] byArray3 = this.client.type3(byArray, byArray2);
        String string2 = "NTLM " + new B64Encoder().encode(byArray3);
        return string2;
    }
}

