/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ChoicePeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ListHelper;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.XChoicePeerListener;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XWindow;

public class XChoicePeer
extends XComponentPeer
implements ChoicePeer,
ToplevelStateListener {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XChoicePeer");
    private static final int MAX_UNFURLED_ITEMS = 10;
    public static final int TEXT_SPACE = 1;
    public static final int BORDER_WIDTH = 1;
    public static final int ITEM_MARGIN = 1;
    public static final int SCROLLBAR_WIDTH = 15;
    private static final Insets focusInsets = new Insets(0, 0, 0, 0);
    private static final Insets borderInsets = new Insets(2, 2, 2, 2);
    static final int WIDGET_OFFSET = 18;
    static final int TEXT_XPAD = 8;
    static final int TEXT_YPAD = 6;
    static final Color focusColor = Color.black;
    private boolean unfurled = false;
    private boolean dragging = false;
    private boolean mouseInSB = false;
    private boolean firstPress = false;
    private boolean wasDragged = false;
    private ListHelper helper;
    private UnfurledChoice unfurledChoice;
    private Rectangle textRect;
    private Rectangle focusRect;
    private boolean drawSelectedItem = true;
    private Component alignUnder;
    private int dragStartIdx = -1;
    private XChoicePeerListener choiceListener;

    XChoicePeer(Choice choice) {
        super(choice);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Choice choice = (Choice)this.target;
        int n = choice.getItemCount();
        this.unfurledChoice = new UnfurledChoice(choice);
        this.getToplevelXWindow().addToplevelStateListener(this);
        this.helper = new ListHelper(this.unfurledChoice, this.getGUIcolors(), n, false, true, false, choice.getFont(), 10, 1, 1, 1, 15);
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        Choice choice = (Choice)this.target;
        int n = choice.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.helper.add(choice.getItem(i));
        }
        if (!this.helper.isEmpty()) {
            this.helper.select(choice.getSelectedIndex());
            this.helper.setFocusedIndex(choice.getSelectedIndex());
        }
        this.helper.updateColors(this.getGUIcolors());
        this.updateMotifColors(this.getPeerBackground());
    }

    public boolean isFocusable() {
        return true;
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.x;
        int n7 = this.y;
        int n8 = this.width;
        int n9 = this.height;
        super.setBounds(n, n2, n3, n4, n5);
        if (this.unfurled && (n6 != this.x || n7 != this.y || n8 != this.width || n9 != this.height)) {
            this.hidePopdownMenu();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.unfurled) {
            this.hidePopdownMenu();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint();
    }

    void ungrabInputImpl() {
        if (this.unfurled) {
            this.unfurled = false;
            this.dragging = false;
            this.mouseInSB = false;
            this.unfurledChoice.setVisible(false);
        }
        super.ungrabInputImpl();
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 40: 
            case 225: {
                if (this.helper.getItemCount() <= 1) break;
                this.helper.down();
                int n = this.helper.getSelectedIndex();
                ((Choice)this.target).select(n);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n), 1));
                this.repaint();
                break;
            }
            case 38: 
            case 224: {
                if (this.helper.getItemCount() <= 1) break;
                this.helper.up();
                int n = this.helper.getSelectedIndex();
                ((Choice)this.target).select(n);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n), 1));
                this.repaint();
                break;
            }
            case 34: {
                if (!this.unfurled || this.dragging) break;
                int n = this.helper.getSelectedIndex();
                this.helper.pageDown();
                int n2 = this.helper.getSelectedIndex();
                if (n == n2) break;
                ((Choice)this.target).select(n2);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n2), 1));
                this.repaint();
                break;
            }
            case 33: {
                if (!this.unfurled || this.dragging) break;
                int n = this.helper.getSelectedIndex();
                this.helper.pageUp();
                int n3 = this.helper.getSelectedIndex();
                if (n == n3) break;
                ((Choice)this.target).select(n3);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n3), 1));
                this.repaint();
                break;
            }
            case 10: 
            case 27: {
                if (!this.unfurled) break;
                this.unfurled = false;
                this.dragging = false;
                this.wasDragged = false;
                this.mouseInSB = false;
                XChoicePeer.ungrabInput();
                this.unfurledChoice.setVisible(false);
                if (this.choiceListener == null) break;
                this.choiceListener.unfurledChoiceClosing();
                break;
            }
            default: {
                if (!this.unfurled) break;
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.unfurled && this.helper.isVSBVisible() && ListHelper.doWheelScroll(this.helper.getVSB(), null, mouseWheelEvent)) {
            this.repaint();
        }
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragStartIdx = this.helper.getSelectedIndex();
        if (mouseEvent.getButton() == 1) {
            if (this.unfurled) {
                if (!this.isMouseEventInChoice(mouseEvent) && !this.unfurledChoice.isMouseEventInside(mouseEvent)) {
                    this.hidePopdownMenu();
                }
                this.unfurledChoice.trackMouse(mouseEvent);
            } else {
                this.grabInput();
                this.unfurledChoice.toFront();
                this.firstPress = true;
                this.wasDragged = false;
                this.unfurled = true;
            }
        }
    }

    void hidePopdownMenu() {
        XChoicePeer.ungrabInput();
        this.unfurledChoice.setVisible(false);
        this.unfurled = false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.unfurled) {
            if (this.mouseInSB) {
                this.unfurledChoice.trackMouse(mouseEvent);
            } else {
                int n;
                boolean bl = this.unfurledChoice.isMouseEventInside(mouseEvent);
                boolean bl2 = this.unfurledChoice.isMouseInListArea(mouseEvent);
                if (!this.helper.isEmpty() && !bl2 && this.dragging) {
                    this.helper.select(this.dragStartIdx);
                }
                if (!this.firstPress && bl2) {
                    this.hidePopdownMenu();
                }
                if (!this.firstPress && !bl) {
                    this.hidePopdownMenu();
                }
                if (this.firstPress && this.dragging) {
                    this.hidePopdownMenu();
                }
                if (!this.firstPress && !bl2 && bl && this.dragging) {
                    this.hidePopdownMenu();
                }
                if (!this.helper.isEmpty() && this.unfurledChoice.isMouseInListArea(mouseEvent) && (n = this.helper.getSelectedIndex()) >= 0) {
                    if (n != this.dragStartIdx) {
                        ((Choice)this.target).select(n);
                    }
                    if (mouseEvent.getButton() == 1 && (!this.firstPress || this.wasDragged)) {
                        this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n), 1));
                    }
                    if (this.choiceListener != null) {
                        this.choiceListener.unfurledChoiceClosing();
                    }
                }
                this.unfurledChoice.trackMouse(mouseEvent);
            }
        }
        this.dragging = false;
        this.wasDragged = false;
        this.firstPress = false;
        this.dragStartIdx = -1;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            this.dragging = true;
            this.wasDragged = true;
            this.unfurledChoice.trackMouse(mouseEvent);
        }
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        Choice choice = (Choice)this.target;
        int n = 0;
        int n2 = choice.countItems();
        while (n2-- > 0) {
            n = Math.max(fontMetrics.stringWidth(choice.getItem(n2)), n);
        }
        return new Dimension(n + 8 + 18, fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 6);
    }

    public void layout() {
    }

    public void paint(Graphics graphics) {
        this.flush();
        Dimension dimension = this.getPeerSize();
        graphics.setColor(this.getPeerBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawMotif3DRect(graphics, 1, 1, this.width - 2, this.height - 2, false);
        this.drawMotif3DRect(graphics, this.width - 18, this.height / 2 - 3, 12, 6, false);
        if (!this.helper.isEmpty() && this.helper.getSelectedIndex() != -1) {
            graphics.setFont(this.getPeerFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.helper.getItem(this.helper.getSelectedIndex());
            if (string != null && this.drawSelectedItem) {
                graphics.setClip(1, 1, this.width - 18 - 2, this.height);
                if (this.isEnabled()) {
                    graphics.setColor(this.getPeerForeground());
                    graphics.drawString(string, 5, (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
                } else {
                    graphics.setColor(this.getPeerBackground().brighter());
                    graphics.drawString(string, 5, (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
                    graphics.setColor(this.getPeerBackground().darker());
                    graphics.drawString(string, 4, (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2 - 1);
                }
                graphics.setClip(0, 0, this.width, this.height);
            }
        }
        if (this.hasFocus()) {
            this.paintFocus(graphics, XChoicePeer.focusInsets.left, XChoicePeer.focusInsets.top, dimension.width - (XChoicePeer.focusInsets.left + XChoicePeer.focusInsets.right) - 1, dimension.height - (XChoicePeer.focusInsets.top + XChoicePeer.focusInsets.bottom) - 1);
        }
        if (this.unfurled) {
            this.unfurledChoice.repaint();
        }
        this.flush();
    }

    protected void paintFocus(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(focusColor);
        graphics.drawRect(n, n2, n3, n4);
    }

    public void select(int n) {
        this.helper.select(n);
        this.helper.setFocusedIndex(n);
        this.repaint();
    }

    public void add(String string, int n) {
        this.helper.add(string, n);
        this.repaint();
    }

    public void remove(int n) {
        boolean bl = n == this.helper.getSelectedIndex();
        boolean bl2 = n >= this.helper.firstDisplayedIndex() && n <= this.helper.lastDisplayedIndex();
        this.helper.remove(n);
        if (bl) {
            if (this.helper.isEmpty()) {
                this.helper.select(-1);
            } else {
                this.helper.select(0);
            }
        }
        if (!this.unfurled) {
            if (this.helper.isEmpty()) {
                this.repaint();
            }
            return;
        }
        if (bl2) {
            Rectangle rectangle = this.unfurledChoice.placeOnScreen();
            this.unfurledChoice.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        if (bl2 || bl) {
            this.repaint();
        }
    }

    public void removeAll() {
        this.helper.removeAll();
        this.helper.select(-1);
        Rectangle rectangle = this.unfurledChoice.placeOnScreen();
        this.unfurledChoice.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.repaint();
    }

    public void addItem(String string, int n) {
        this.add(string, n);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.helper.setFont(this.font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.helper.updateColors(this.getGUIcolors());
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unfurledChoice.setBackground(color);
        this.helper.updateColors(this.getGUIcolors());
        this.updateMotifColors(color);
    }

    public void setDrawSelectedItem(boolean bl) {
        this.drawSelectedItem = bl;
    }

    public void setAlignUnder(Component component) {
        this.alignUnder = component;
    }

    public void addXChoicePeerListener(XChoicePeerListener xChoicePeerListener) {
        this.choiceListener = xChoicePeerListener;
    }

    public void removeXChoicePeerListener() {
        this.choiceListener = null;
    }

    public boolean isUnfurled() {
        return this.unfurled;
    }

    public void stateChangedICCCM(int n, int n2) {
        if (this.unfurled && n != n2) {
            this.hidePopdownMenu();
        }
    }

    public void stateChangedJava(int n, int n2) {
        if (this.unfurled && n != n2) {
            this.hidePopdownMenu();
        }
    }

    public void dispose() {
        if (this.unfurledChoice != null) {
            this.unfurledChoice.destroy();
        }
        super.dispose();
    }

    boolean prePostEvent(final AWTEvent aWTEvent) {
        if (this.unfurled) {
            if (aWTEvent instanceof MouseWheelEvent) {
                return super.prePostEvent(aWTEvent);
            }
            if (aWTEvent instanceof KeyEvent) {
                InvocationEvent invocationEvent = new InvocationEvent((Object)this.target, new Runnable(){

                    public void run() {
                        if (XChoicePeer.this.target.isFocusable()) {
                            XChoicePeer.this.handleJavaKeyEvent((KeyEvent)aWTEvent);
                        }
                    }
                });
                this.postEvent(invocationEvent);
                return true;
            }
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                int n = aWTEvent.getID();
                if (this.unfurledChoice.isMouseEventInside(mouseEvent) || !this.firstPress && n == 506) {
                    return this.handleMouseEventByChoice(mouseEvent);
                }
                if (n == 503) {
                    return this.handleMouseEventByChoice(mouseEvent);
                }
                if (!(this.firstPress || this.isMouseEventInChoice(mouseEvent) || this.unfurledChoice.isMouseEventInside(mouseEvent) || n != 501 && n != 502 && n != 500)) {
                    return this.handleMouseEventByChoice(mouseEvent);
                }
            }
        }
        return super.prePostEvent(aWTEvent);
    }

    public boolean handleMouseEventByChoice(final MouseEvent mouseEvent) {
        InvocationEvent invocationEvent = new InvocationEvent((Object)this.target, new Runnable(){

            public void run() {
                XChoicePeer.this.handleJavaMouseEvent(mouseEvent);
            }
        });
        this.postEvent(invocationEvent);
        return true;
    }

    private boolean isMouseEventInChoice(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Rectangle rectangle = this.getBounds();
        return n >= 0 && n <= rectangle.width && n2 >= 0 && n2 <= rectangle.height;
    }

    class UnfurledChoice
    extends XWindow {
        public UnfurledChoice(Component component) {
            super(component);
        }

        public void preInit(XCreateWindowParams xCreateWindowParams) {
            xCreateWindowParams.delete("parent window");
            super.preInit(xCreateWindowParams);
            xCreateWindowParams.remove("bounds");
            xCreateWindowParams.add((Object)"overrideRedirect", Boolean.TRUE);
        }

        Rectangle placeOnScreen() {
            int n;
            if (XChoicePeer.this.helper.isEmpty()) {
                n = 1;
            } else {
                int n2 = XChoicePeer.this.helper.getItemCount();
                n = Math.min(10, n2);
            }
            Point point = XChoicePeer.this.toGlobal(0, 0);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (XChoicePeer.this.alignUnder != null) {
                Rectangle rectangle = XChoicePeer.this.getBounds();
                rectangle.setLocation(0, 0);
                rectangle = XChoicePeer.this.toGlobal(rectangle);
                Rectangle rectangle2 = new Rectangle(XChoicePeer.this.alignUnder.getLocationOnScreen(), XChoicePeer.this.alignUnder.getSize());
                Rectangle rectangle3 = rectangle.union(rectangle2);
                this.width = rectangle3.width;
                this.x = rectangle3.x;
                this.y = rectangle3.y + rectangle3.height;
                this.height = 2 + n * (XChoicePeer.this.helper.getItemHeight() + 2);
            } else {
                this.x = point.x;
                this.y = point.y + XChoicePeer.this.height;
                this.width = Math.max(XChoicePeer.this.width, XChoicePeer.this.helper.getMaxItemWidth() + 6 + (XChoicePeer.this.helper.isVSBVisible() ? 15 : 0));
                this.height = 2 + n * (XChoicePeer.this.helper.getItemHeight() + 2);
            }
            if (this.x < 0) {
                this.x = 0;
            } else if (this.x + this.width > dimension.width) {
                this.x = dimension.width - this.width;
            }
            if (this.y < 0) {
                this.y = 0;
            } else if (this.y + this.height > dimension.height) {
                this.y = dimension.height - this.height;
            }
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        public void toFront() {
            if (XChoicePeer.this.choiceListener != null) {
                XChoicePeer.this.choiceListener.unfurledChoiceOpening(XChoicePeer.this.helper);
            }
            Rectangle rectangle = this.placeOnScreen();
            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            super.toFront();
            this.setVisible(true);
        }

        public void trackMouse(MouseEvent mouseEvent) {
            Point point = this.toLocalCoords(mouseEvent);
            switch (mouseEvent.getID()) {
                case 501: {
                    if (XChoicePeer.this.helper.isInVertSB(this.getBounds(), point.x, point.y)) {
                        XChoicePeer.this.mouseInSB = true;
                        XChoicePeer.this.helper.handleVSBEvent(mouseEvent, this.getBounds(), point.x, point.y);
                        break;
                    }
                    this.trackSelection(point.x, point.y);
                    break;
                }
                case 502: {
                    if (XChoicePeer.this.mouseInSB) {
                        XChoicePeer.this.mouseInSB = false;
                        XChoicePeer.this.helper.handleVSBEvent(mouseEvent, this.getBounds(), point.x, point.y);
                        break;
                    }
                    XChoicePeer.this.helper.trackMouseReleasedScroll();
                    break;
                }
                case 506: {
                    if (XChoicePeer.this.mouseInSB) {
                        XChoicePeer.this.helper.handleVSBEvent(mouseEvent, this.getBounds(), point.x, point.y);
                        break;
                    }
                    XChoicePeer.this.helper.trackMouseDraggedScroll(point.x, point.y, this.width, this.height);
                    this.trackSelection(point.x, point.y);
                }
            }
        }

        private void trackSelection(int n, int n2) {
            if (!XChoicePeer.this.helper.isEmpty() && n > 0 && n < this.width && n2 > 0 && n2 < this.height) {
                int n3 = XChoicePeer.this.helper.y2index(n2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("transX=" + n + ", transY=" + n2 + ",width=" + this.width + ", height=" + this.height + ", newIdx=" + n3 + " on " + this.target);
                }
                if (n3 >= 0 && n3 < XChoicePeer.this.helper.getItemCount() && n3 != XChoicePeer.this.helper.getSelectedIndex()) {
                    XChoicePeer.this.helper.select(n3);
                    XChoicePeer.this.unfurledChoice.repaint();
                }
            }
        }

        public void paintBackground() {
            Graphics graphics = this.getGraphics();
            graphics.setColor(XChoicePeer.this.getPeerBackground());
            graphics.fillRect(0, 0, this.width, this.height);
        }

        public void repaint() {
            if (!this.isVisible()) {
                return;
            }
            if (XChoicePeer.this.helper.checkVsbVisibilityChangedAndReset()) {
                this.paintBackground();
            }
            super.repaint();
        }

        public void paint(Graphics graphics) {
            Choice choice = (Choice)this.target;
            Color[] colorArray = XChoicePeer.this.getGUIcolors();
            XChoicePeer.this.draw3DRect(graphics, XComponentPeer.getSystemColors(), 0, 0, this.width - 1, this.height - 1, true);
            XChoicePeer.this.draw3DRect(graphics, XComponentPeer.getSystemColors(), 1, 1, this.width - 3, this.height - 3, true);
            XChoicePeer.this.helper.paintAllItems(graphics, colorArray, this.getBounds());
        }

        public void setVisible(boolean bl) {
            this.xSetVisible(bl);
            if (!bl && XChoicePeer.this.alignUnder != null) {
                XChoicePeer.this.alignUnder.requestFocusInWindow();
            }
        }

        private Point toLocalCoords(MouseEvent mouseEvent) {
            Point point = XChoicePeer.this.toGlobal(mouseEvent.getX(), mouseEvent.getY());
            point.x -= this.x;
            point.y -= this.y;
            return point;
        }

        private boolean isMouseEventInside(MouseEvent mouseEvent) {
            Point point = this.toLocalCoords(mouseEvent);
            return point.x > 0 && point.x < this.width && point.y > 0 && point.y < this.height;
        }

        private boolean isMouseInListArea(MouseEvent mouseEvent) {
            if (this.isMouseEventInside(mouseEvent)) {
                Point point = this.toLocalCoords(mouseEvent);
                Rectangle rectangle = this.getBounds();
                if (!XChoicePeer.this.helper.isInVertSB(rectangle, point.x, point.y)) {
                    return true;
                }
            }
            return false;
        }

        public void handleConfigureNotifyEvent(XEvent xEvent) {
        }

        public void handleMapNotifyEvent(XEvent xEvent) {
        }

        public void handleUnmapNotifyEvent(XEvent xEvent) {
        }
    }
}

