/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.AppContext;
import com.sun.beans.WeakCache;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import java.util.WeakHashMap;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static WeakCache<Class<?>, Method[]> declaredMethodCache = new WeakCache();
    private static final Object BEANINFO_CACHE = new Object();
    private Class beanClass;
    private BeanInfo explicitBeanInfo;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private boolean propertyChangeSource = false;
    private static Class eventListenerType = EventListener.class;
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Map methods;
    private Map properties;
    private Map events;
    private static final String DEFAULT_INFO_PATH = "sun.beans.infos";
    private static String[] searchPath = new String[]{"sun.beans.infos"};
    private static final EventSetDescriptor[] EMPTY_EVENTSETDESCRIPTORS = new EventSetDescriptor[0];
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String BEANINFO_SUFFIX = "BeanInfo";
    private HashMap pdStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo;
        WeakHashMap weakHashMap;
        if (!ReflectUtil.isPackageAccessible(clazz)) {
            return new Introspector(clazz, null, 1).getBeanInfo();
        }
        Object object = BEANINFO_CACHE;
        synchronized (object) {
            weakHashMap = (WeakHashMap)AppContext.getAppContext().get(BEANINFO_CACHE);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap();
                AppContext.getAppContext().put(BEANINFO_CACHE, weakHashMap);
            }
            beanInfo = (BeanInfo)weakHashMap.get(clazz);
        }
        if (beanInfo == null) {
            beanInfo = new Introspector(clazz, null, 1).getBeanInfo();
            object = BEANINFO_CACHE;
            synchronized (object) {
                weakHashMap.put(clazz, beanInfo);
            }
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, int n) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null, n);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> clazz2) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, clazz2, 1);
    }

    private static BeanInfo getBeanInfo(Class clazz, Class clazz2, int n) throws IntrospectionException {
        BeanInfo beanInfo = clazz2 == null && n == 1 ? Introspector.getBeanInfo(clazz) : new Introspector(clazz, clazz2, n).getBeanInfo();
        return beanInfo;
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static synchronized String[] getBeanInfoSearchPath() {
        String[] stringArray = new String[searchPath.length];
        for (int i = 0; i < searchPath.length; ++i) {
            stringArray[i] = searchPath[i];
        }
        return stringArray;
    }

    public static synchronized void setBeanInfoSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        searchPath = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCaches() {
        Object object = BEANINFO_CACHE;
        synchronized (object) {
            Map map = (Map)AppContext.getAppContext().get(BEANINFO_CACHE);
            if (map != null) {
                map.clear();
            }
            declaredMethodCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushFromCaches(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Object object = BEANINFO_CACHE;
        synchronized (object) {
            Map map = (Map)AppContext.getAppContext().get(BEANINFO_CACHE);
            if (map != null) {
                map.put(clazz, null);
            }
            declaredMethodCache.put(clazz, null);
        }
    }

    private Introspector(Class clazz, Class clazz2, int n) throws IntrospectionException {
        Class clazz3;
        this.beanClass = clazz;
        if (clazz2 != null) {
            boolean bl = false;
            for (Class clazz4 = clazz.getSuperclass(); clazz4 != null; clazz4 = clazz4.getSuperclass()) {
                if (clazz4 != clazz2) continue;
                bl = true;
            }
            if (!bl) {
                throw new IntrospectionException(clazz2.getName() + " not superclass of " + clazz.getName());
            }
        }
        if (n == 1) {
            this.explicitBeanInfo = Introspector.findExplicitBeanInfo(clazz);
        }
        if ((clazz3 = clazz.getSuperclass()) != clazz2) {
            int n2 = n;
            if (n2 == 2) {
                n2 = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(clazz3, clazz2, n2);
        }
        if (this.explicitBeanInfo != null) {
            this.additionalBeanInfo = this.explicitBeanInfo.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private BeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor beanDescriptor = this.getTargetBeanDescriptor();
        MethodDescriptor[] methodDescriptorArray = this.getTargetMethodInfo();
        EventSetDescriptor[] eventSetDescriptorArray = this.getTargetEventInfo();
        PropertyDescriptor[] propertyDescriptorArray = this.getTargetPropertyInfo();
        int n = this.getTargetDefaultEventIndex();
        int n2 = this.getTargetDefaultPropertyIndex();
        return new GenericBeanInfo(beanDescriptor, eventSetDescriptorArray, n, propertyDescriptorArray, n2, methodDescriptorArray, this.explicitBeanInfo);
    }

    static BeanInfo findExplicitBeanInfo(Class clazz) {
        String string = clazz.getName() + BEANINFO_SUFFIX;
        try {
            return (BeanInfo)Introspector.instantiate(clazz, string);
        }
        catch (Exception exception) {
            try {
                if (Introspector.isSubclass(clazz, BeanInfo.class)) {
                    return (BeanInfo)clazz.newInstance();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            string = string.substring(string.lastIndexOf(46) + 1);
            String[] stringArray = Introspector.getBeanInfoSearchPath();
            for (int i = 0; i < stringArray.length; ++i) {
                if (DEFAULT_INFO_PATH.equals(stringArray[i]) && (!DEFAULT_INFO_PATH.equals(stringArray[i]) || !"ComponentBeanInfo".equals(string))) continue;
                try {
                    Method method;
                    int n;
                    FeatureDescriptor[] featureDescriptorArray;
                    String string2 = stringArray[i] + "." + string;
                    BeanInfo beanInfo = (BeanInfo)Introspector.instantiate(clazz, string2);
                    if (beanInfo.getBeanDescriptor() != null) {
                        if (beanInfo.getBeanDescriptor().getBeanClass() != clazz) continue;
                        return beanInfo;
                    }
                    if (beanInfo.getPropertyDescriptors() != null) {
                        featureDescriptorArray = beanInfo.getPropertyDescriptors();
                        for (n = 0; n < featureDescriptorArray.length; ++n) {
                            method = ((PropertyDescriptor)featureDescriptorArray[n]).getReadMethod();
                            if (method == null) {
                                method = ((PropertyDescriptor)featureDescriptorArray[n]).getWriteMethod();
                            }
                            if (method == null || method.getDeclaringClass() != clazz) continue;
                            return beanInfo;
                        }
                        continue;
                    }
                    if (beanInfo.getMethodDescriptors() == null) continue;
                    featureDescriptorArray = beanInfo.getMethodDescriptors();
                    for (n = 0; n < featureDescriptorArray.length; ++n) {
                        method = ((MethodDescriptor)featureDescriptorArray[n]).getMethod();
                        if (method == null || method.getDeclaringClass() != clazz) continue;
                        return beanInfo;
                    }
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private PropertyDescriptor[] getTargetPropertyInfo() {
        int n;
        int n2;
        PropertyDescriptor[] propertyDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            propertyDescriptorArray = this.explicitBeanInfo.getPropertyDescriptors();
            n2 = this.explicitBeanInfo.getDefaultPropertyIndex();
            if (n2 >= 0 && n2 < propertyDescriptorArray.length) {
                this.defaultPropertyName = propertyDescriptorArray[n2].getName();
            }
        }
        if (propertyDescriptorArray == null && this.superBeanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray2 = this.superBeanInfo.getPropertyDescriptors();
            for (n = 0; n < propertyDescriptorArray2.length; ++n) {
                this.addPropertyDescriptor(propertyDescriptorArray2[n]);
            }
            n = this.superBeanInfo.getDefaultPropertyIndex();
            if (n >= 0 && n < propertyDescriptorArray2.length) {
                this.defaultPropertyName = propertyDescriptorArray2[n].getName();
            }
        }
        for (n2 = 0; n2 < this.additionalBeanInfo.length; ++n2) {
            PropertyDescriptor[] propertyDescriptorArray3 = this.additionalBeanInfo[n2].getPropertyDescriptors();
            if (propertyDescriptorArray3 == null) continue;
            for (int i = 0; i < propertyDescriptorArray3.length; ++i) {
                this.addPropertyDescriptor(propertyDescriptorArray3[i]);
            }
        }
        if (propertyDescriptorArray != null) {
            for (n2 = 0; n2 < propertyDescriptorArray.length; ++n2) {
                this.addPropertyDescriptor(propertyDescriptorArray[n2]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n = 0; n < methodArray.length; ++n) {
                int n3;
                Method method = methodArray[n];
                if (method == null || Modifier.isStatic(n3 = method.getModifiers())) continue;
                String string = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                Class<?> clazz = method.getReturnType();
                int n4 = classArray.length;
                PropertyDescriptor propertyDescriptor = null;
                if (string.length() <= 3 && !string.startsWith(IS_PREFIX)) continue;
                try {
                    if (n4 == 0) {
                        if (string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), method, null);
                        } else if (clazz == Boolean.TYPE && string.startsWith(IS_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(2)), method, null);
                        }
                    } else if (n4 == 1) {
                        if (classArray[0] == Integer.TYPE && string.startsWith(GET_PREFIX)) {
                            propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, method, null);
                        } else if (clazz == Void.TYPE && string.startsWith(SET_PREFIX)) {
                            propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, method);
                            if (this.throwsException(method, PropertyVetoException.class)) {
                                propertyDescriptor.setConstrained(true);
                            }
                        }
                    } else if (n4 == 2 && classArray[0] == Integer.TYPE && string.startsWith(SET_PREFIX)) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, null, method);
                        if (this.throwsException(method, PropertyVetoException.class)) {
                            propertyDescriptor.setConstrained(true);
                        }
                    }
                }
                catch (IntrospectionException introspectionException) {
                    propertyDescriptor = null;
                }
                if (propertyDescriptor == null) continue;
                if (this.propertyChangeSource) {
                    propertyDescriptor.setBound(true);
                }
                this.addPropertyDescriptor(propertyDescriptor);
            }
        }
        this.processPropertyDescriptors();
        PropertyDescriptor[] propertyDescriptorArray4 = new PropertyDescriptor[this.properties.size()];
        propertyDescriptorArray4 = this.properties.values().toArray(propertyDescriptorArray4);
        if (this.defaultPropertyName != null) {
            for (n = 0; n < propertyDescriptorArray4.length; ++n) {
                if (!this.defaultPropertyName.equals(propertyDescriptorArray4[n].getName())) continue;
                this.defaultPropertyIndex = n;
            }
        }
        return propertyDescriptorArray4;
    }

    private void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getName();
        ArrayList<PropertyDescriptor> arrayList = (ArrayList<PropertyDescriptor>)this.pdStore.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<PropertyDescriptor>();
            this.pdStore.put(string, arrayList);
        }
        arrayList.add(propertyDescriptor);
    }

    private void processPropertyDescriptors() {
        if (this.properties == null) {
            this.properties = new TreeMap();
        }
        Iterator iterator = this.pdStore.values().iterator();
        while (iterator.hasNext()) {
            int n;
            PropertyDescriptor propertyDescriptor = null;
            PropertyDescriptor propertyDescriptor2 = null;
            PropertyDescriptor propertyDescriptor3 = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor2 = null;
            IndexedPropertyDescriptor indexedPropertyDescriptor3 = null;
            List list = (List)iterator.next();
            for (n = 0; n < list.size(); ++n) {
                propertyDescriptor = (PropertyDescriptor)list.get(n);
                if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                    if (indexedPropertyDescriptor.getIndexedReadMethod() == null) continue;
                    if (indexedPropertyDescriptor2 != null) {
                        indexedPropertyDescriptor2 = new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor);
                        continue;
                    }
                    indexedPropertyDescriptor2 = indexedPropertyDescriptor;
                    continue;
                }
                if (propertyDescriptor.getReadMethod() == null) continue;
                if (propertyDescriptor2 != null) {
                    Method method = propertyDescriptor2.getReadMethod();
                    if (method.getName().startsWith(IS_PREFIX)) continue;
                    propertyDescriptor2 = new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
                    continue;
                }
                propertyDescriptor2 = propertyDescriptor;
            }
            for (n = 0; n < list.size(); ++n) {
                propertyDescriptor = (PropertyDescriptor)list.get(n);
                if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                    if (indexedPropertyDescriptor.getIndexedWriteMethod() == null) continue;
                    if (indexedPropertyDescriptor2 != null) {
                        if (indexedPropertyDescriptor2.getIndexedPropertyType() != indexedPropertyDescriptor.getIndexedPropertyType()) continue;
                        if (indexedPropertyDescriptor3 != null) {
                            indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                            continue;
                        }
                        indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                        continue;
                    }
                    if (indexedPropertyDescriptor3 != null) {
                        indexedPropertyDescriptor3 = new IndexedPropertyDescriptor(indexedPropertyDescriptor3, indexedPropertyDescriptor);
                        continue;
                    }
                    indexedPropertyDescriptor3 = indexedPropertyDescriptor;
                    continue;
                }
                if (propertyDescriptor.getWriteMethod() == null) continue;
                if (propertyDescriptor2 != null) {
                    if (propertyDescriptor2.getPropertyType() != propertyDescriptor.getPropertyType()) continue;
                    if (propertyDescriptor3 != null) {
                        propertyDescriptor3 = new PropertyDescriptor(propertyDescriptor3, propertyDescriptor);
                        continue;
                    }
                    propertyDescriptor3 = propertyDescriptor;
                    continue;
                }
                propertyDescriptor3 = propertyDescriptor3 != null ? new PropertyDescriptor(propertyDescriptor3, propertyDescriptor) : propertyDescriptor;
            }
            propertyDescriptor = null;
            indexedPropertyDescriptor = null;
            if (indexedPropertyDescriptor2 != null && indexedPropertyDescriptor3 != null) {
                PropertyDescriptor propertyDescriptor4;
                PropertyDescriptor propertyDescriptor5;
                if (propertyDescriptor2 != null && (propertyDescriptor5 = this.mergePropertyDescriptor(indexedPropertyDescriptor2, propertyDescriptor2)) instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor2 = (IndexedPropertyDescriptor)propertyDescriptor5;
                }
                if (propertyDescriptor3 != null && (propertyDescriptor4 = this.mergePropertyDescriptor(indexedPropertyDescriptor3, propertyDescriptor3)) instanceof IndexedPropertyDescriptor) {
                    indexedPropertyDescriptor3 = (IndexedPropertyDescriptor)propertyDescriptor4;
                }
                propertyDescriptor = indexedPropertyDescriptor2 == indexedPropertyDescriptor3 ? indexedPropertyDescriptor2 : this.mergePropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor3);
            } else if (propertyDescriptor2 != null && propertyDescriptor3 != null) {
                propertyDescriptor = propertyDescriptor2 == propertyDescriptor3 ? propertyDescriptor2 : this.mergePropertyDescriptor(propertyDescriptor2, propertyDescriptor3);
            } else if (indexedPropertyDescriptor3 != null) {
                propertyDescriptor = indexedPropertyDescriptor3;
                if (propertyDescriptor3 != null) {
                    propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor3, propertyDescriptor3);
                }
                if (propertyDescriptor2 != null) {
                    propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor3, propertyDescriptor2);
                }
            } else if (indexedPropertyDescriptor2 != null) {
                propertyDescriptor = indexedPropertyDescriptor2;
                if (propertyDescriptor2 != null) {
                    propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor2, propertyDescriptor2);
                }
                if (propertyDescriptor3 != null) {
                    propertyDescriptor = this.mergePropertyDescriptor(indexedPropertyDescriptor2, propertyDescriptor3);
                }
            } else if (propertyDescriptor3 != null) {
                propertyDescriptor = propertyDescriptor3;
            } else if (propertyDescriptor2 != null) {
                propertyDescriptor = propertyDescriptor2;
            }
            if (propertyDescriptor instanceof IndexedPropertyDescriptor && (indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() == null && indexedPropertyDescriptor.getIndexedWriteMethod() == null) {
                propertyDescriptor = new PropertyDescriptor(indexedPropertyDescriptor);
            }
            if (propertyDescriptor == null && list.size() > 0) {
                propertyDescriptor = (PropertyDescriptor)list.get(0);
            }
            if (propertyDescriptor == null) continue;
            this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
        }
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor, PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor propertyDescriptor2 = null;
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Class<?> clazz2 = indexedPropertyDescriptor.getIndexedPropertyType();
        if (clazz.isArray() && clazz.getComponentType() == clazz2) {
            propertyDescriptor2 = propertyDescriptor.getClass0().isAssignableFrom(indexedPropertyDescriptor.getClass0()) ? new IndexedPropertyDescriptor(propertyDescriptor, indexedPropertyDescriptor) : new IndexedPropertyDescriptor(indexedPropertyDescriptor, propertyDescriptor);
        } else if (propertyDescriptor.getClass0().isAssignableFrom(indexedPropertyDescriptor.getClass0())) {
            propertyDescriptor2 = indexedPropertyDescriptor;
        } else {
            propertyDescriptor2 = propertyDescriptor;
            Method method = propertyDescriptor2.getWriteMethod();
            Method method2 = propertyDescriptor2.getReadMethod();
            if (method2 == null && method != null) {
                method2 = Introspector.findMethod(propertyDescriptor2.getClass0(), GET_PREFIX + PropertyDescriptor.capitalize(propertyDescriptor2.getName()), 0);
                if (method2 != null) {
                    try {
                        propertyDescriptor2.setReadMethod(method2);
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
            }
            if (method == null && method2 != null) {
                method = Introspector.findMethod(propertyDescriptor2.getClass0(), SET_PREFIX + PropertyDescriptor.capitalize(propertyDescriptor2.getName()), 1, new Class[]{method2.getReturnType()});
                if (method != null) {
                    try {
                        propertyDescriptor2.setWriteMethod(method);
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
            }
        }
        return propertyDescriptor2;
    }

    private PropertyDescriptor mergePropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor.getClass0().isAssignableFrom(propertyDescriptor2.getClass0())) {
            return new PropertyDescriptor(propertyDescriptor, propertyDescriptor2);
        }
        return new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor, IndexedPropertyDescriptor indexedPropertyDescriptor2) {
        if (indexedPropertyDescriptor.getClass0().isAssignableFrom(indexedPropertyDescriptor2.getClass0())) {
            return new IndexedPropertyDescriptor(indexedPropertyDescriptor, indexedPropertyDescriptor2);
        }
        return new IndexedPropertyDescriptor(indexedPropertyDescriptor2, indexedPropertyDescriptor);
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        EventSetDescriptor[] eventSetDescriptorArray;
        int n;
        if (this.events == null) {
            this.events = new HashMap();
        }
        EventSetDescriptor[] eventSetDescriptorArray2 = null;
        if (this.explicitBeanInfo != null) {
            eventSetDescriptorArray2 = this.explicitBeanInfo.getEventSetDescriptors();
            n = this.explicitBeanInfo.getDefaultEventIndex();
            if (n >= 0 && n < eventSetDescriptorArray2.length) {
                this.defaultEventName = eventSetDescriptorArray2[n].getName();
            }
        }
        if (eventSetDescriptorArray2 == null && this.superBeanInfo != null) {
            int n2;
            EventSetDescriptor[] eventSetDescriptorArray3 = this.superBeanInfo.getEventSetDescriptors();
            for (n2 = 0; n2 < eventSetDescriptorArray3.length; ++n2) {
                this.addEvent(eventSetDescriptorArray3[n2]);
            }
            n2 = this.superBeanInfo.getDefaultEventIndex();
            if (n2 >= 0 && n2 < eventSetDescriptorArray3.length) {
                this.defaultEventName = eventSetDescriptorArray3[n2].getName();
            }
        }
        for (n = 0; n < this.additionalBeanInfo.length; ++n) {
            EventSetDescriptor[] eventSetDescriptorArray4 = this.additionalBeanInfo[n].getEventSetDescriptors();
            if (eventSetDescriptorArray4 == null) continue;
            for (int i = 0; i < eventSetDescriptorArray4.length; ++i) {
                this.addEvent(eventSetDescriptorArray4[i]);
            }
        }
        if (eventSetDescriptorArray2 != null) {
            for (n = 0; n < eventSetDescriptorArray2.length; ++n) {
                this.addEvent(eventSetDescriptorArray2[n]);
            }
        } else {
            Object object;
            AnnotatedElement annotatedElement;
            Object object2;
            Object object3;
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            HashMap<Object, Object> hashMap = null;
            HashMap<Object, Object> hashMap2 = null;
            HashMap<Object, Object> hashMap3 = null;
            for (int i = 0; i < methodArray.length; ++i) {
                int n3;
                Object object4 = methodArray[i];
                if (object4 == null || Modifier.isStatic(n3 = ((Method)object4).getModifiers()) || !((String)(object3 = ((Method)object4).getName())).startsWith(ADD_PREFIX) && !((String)object3).startsWith(REMOVE_PREFIX) && !((String)object3).startsWith(GET_PREFIX)) continue;
                object2 = ((Method)object4).getParameterTypes();
                annotatedElement = ((Method)object4).getReturnType();
                if (((String)object3).startsWith(ADD_PREFIX) && ((Class<?>[])object2).length == 1 && annotatedElement == Void.TYPE && Introspector.isSubclass(object2[0], eventListenerType)) {
                    object = ((String)object3).substring(3);
                    if (((String)object).length() <= 0 || !object2[0].getName().endsWith((String)object)) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<Object, Object>();
                    }
                    hashMap.put(object, object4);
                    continue;
                }
                if (((String)object3).startsWith(REMOVE_PREFIX) && ((Class<?>[])object2).length == 1 && annotatedElement == Void.TYPE && Introspector.isSubclass(object2[0], eventListenerType)) {
                    object = ((String)object3).substring(6);
                    if (((String)object).length() <= 0 || !object2[0].getName().endsWith((String)object)) continue;
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<Object, Object>();
                    }
                    hashMap2.put(object, object4);
                    continue;
                }
                if (!((String)object3).startsWith(GET_PREFIX) || ((Class<?>[])object2).length != 0 || !((Class)annotatedElement).isArray() || !Introspector.isSubclass(((Class)annotatedElement).getComponentType(), eventListenerType) || ((String)(object = ((String)object3).substring(3, ((String)object3).length() - 1))).length() <= 0 || !((Class)annotatedElement).getComponentType().getName().endsWith((String)object)) continue;
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<Object, Object>();
                }
                hashMap3.put(object, object4);
            }
            if (hashMap != null && hashMap2 != null) {
                for (Object object4 : hashMap.keySet()) {
                    if (hashMap2.get(object4) == null || !((String)object4).endsWith("Listener")) continue;
                    String string = Introspector.decapitalize(((String)object4).substring(0, ((String)object4).length() - 8));
                    object3 = (Method)hashMap.get(object4);
                    object2 = (Method)hashMap2.get(object4);
                    annotatedElement = null;
                    if (hashMap3 != null) {
                        annotatedElement = (Method)hashMap3.get(object4);
                    }
                    object = ((Method)object3).getParameterTypes()[0];
                    Method[] methodArray2 = Introspector.getPublicDeclaredMethods((Class)object);
                    ArrayList<Method> arrayList = new ArrayList<Method>(methodArray2.length);
                    for (int i = 0; i < methodArray2.length; ++i) {
                        if (methodArray2[i] == null || !this.isEventHandler(methodArray2[i])) continue;
                        arrayList.add(methodArray2[i]);
                    }
                    Method[] methodArray3 = arrayList.toArray(new Method[arrayList.size()]);
                    EventSetDescriptor eventSetDescriptor = new EventSetDescriptor(string, (Class<?>)object, methodArray3, (Method)object3, (Method)object2, (Method)annotatedElement);
                    if (this.throwsException((Method)object3, TooManyListenersException.class)) {
                        eventSetDescriptor.setUnicast(true);
                    }
                    this.addEvent(eventSetDescriptor);
                }
            }
        }
        if (this.events.size() == 0) {
            eventSetDescriptorArray = EMPTY_EVENTSETDESCRIPTORS;
        } else {
            eventSetDescriptorArray = new EventSetDescriptor[this.events.size()];
            eventSetDescriptorArray = this.events.values().toArray(eventSetDescriptorArray);
            if (this.defaultEventName != null) {
                for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
                    if (!this.defaultEventName.equals(eventSetDescriptorArray[i].getName())) continue;
                    this.defaultEventIndex = i;
                }
            }
        }
        return eventSetDescriptorArray;
    }

    private void addEvent(EventSetDescriptor eventSetDescriptor) {
        EventSetDescriptor eventSetDescriptor2;
        String string = eventSetDescriptor.getName();
        if (eventSetDescriptor.getName().equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((eventSetDescriptor2 = (EventSetDescriptor)this.events.get(string)) == null) {
            this.events.put(string, eventSetDescriptor);
            return;
        }
        EventSetDescriptor eventSetDescriptor3 = new EventSetDescriptor(eventSetDescriptor2, eventSetDescriptor);
        this.events.put(string, eventSetDescriptor3);
    }

    private MethodDescriptor[] getTargetMethodInfo() {
        int n;
        int n2;
        if (this.methods == null) {
            this.methods = new HashMap(100);
        }
        MethodDescriptor[] methodDescriptorArray = null;
        if (this.explicitBeanInfo != null) {
            methodDescriptorArray = this.explicitBeanInfo.getMethodDescriptors();
        }
        if (methodDescriptorArray == null && this.superBeanInfo != null) {
            MethodDescriptor[] methodDescriptorArray2 = this.superBeanInfo.getMethodDescriptors();
            for (n2 = 0; n2 < methodDescriptorArray2.length; ++n2) {
                this.addMethod(methodDescriptorArray2[n2]);
            }
        }
        for (n = 0; n < this.additionalBeanInfo.length; ++n) {
            MethodDescriptor[] methodDescriptorArray3 = this.additionalBeanInfo[n].getMethodDescriptors();
            if (methodDescriptorArray3 == null) continue;
            for (int i = 0; i < methodDescriptorArray3.length; ++i) {
                this.addMethod(methodDescriptorArray3[i]);
            }
        }
        if (methodDescriptorArray != null) {
            for (n = 0; n < methodDescriptorArray.length; ++n) {
                this.addMethod(methodDescriptorArray[n]);
            }
        } else {
            Method[] methodArray = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                Method method = methodArray[n2];
                if (method == null) continue;
                MethodDescriptor methodDescriptor = new MethodDescriptor(method);
                this.addMethod(methodDescriptor);
            }
        }
        MethodDescriptor[] methodDescriptorArray4 = new MethodDescriptor[this.methods.size()];
        methodDescriptorArray4 = this.methods.values().toArray(methodDescriptorArray4);
        return methodDescriptorArray4;
    }

    private void addMethod(MethodDescriptor methodDescriptor) {
        String string = methodDescriptor.getName();
        MethodDescriptor methodDescriptor2 = (MethodDescriptor)this.methods.get(string);
        if (methodDescriptor2 == null) {
            this.methods.put(string, methodDescriptor);
            return;
        }
        String[] stringArray = methodDescriptor.getParamNames();
        String[] stringArray2 = methodDescriptor2.getParamNames();
        boolean bl = false;
        if (stringArray.length == stringArray2.length) {
            bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == stringArray2[i]) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            MethodDescriptor methodDescriptor3 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
            this.methods.put(string, methodDescriptor3);
            return;
        }
        String string2 = Introspector.makeQualifiedMethodName(string, stringArray);
        methodDescriptor2 = (MethodDescriptor)this.methods.get(string2);
        if (methodDescriptor2 == null) {
            this.methods.put(string2, methodDescriptor);
            return;
        }
        MethodDescriptor methodDescriptor4 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
        this.methods.put(string2, methodDescriptor4);
    }

    private static String makeQualifiedMethodName(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('=');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private BeanDescriptor getTargetBeanDescriptor() {
        BeanDescriptor beanDescriptor;
        if (this.explicitBeanInfo != null && (beanDescriptor = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private boolean isEventHandler(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return false;
        }
        return Introspector.isSubclass(classArray[0], EventObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method[] getPublicDeclaredMethods(Class clazz) {
        if (!ReflectUtil.isPackageAccessible(clazz)) {
            return new Method[0];
        }
        Object object = BEANINFO_CACHE;
        synchronized (object) {
            Method[] methodArray = declaredMethodCache.get(clazz);
            if (methodArray == null) {
                methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method = methodArray[i];
                    if (method.getDeclaringClass().equals(clazz)) continue;
                    methodArray[i] = null;
                }
                declaredMethodCache.put(clazz, methodArray);
            }
            return methodArray;
        }
    }

    private static Method internalFindMethod(Class classArray, String string, int n, Class[] classArray2) {
        Object object;
        Method method = null;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            Method[] methodArray = Introspector.getPublicDeclaredMethods((Class)object);
            for (int i = 0; i < methodArray.length; ++i) {
                method = methodArray[i];
                if (method == null) continue;
                Class<?>[] classArray3 = method.getParameterTypes();
                if (!method.getName().equals(string) || classArray3.length != n) continue;
                if (classArray2 != null) {
                    boolean bl = false;
                    if (n > 0) {
                        for (int j = 0; j < n; ++j) {
                            if (classArray3[j] == classArray2[j]) continue;
                            bl = true;
                        }
                        if (bl) continue;
                    }
                }
                return method;
            }
        }
        method = null;
        object = classArray.getInterfaces();
        for (int i = 0; i < ((Class<?>[])object).length && (method = Introspector.internalFindMethod(object[i], string, n, null)) == null; ++i) {
        }
        return method;
    }

    static Method findMethod(Class clazz, String string, int n) {
        return Introspector.findMethod(clazz, string, n, null);
    }

    static Method findMethod(Class clazz, String string, int n, Class[] classArray) {
        if (string == null) {
            return null;
        }
        return Introspector.internalFindMethod(clazz, string, n, classArray);
    }

    static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (!clazz2.isInterface()) continue;
            Class<?>[] classArray = clazz3.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Introspector.isSubclass(classArray[i], clazz2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != clazz) continue;
            return true;
        }
        return false;
    }

    static Object instantiate(Class clazz, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz2 = classLoader.loadClass(string);
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader != null) {
                Class<?> clazz3 = classLoader.loadClass(string);
                return clazz3.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz4 = classLoader.loadClass(string);
        return clazz4.newInstance();
    }
}

