/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.Util;
import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.model.core.Adapter;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.reflect.AdaptedAccessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.Messages;
import com.sun.xml.internal.bind.v2.runtime.reflect.Utils;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.OptimizedAccessorFactory;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Receiver;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Accessor<BeanT, ValueT>
implements Receiver {
    public final Class<ValueT> valueType;
    private static boolean accessWarned = false;
    private static final Accessor ERROR = new Accessor<Object, Object>(Object.class){

        @Override
        public Object get(Object object) {
            return null;
        }

        @Override
        public void set(Object object, Object object2) {
        }
    };
    public static final Accessor<JAXBElement, Object> JAXB_ELEMENT_VALUE = new Accessor<JAXBElement, Object>(Object.class){

        @Override
        public Object get(JAXBElement jAXBElement) {
            return jAXBElement.getValue();
        }

        @Override
        public void set(JAXBElement jAXBElement, Object object) {
            jAXBElement.setValue(object);
        }
    };
    private static final Map<Class, Object> uninitializedValues = new HashMap<Class, Object>();

    public Class<ValueT> getValueType() {
        return this.valueType;
    }

    protected Accessor(Class<ValueT> clazz) {
        this.valueType = clazz;
    }

    public Accessor<BeanT, ValueT> optimize(@Nullable JAXBContextImpl jAXBContextImpl) {
        return this;
    }

    public abstract ValueT get(BeanT var1) throws AccessorException;

    public abstract void set(BeanT var1, ValueT var2) throws AccessorException;

    public Object getUnadapted(BeanT BeanT) throws AccessorException {
        return this.get(BeanT);
    }

    public boolean isAdapted() {
        return false;
    }

    public void setUnadapted(BeanT BeanT, Object object) throws AccessorException {
        this.set(BeanT, object);
    }

    @Override
    public void receive(UnmarshallingContext.State state, Object object) throws SAXException {
        try {
            this.set(state.target, object);
        }
        catch (AccessorException accessorException) {
            Loader.handleGenericException(accessorException, true);
        }
        catch (IllegalAccessError illegalAccessError) {
            Loader.handleGenericError(illegalAccessError);
        }
    }

    public final <T> Accessor<BeanT, T> adapt(Class<T> clazz, Class<? extends XmlAdapter<T, ValueT>> clazz2) {
        return new AdaptedAccessor(clazz, this, clazz2);
    }

    public final <T> Accessor<BeanT, T> adapt(Adapter<Type, Class> adapter) {
        return new AdaptedAccessor((Class)Utils.REFLECTION_NAVIGATOR.erasure((Type)adapter.defaultType), this, (Class)adapter.adapterType);
    }

    public static <A, B> Accessor<A, B> getErrorInstance() {
        return ERROR;
    }

    static {
        uninitializedValues.put(Byte.TYPE, (byte)0);
        uninitializedValues.put(Boolean.TYPE, false);
        uninitializedValues.put(Character.TYPE, Character.valueOf('\u0000'));
        uninitializedValues.put(Float.TYPE, Float.valueOf(0.0f));
        uninitializedValues.put(Double.TYPE, 0.0);
        uninitializedValues.put(Integer.TYPE, 0);
        uninitializedValues.put(Long.TYPE, 0L);
        uninitializedValues.put(Short.TYPE, (short)0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldReflection<BeanT, ValueT>
    extends Accessor<BeanT, ValueT> {
        public final Field f;
        private static final Logger logger = Util.getClassLogger();

        public FieldReflection(Field field) {
            super(field.getType());
            this.f = field;
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || Modifier.isFinal(n) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    if (!accessWarned) {
                        logger.log(Level.WARNING, Messages.UNABLE_TO_ACCESS_NON_PUBLIC_FIELD.format(field.getDeclaringClass().getName(), field.getName()), securityException);
                    }
                    accessWarned = true;
                }
            }
        }

        @Override
        public ValueT get(BeanT BeanT) {
            try {
                return (ValueT)this.f.get(BeanT);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
        }

        @Override
        public void set(BeanT BeanT, ValueT object) {
            try {
                if (object == null) {
                    object = uninitializedValues.get(this.valueType);
                }
                this.f.set(BeanT, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
        }

        @Override
        public Accessor<BeanT, ValueT> optimize(JAXBContextImpl jAXBContextImpl) {
            if (jAXBContextImpl != null && jAXBContextImpl.fastBoot) {
                return this;
            }
            Accessor accessor = OptimizedAccessorFactory.get(this.f);
            if (accessor != null) {
                return accessor;
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetterOnlyReflection<BeanT, ValueT>
    extends GetterSetterReflection<BeanT, ValueT> {
        public GetterOnlyReflection(Method method) {
            super(method, null);
        }

        @Override
        public void set(BeanT BeanT, ValueT ValueT) throws AccessorException {
            throw new AccessorException(Messages.NO_SETTER.format(this.getter.toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetterSetterReflection<BeanT, ValueT>
    extends Accessor<BeanT, ValueT> {
        public final Method getter;
        public final Method setter;
        private static final Logger logger = Util.getClassLogger();

        public GetterSetterReflection(Method method, Method method2) {
            super(method != null ? method.getReturnType() : method2.getParameterTypes()[0]);
            this.getter = method;
            this.setter = method2;
            if (method != null) {
                this.makeAccessible(method);
            }
            if (method2 != null) {
                this.makeAccessible(method2);
            }
        }

        private void makeAccessible(Method method) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    if (!accessWarned) {
                        logger.log(Level.WARNING, Messages.UNABLE_TO_ACCESS_NON_PUBLIC_FIELD.format(method.getDeclaringClass().getName(), method.getName()), securityException);
                    }
                    accessWarned = true;
                }
            }
        }

        @Override
        public ValueT get(BeanT BeanT) throws AccessorException {
            try {
                return (ValueT)this.getter.invoke(BeanT, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.handleInvocationTargetException(invocationTargetException);
            }
        }

        @Override
        public void set(BeanT BeanT, ValueT object) throws AccessorException {
            try {
                if (object == null) {
                    object = uninitializedValues.get(this.valueType);
                }
                this.setter.invoke(BeanT, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw this.handleInvocationTargetException(invocationTargetException);
            }
        }

        private AccessorException handleInvocationTargetException(InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return new AccessorException(throwable);
        }

        @Override
        public Accessor<BeanT, ValueT> optimize(JAXBContextImpl jAXBContextImpl) {
            if (this.getter == null || this.setter == null) {
                return this;
            }
            if (jAXBContextImpl != null && jAXBContextImpl.fastBoot) {
                return this;
            }
            Accessor accessor = OptimizedAccessorFactory.get(this.getter, this.setter);
            if (accessor != null) {
                return accessor;
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ReadOnlyFieldReflection<BeanT, ValueT>
    extends FieldReflection<BeanT, ValueT> {
        public ReadOnlyFieldReflection(Field field) {
            super(field);
        }

        @Override
        public void set(BeanT BeanT, ValueT ValueT) {
        }

        @Override
        public Accessor<BeanT, ValueT> optimize(JAXBContextImpl jAXBContextImpl) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetterOnlyReflection<BeanT, ValueT>
    extends GetterSetterReflection<BeanT, ValueT> {
        public SetterOnlyReflection(Method method) {
            super(null, method);
        }

        @Override
        public ValueT get(BeanT BeanT) throws AccessorException {
            throw new AccessorException(Messages.NO_GETTER.format(this.setter.toString()));
        }
    }
}

