/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.Filter;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.UnsolicitedResponseImpl;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.sasl.LdapSasl;
import com.sun.jndi.ldap.sasl.SaslInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.ldap.Control;

public final class LdapClient
implements PooledConnection {
    private static final int debug = 0;
    static final boolean caseIgnore = true;
    private static final Hashtable defaultBinaryAttrs = new Hashtable(23, 0.75f);
    private static final String DISCONNECT_OID = "1.3.6.1.4.1.1466.20036";
    boolean isLdapv3;
    int referenceCount = 1;
    Connection conn;
    private final PoolCallback pcb;
    private final boolean pooled;
    private boolean authenticateCalled = false;
    static final int SCOPE_BASE_OBJECT = 0;
    static final int SCOPE_ONE_LEVEL = 1;
    static final int SCOPE_SUBTREE = 2;
    static final int ADD = 0;
    static final int DELETE = 1;
    static final int REPLACE = 2;
    static final int LDAP_VERSION3_VERSION2 = 32;
    static final int LDAP_VERSION2 = 2;
    static final int LDAP_VERSION3 = 3;
    static final int LDAP_VERSION = 3;
    static final int LDAP_REF_FOLLOW = 1;
    static final int LDAP_REF_THROW = 2;
    static final int LDAP_REF_IGNORE = 3;
    static final String LDAP_URL = "ldap://";
    static final String LDAPS_URL = "ldaps://";
    static final int LBER_BOOLEAN = 1;
    static final int LBER_INTEGER = 2;
    static final int LBER_BITSTRING = 3;
    static final int LBER_OCTETSTRING = 4;
    static final int LBER_NULL = 5;
    static final int LBER_ENUMERATED = 10;
    static final int LBER_SEQUENCE = 48;
    static final int LBER_SET = 49;
    static final int LDAP_SUPERIOR_DN = 128;
    static final int LDAP_REQ_BIND = 96;
    static final int LDAP_REQ_UNBIND = 66;
    static final int LDAP_REQ_SEARCH = 99;
    static final int LDAP_REQ_MODIFY = 102;
    static final int LDAP_REQ_ADD = 104;
    static final int LDAP_REQ_DELETE = 74;
    static final int LDAP_REQ_MODRDN = 108;
    static final int LDAP_REQ_COMPARE = 110;
    static final int LDAP_REQ_ABANDON = 80;
    static final int LDAP_REQ_EXTENSION = 119;
    static final int LDAP_REP_BIND = 97;
    static final int LDAP_REP_SEARCH = 100;
    static final int LDAP_REP_SEARCH_REF = 115;
    static final int LDAP_REP_RESULT = 101;
    static final int LDAP_REP_MODIFY = 103;
    static final int LDAP_REP_ADD = 105;
    static final int LDAP_REP_DELETE = 107;
    static final int LDAP_REP_MODRDN = 109;
    static final int LDAP_REP_COMPARE = 111;
    static final int LDAP_REP_EXTENSION = 120;
    static final int LDAP_REP_REFERRAL = 163;
    static final int LDAP_REP_EXT_OID = 138;
    static final int LDAP_REP_EXT_VAL = 139;
    static final int LDAP_CONTROLS = 160;
    static final String LDAP_CONTROL_MANAGE_DSA_IT = "2.16.840.1.113730.3.4.2";
    static final String LDAP_CONTROL_PREFERRED_LANG = "1.3.6.1.4.1.1466.20035";
    static final String LDAP_CONTROL_PAGED_RESULTS = "1.2.840.113556.1.4.319";
    static final String LDAP_CONTROL_SERVER_SORT_REQ = "1.2.840.113556.1.4.473";
    static final String LDAP_CONTROL_SERVER_SORT_RES = "1.2.840.113556.1.4.474";
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_OPERATIONS_ERROR = 1;
    static final int LDAP_PROTOCOL_ERROR = 2;
    static final int LDAP_TIME_LIMIT_EXCEEDED = 3;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_COMPARE_FALSE = 5;
    static final int LDAP_COMPARE_TRUE = 6;
    static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    static final int LDAP_PARTIAL_RESULTS = 9;
    static final int LDAP_REFERRAL = 10;
    static final int LDAP_ADMIN_LIMIT_EXCEEDED = 11;
    static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    static final int LDAP_UNDEFINED_ATTRIBUTE_TYPE = 17;
    static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    static final int LDAP_CONSTRAINT_VIOLATION = 19;
    static final int LDAP_ATTRIBUTE_OR_VALUE_EXISTS = 20;
    static final int LDAP_INVALID_ATTRIBUTE_SYNTAX = 21;
    static final int LDAP_NO_SUCH_OBJECT = 32;
    static final int LDAP_ALIAS_PROBLEM = 33;
    static final int LDAP_INVALID_DN_SYNTAX = 34;
    static final int LDAP_IS_LEAF = 35;
    static final int LDAP_ALIAS_DEREFERENCING_PROBLEM = 36;
    static final int LDAP_INAPPROPRIATE_AUTHENTICATION = 48;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_INSUFFICIENT_ACCESS_RIGHTS = 50;
    static final int LDAP_BUSY = 51;
    static final int LDAP_UNAVAILABLE = 52;
    static final int LDAP_UNWILLING_TO_PERFORM = 53;
    static final int LDAP_LOOP_DETECT = 54;
    static final int LDAP_NAMING_VIOLATION = 64;
    static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    static final int LDAP_NOT_ALLOWED_ON_NON_LEAF = 66;
    static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    static final int LDAP_ENTRY_ALREADY_EXISTS = 68;
    static final int LDAP_OBJECT_CLASS_MODS_PROHIBITED = 69;
    static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    static final int LDAP_OTHER = 80;
    static final String[] ldap_error_message;
    private Vector<LdapCtx> unsolicited = new Vector(3);

    LdapClient(String string, int n, String string2, int n2, int n3, OutputStream outputStream, PoolCallback poolCallback) throws NamingException {
        this.conn = new Connection(this, string, n, string2, n2, n3, outputStream);
        this.pcb = poolCallback;
        this.pooled = poolCallback != null;
    }

    synchronized boolean authenticateCalled() {
        return this.authenticateCalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized LdapResult authenticate(boolean var1_1, String var2_2, Object var3_3, int var4_4, String var5_5, Control[] var6_6, Hashtable var7_7) throws NamingException {
        var8_8 = this.conn.readTimeout;
        this.conn.readTimeout = this.conn.connectTimeout;
        var9_9 = null;
        try {
            block40: {
                this.authenticateCalled = true;
                try {
                    this.ensureOpen();
                }
                catch (IOException var10_10) {
                    var11_14 = new CommunicationException();
                    var11_14.setRootCause(var10_10);
                    throw var11_14;
                }
                switch (var4_4) {
                    case 3: 
                    case 32: {
                        this.isLdapv3 = true;
                        break;
                    }
                    case 2: {
                        this.isLdapv3 = false;
                        break;
                    }
                    default: {
                        throw new CommunicationException("Protocol version " + var4_4 + " not supported");
                    }
                }
                if (var5_5.equalsIgnoreCase("none") || var5_5.equalsIgnoreCase("anonymous")) {
                    if (!var1_1 || var4_4 == 2 || var4_4 == 32 || var6_6 != null && var6_6.length > 0) {
                        try {
                            var2_2 = null;
                            var3_3 = null;
                            var9_9 = this.ldapBind(null, null, var6_6, null, false);
                            if (var9_9.status != 0) ** GOTO lbl72
                            this.conn.setBound();
                        }
                        catch (IOException var10_11) {
                            var11_15 = new CommunicationException("anonymous bind failed: " + this.conn.host + ":" + this.conn.port);
                            var11_15.setRootCause(var10_11);
                            throw var11_15;
                        }
                    } else {
                        var9_9 = new LdapResult();
                        var9_9.status = 0;
                    }
                } else {
                    if (var5_5.equalsIgnoreCase("simple")) {
                        var10_12 = null;
                        try {
                            var10_12 = LdapClient.encodePassword(var3_3, this.isLdapv3);
                            var9_9 = this.ldapBind(var2_2, var10_12, var6_6, null, false);
                            if (var9_9.status == 0) {
                                this.conn.setBound();
                            }
                            ** if (var10_12 == var3_3 || var10_12 == null) goto lbl-1000
                        }
                        catch (IOException var11_17) {
                            try {
                                var12_20 = new CommunicationException("simple bind failed: " + this.conn.host + ":" + this.conn.port);
                                var12_20.setRootCause(var11_17);
                                throw var12_20;
                            }
                            catch (Throwable var13_22) {
                                if (var10_12 != var3_3 && var10_12 != null) {
                                    for (var14_23 = 0; var14_23 < var10_12.length; ++var14_23) {
                                        var10_12[var14_23] = 0;
                                    }
                                }
                                throw var13_22;
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            for (var11_16 = 0; var11_16 < var10_12.length; ++var11_16) {
                                var10_12[var11_16] = 0;
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block40;
                        }
                    }
                    if (this.isLdapv3) {
                        try {
                            var9_9 = LdapSasl.saslBind(this, this.conn, this.conn.host, var2_2, var3_3, var5_5, var7_7, var6_6);
                            if (var9_9.status != 0) ** GOTO lbl72
                            this.conn.setBound();
                        }
                        catch (IOException var10_13) {
                            var11_18 = new CommunicationException("SASL bind failed: " + this.conn.host + ":" + this.conn.port);
                            var11_18.setRootCause(var10_13);
                            throw var11_18;
                        }
                    } else {
                        throw new AuthenticationNotSupportedException(var5_5);
                    }
                }
            }
            if (var1_1 && var9_9.status == 2 && var4_4 == 32 && (var5_5.equalsIgnoreCase("none") || var5_5.equalsIgnoreCase("anonymous") || var5_5.equalsIgnoreCase("simple"))) {
                var10_12 = null;
                try {
                    this.isLdapv3 = false;
                    var10_12 = LdapClient.encodePassword(var3_3, false);
                    var9_9 = this.ldapBind(var2_2, var10_12, var6_6, null, false);
                    if (var9_9.status == 0) {
                        this.conn.setBound();
                    }
                    ** if (var10_12 == var3_3 || var10_12 == null) goto lbl-1000
                }
                catch (IOException var11_19) {
                    try {
                        var12_21 = new CommunicationException(var5_5 + ":" + this.conn.host + ":" + this.conn.port);
                        var12_21.setRootCause(var11_19);
                        throw var12_21;
                    }
                    catch (Throwable var15_24) {
                        if (var10_12 != var3_3 && var10_12 != null) {
                            for (var16_25 = 0; var16_25 < var10_12.length; ++var16_25) {
                                var10_12[var16_25] = 0;
                            }
                        }
                        throw var15_24;
                    }
                }
lbl-1000:
                // 2 sources

                {
                    for (var11_16 = 0; var11_16 < var10_12.length; ++var11_16) {
                        var10_12[var11_16] = 0;
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            if (var9_9.status == 32) {
                throw new AuthenticationException(LdapClient.getErrorMessage(var9_9.status, var9_9.errorMessage));
            }
            this.conn.setV3(this.isLdapv3);
        }
        finally {
            this.conn.readTimeout = var8_8;
        }
        return var9_9;
    }

    public synchronized LdapResult ldapBind(String string, byte[] byArray, Control[] controlArray, String string2, boolean bl) throws IOException, NamingException {
        this.ensureOpen();
        this.conn.abandonOutstandingReqs(null);
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(96);
        berEncoder.encodeInt(this.isLdapv3 ? 3 : 2);
        berEncoder.encodeString(string, this.isLdapv3);
        if (string2 != null) {
            berEncoder.beginSeq(163);
            berEncoder.encodeString(string2, this.isLdapv3);
            if (byArray != null) {
                berEncoder.encodeOctetString(byArray, 4);
            }
            berEncoder.endSeq();
        } else if (byArray != null) {
            berEncoder.encodeOctetString(byArray, 128);
        } else {
            berEncoder.encodeOctetString(null, 128, 0, 0);
        }
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n, bl);
        if (byArray != null) {
            berEncoder.reset();
        }
        BerDecoder berDecoder = this.conn.readReply(ldapRequest);
        berDecoder.parseSeq(null);
        berDecoder.parseInt();
        if (berDecoder.parseByte() != 97) {
            return ldapResult;
        }
        berDecoder.parseLength();
        LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
        if (this.isLdapv3 && berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 135) {
            ldapResult.serverCreds = berDecoder.parseOctetString(135, null);
        }
        ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
        this.conn.removeRequest(ldapRequest);
        return ldapResult;
    }

    boolean usingSaslStreams() {
        return this.conn.inStream instanceof SaslInputStream;
    }

    synchronized void incRefCount() {
        ++this.referenceCount;
    }

    private static byte[] encodePassword(Object object, boolean bl) throws IOException {
        if (object instanceof char[]) {
            object = new String((char[])object);
        }
        if (object instanceof String) {
            if (bl) {
                return ((String)object).getBytes("UTF8");
            }
            return ((String)object).getBytes("8859_1");
        }
        return (byte[])object;
    }

    synchronized void close(Control[] controlArray, boolean bl) {
        --this.referenceCount;
        if (this.referenceCount <= 0 && this.conn != null) {
            if (!this.pooled) {
                this.conn.cleanup(controlArray, false);
                this.conn = null;
            } else if (bl) {
                this.conn.cleanup(controlArray, false);
                this.conn = null;
                this.pcb.removePooledConnection(this);
            } else {
                this.pcb.releasePooledConnection(this);
            }
        }
    }

    private void forceClose(boolean bl) {
        this.referenceCount = 0;
        if (this.conn != null) {
            this.conn.cleanup(null, false);
            this.conn = null;
            if (bl) {
                this.pcb.removePooledConnection(this);
            }
        }
    }

    protected void finalize() {
        this.forceClose(this.pooled);
    }

    public synchronized void closeConnection() {
        this.forceClose(false);
    }

    void processConnectionClosure() {
        if (this.unsolicited.size() > 0) {
            String string = this.conn != null ? this.conn.host + ":" + this.conn.port + " connection closed" : "Connection closed";
            this.notifyUnsolicited(new CommunicationException(string));
        }
        if (this.pooled) {
            this.pcb.removePooledConnection(this);
        }
    }

    LdapResult search(String string, int n, int n2, int n3, int n4, boolean bl, String[] stringArray, String string2, int n5, Control[] controlArray, Hashtable hashtable, boolean bl2, int n6) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        BerEncoder berEncoder = new BerEncoder();
        int n7 = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n7);
        berEncoder.beginSeq(99);
        berEncoder.encodeString(string == null ? "" : string, this.isLdapv3);
        berEncoder.encodeInt(n, 10);
        berEncoder.encodeInt(n2, 10);
        berEncoder.encodeInt(n3);
        berEncoder.encodeInt(n4);
        berEncoder.encodeBoolean(bl);
        Filter.encodeFilterString(berEncoder, string2, this.isLdapv3);
        berEncoder.beginSeq(48);
        berEncoder.encodeStringArray(stringArray, this.isLdapv3);
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n7, false, n6);
        ldapResult.msgId = n7;
        ldapResult.status = 0;
        if (bl2) {
            ldapResult = this.getSearchReply(ldapRequest, n5, ldapResult, hashtable);
        }
        return ldapResult;
    }

    void clearSearchReply(LdapResult ldapResult, Control[] controlArray) {
        if (ldapResult != null && this.conn != null) {
            LdapRequest ldapRequest = this.conn.findRequest(ldapResult.msgId);
            if (ldapRequest == null) {
                return;
            }
            if (ldapRequest.hasSearchCompleted()) {
                this.conn.removeRequest(ldapRequest);
            } else {
                this.conn.abandonRequest(ldapRequest, controlArray);
            }
        }
    }

    LdapResult getSearchReply(int n, LdapResult ldapResult, Hashtable hashtable) throws IOException, NamingException {
        this.ensureOpen();
        LdapRequest ldapRequest = this.conn.findRequest(ldapResult.msgId);
        if (ldapRequest == null) {
            return null;
        }
        return this.getSearchReply(ldapRequest, n, ldapResult, hashtable);
    }

    private LdapResult getSearchReply(LdapRequest ldapRequest, int n, LdapResult ldapResult, Hashtable hashtable) throws IOException, NamingException {
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        if (ldapResult.entries != null) {
            ldapResult.entries.setSize(0);
        } else {
            ldapResult.entries = new Vector(n == Integer.MAX_VALUE ? 32 : n);
        }
        if (ldapResult.referrals != null) {
            ldapResult.referrals.setSize(0);
        }
        int n2 = 0;
        while (n2 < n) {
            BerDecoder berDecoder = this.conn.readReply(ldapRequest);
            berDecoder.parseSeq(null);
            berDecoder.parseInt();
            int n3 = berDecoder.parseSeq(null);
            if (n3 == 100) {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                String string = berDecoder.parseString(this.isLdapv3);
                LdapEntry ldapEntry = new LdapEntry(string, basicAttributes);
                int[] nArray = new int[1];
                berDecoder.parseSeq(nArray);
                int n4 = berDecoder.getParsePosition() + nArray[0];
                while (berDecoder.getParsePosition() < n4 && berDecoder.bytesLeft() > 0) {
                    Attribute attribute = this.parseAttribute(berDecoder, hashtable);
                    basicAttributes.put(attribute);
                }
                ldapEntry.respCtls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
                ldapResult.entries.addElement(ldapEntry);
                ++n2;
                continue;
            }
            if (n3 == 115 && this.isLdapv3) {
                Vector<String> vector = new Vector<String>(4);
                if (berDecoder.peekByte() == 48) {
                    berDecoder.parseSeq(null);
                }
                while (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 4) {
                    vector.addElement(berDecoder.parseString(this.isLdapv3));
                }
                if (ldapResult.referrals == null) {
                    ldapResult.referrals = new Vector(4);
                }
                ldapResult.referrals.addElement(vector);
                ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
                continue;
            }
            if (n3 == 120) {
                this.parseExtResponse(berDecoder, ldapResult);
                continue;
            }
            if (n3 != 101) continue;
            LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
            ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
            this.conn.removeRequest(ldapRequest);
            return ldapResult;
        }
        return ldapResult;
    }

    private Attribute parseAttribute(BerDecoder berDecoder, Hashtable hashtable) throws IOException {
        int[] nArray = new int[1];
        int n = berDecoder.parseSeq(null);
        String string = berDecoder.parseString(this.isLdapv3);
        boolean bl = this.isBinaryValued(string, hashtable);
        LdapAttribute ldapAttribute = new LdapAttribute(string);
        n = berDecoder.parseSeq(nArray);
        if (n == 49) {
            for (int i = nArray[0]; berDecoder.bytesLeft() > 0 && i > 0; i -= this.parseAttributeValue(berDecoder, ldapAttribute, bl)) {
                try {
                    continue;
                }
                catch (IOException iOException) {
                    berDecoder.seek(i);
                    break;
                }
            }
        } else {
            berDecoder.seek(nArray[0]);
        }
        return ldapAttribute;
    }

    private int parseAttributeValue(BerDecoder berDecoder, Attribute attribute, boolean bl) throws IOException {
        int[] nArray = new int[1];
        if (bl) {
            attribute.add(berDecoder.parseOctetString(berDecoder.peekByte(), nArray));
        } else {
            attribute.add(berDecoder.parseStringWithTag(4, this.isLdapv3, nArray));
        }
        return nArray[0];
    }

    private boolean isBinaryValued(String string, Hashtable hashtable) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return string2.indexOf(";binary") != -1 || defaultBinaryAttrs.containsKey(string2) || hashtable != null && hashtable.containsKey(string2);
    }

    static void parseResult(BerDecoder berDecoder, LdapResult ldapResult, boolean bl) throws IOException {
        ldapResult.status = berDecoder.parseEnumeration();
        ldapResult.matchedDN = berDecoder.parseString(bl);
        ldapResult.errorMessage = berDecoder.parseString(bl);
        if (bl && berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 163) {
            Vector<String> vector = new Vector<String>(4);
            int[] nArray = new int[1];
            berDecoder.parseSeq(nArray);
            int n = berDecoder.getParsePosition() + nArray[0];
            while (berDecoder.getParsePosition() < n && berDecoder.bytesLeft() > 0) {
                vector.addElement(berDecoder.parseString(bl));
            }
            if (ldapResult.referrals == null) {
                ldapResult.referrals = new Vector(4);
            }
            ldapResult.referrals.addElement(vector);
        }
    }

    static Vector parseControls(BerDecoder berDecoder) throws IOException {
        if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 160) {
            Vector<BasicControl> vector = new Vector<BasicControl>(4);
            boolean bl = false;
            byte[] byArray = null;
            int[] nArray = new int[1];
            berDecoder.parseSeq(nArray);
            int n = berDecoder.getParsePosition() + nArray[0];
            while (berDecoder.getParsePosition() < n && berDecoder.bytesLeft() > 0) {
                berDecoder.parseSeq(null);
                String string = berDecoder.parseString(true);
                if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 1) {
                    bl = berDecoder.parseBoolean();
                }
                if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 4) {
                    byArray = berDecoder.parseOctetString(4, null);
                }
                if (string == null) continue;
                vector.addElement(new BasicControl(string, bl, byArray));
            }
            return vector;
        }
        return null;
    }

    private void parseExtResponse(BerDecoder berDecoder, LdapResult ldapResult) throws IOException {
        LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
        if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 138) {
            ldapResult.extensionId = berDecoder.parseStringWithTag(138, this.isLdapv3, null);
        }
        if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 139) {
            ldapResult.extensionValue = berDecoder.parseOctetString(139, null);
        }
        ldapResult.resControls = LdapClient.parseControls(berDecoder);
    }

    static void encodeControls(BerEncoder berEncoder, Control[] controlArray) throws IOException {
        if (controlArray == null || controlArray.length == 0) {
            return;
        }
        berEncoder.beginSeq(160);
        for (int i = 0; i < controlArray.length; ++i) {
            byte[] byArray;
            berEncoder.beginSeq(48);
            berEncoder.encodeString(controlArray[i].getID(), true);
            if (controlArray[i].isCritical()) {
                berEncoder.encodeBoolean(true);
            }
            if ((byArray = controlArray[i].getEncodedValue()) != null) {
                berEncoder.encodeOctetString(byArray, 4);
            }
            berEncoder.endSeq();
        }
        berEncoder.endSeq();
    }

    private LdapResult processReply(LdapRequest ldapRequest, LdapResult ldapResult, int n) throws IOException, NamingException {
        BerDecoder berDecoder = this.conn.readReply(ldapRequest);
        berDecoder.parseSeq(null);
        berDecoder.parseInt();
        if (berDecoder.parseByte() != n) {
            return ldapResult;
        }
        berDecoder.parseLength();
        LdapClient.parseResult(berDecoder, ldapResult, this.isLdapv3);
        ldapResult.resControls = this.isLdapv3 ? LdapClient.parseControls(berDecoder) : null;
        this.conn.removeRequest(ldapRequest);
        return ldapResult;
    }

    LdapResult modify(String string, int[] nArray, Attribute[] attributeArray, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || nArray.length != attributeArray.length) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(102);
        berEncoder.encodeString(string, this.isLdapv3);
        berEncoder.beginSeq(48);
        for (int i = 0; i < nArray.length; ++i) {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(nArray[i], 10);
            if (nArray[i] == 0 && LdapClient.hasNoValue(attributeArray[i])) {
                throw new InvalidAttributeValueException("'" + attributeArray[i].getID() + "' has no values.");
            }
            this.encodeAttribute(berEncoder, attributeArray[i]);
            berEncoder.endSeq();
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 103);
    }

    private void encodeAttribute(BerEncoder berEncoder, Attribute attribute) throws IOException, NamingException {
        berEncoder.beginSeq(48);
        berEncoder.encodeString(attribute.getID(), this.isLdapv3);
        berEncoder.beginSeq(49);
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            Object obj = namingEnumeration.next();
            if (obj instanceof String) {
                berEncoder.encodeString((String)obj, this.isLdapv3);
                continue;
            }
            if (obj instanceof byte[]) {
                berEncoder.encodeOctetString((byte[])obj, 4);
                continue;
            }
            if (obj == null) continue;
            throw new InvalidAttributeValueException("Malformed '" + attribute.getID() + "' attribute value");
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
    }

    private static boolean hasNoValue(Attribute attribute) throws NamingException {
        return attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null;
    }

    LdapResult add(LdapEntry ldapEntry, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (ldapEntry == null || ldapEntry.DN == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(104);
        berEncoder.encodeString(ldapEntry.DN, this.isLdapv3);
        berEncoder.beginSeq(48);
        NamingEnumeration<? extends Attribute> namingEnumeration = ldapEntry.attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            if (LdapClient.hasNoValue(attribute)) {
                throw new InvalidAttributeValueException("'" + attribute.getID() + "' has no values.");
            }
            this.encodeAttribute(berEncoder, attribute);
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 105);
    }

    LdapResult delete(String string, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.encodeString(string, 74, this.isLdapv3);
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 107);
    }

    LdapResult moddn(String string, String string2, boolean bl, String string3, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        boolean bl2 = string3 != null && string3.length() > 0;
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string2 == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(108);
        berEncoder.encodeString(string, this.isLdapv3);
        berEncoder.encodeString(string2, this.isLdapv3);
        berEncoder.encodeBoolean(bl);
        if (this.isLdapv3 && bl2) {
            berEncoder.encodeString(string3, 128, this.isLdapv3);
        }
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 109);
    }

    LdapResult compare(String string, String string2, String string3, Control[] controlArray) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string2 == null || string3 == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(110);
        berEncoder.encodeString(string, this.isLdapv3);
        berEncoder.beginSeq(48);
        berEncoder.encodeString(string2, this.isLdapv3);
        byte[] byArray = this.isLdapv3 ? string3.getBytes("UTF8") : string3.getBytes("8859_1");
        berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, 0, byArray.length), 4);
        berEncoder.endSeq();
        berEncoder.endSeq();
        if (this.isLdapv3) {
            LdapClient.encodeControls(berEncoder, controlArray);
        }
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n);
        return this.processReply(ldapRequest, ldapResult, 111);
    }

    LdapResult extendedOp(String string, byte[] byArray, Control[] controlArray, boolean bl) throws IOException, NamingException {
        this.ensureOpen();
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null) {
            return ldapResult;
        }
        BerEncoder berEncoder = new BerEncoder();
        int n = this.conn.getMsgId();
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(n);
        berEncoder.beginSeq(119);
        berEncoder.encodeString(string, 128, this.isLdapv3);
        if (byArray != null) {
            berEncoder.encodeOctetString(byArray, 129);
        }
        berEncoder.endSeq();
        LdapClient.encodeControls(berEncoder, controlArray);
        berEncoder.endSeq();
        LdapRequest ldapRequest = this.conn.writeRequest(berEncoder, n, bl);
        BerDecoder berDecoder = this.conn.readReply(ldapRequest);
        berDecoder.parseSeq(null);
        berDecoder.parseInt();
        if (berDecoder.parseByte() != 120) {
            return ldapResult;
        }
        berDecoder.parseLength();
        this.parseExtResponse(berDecoder, ldapResult);
        this.conn.removeRequest(ldapRequest);
        return ldapResult;
    }

    static String getErrorMessage(int n, String string) {
        String string2 = "[LDAP: error code " + n;
        if (string != null && string.length() != 0) {
            string2 = string2 + " - " + string + "]";
        } else {
            try {
                if (ldap_error_message[n] != null) {
                    string2 = string2 + " - " + ldap_error_message[n] + "]";
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = string2 + "]";
            }
        }
        return string2;
    }

    void addUnsolicited(LdapCtx ldapCtx) {
        this.unsolicited.addElement(ldapCtx);
    }

    void removeUnsolicited(LdapCtx ldapCtx) {
        this.unsolicited.removeElement(ldapCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processUnsolicited(BerDecoder berDecoder) {
        try {
            LdapResult ldapResult = new LdapResult();
            berDecoder.parseSeq(null);
            berDecoder.parseInt();
            if (berDecoder.parseByte() != 120) {
                throw new IOException("Unsolicited Notification must be an Extended Response");
            }
            berDecoder.parseLength();
            this.parseExtResponse(berDecoder, ldapResult);
            if (DISCONNECT_OID.equals(ldapResult.extensionId)) {
                this.forceClose(this.pooled);
            }
            LdapCtx ldapCtx = null;
            UnsolicitedResponseImpl unsolicitedResponseImpl = null;
            Vector<LdapCtx> vector = this.unsolicited;
            synchronized (vector) {
                if (this.unsolicited.size() > 0) {
                    ldapCtx = this.unsolicited.elementAt(0);
                    unsolicitedResponseImpl = new UnsolicitedResponseImpl(ldapResult.extensionId, ldapResult.extensionValue, ldapResult.referrals, ldapResult.status, ldapResult.errorMessage, ldapResult.matchedDN, ldapResult.resControls != null ? ldapCtx.convertControls(ldapResult.resControls) : null);
                }
            }
            if (unsolicitedResponseImpl != null) {
                this.notifyUnsolicited(unsolicitedResponseImpl);
                if (DISCONNECT_OID.equals(ldapResult.extensionId)) {
                    this.notifyUnsolicited(new CommunicationException("Connection closed"));
                }
            }
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException("Problem parsing unsolicited notification");
            communicationException.setRootCause(iOException);
            this.notifyUnsolicited(communicationException);
        }
        catch (NamingException namingException) {
            this.notifyUnsolicited(namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUnsolicited(Object object) {
        Vector<LdapCtx> vector;
        Vector<LdapCtx> vector2 = this.unsolicited;
        synchronized (vector2) {
            vector = new Vector<LdapCtx>(this.unsolicited);
            if (object instanceof NamingException) {
                this.unsolicited.setSize(0);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            vector.elementAt(i).fireUnsolicited(object);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.conn == null || !this.conn.useable) {
            if (this.conn != null && this.conn.closureReason != null) {
                throw this.conn.closureReason;
            }
            throw new IOException("connection closed");
        }
    }

    static LdapClient getInstance(boolean bl, String string, int n, String string2, int n2, int n3, OutputStream outputStream, int n4, String string3, Control[] controlArray, String string4, String string5, Object object, Hashtable hashtable) throws NamingException {
        if (bl && LdapPoolManager.isPoolingAllowed(string2, outputStream, string3, string4, hashtable)) {
            LdapClient ldapClient = LdapPoolManager.getLdapClient(string, n, string2, n2, n3, outputStream, n4, string3, controlArray, string4, string5, object, hashtable);
            ldapClient.referenceCount = 1;
            return ldapClient;
        }
        return new LdapClient(string, n, string2, n2, n3, outputStream, null);
    }

    static {
        defaultBinaryAttrs.put("userpassword", Boolean.TRUE);
        defaultBinaryAttrs.put("javaserializeddata", Boolean.TRUE);
        defaultBinaryAttrs.put("javaserializedobject", Boolean.TRUE);
        defaultBinaryAttrs.put("jpegphoto", Boolean.TRUE);
        defaultBinaryAttrs.put("audio", Boolean.TRUE);
        defaultBinaryAttrs.put("thumbnailphoto", Boolean.TRUE);
        defaultBinaryAttrs.put("thumbnaillogo", Boolean.TRUE);
        defaultBinaryAttrs.put("usercertificate", Boolean.TRUE);
        defaultBinaryAttrs.put("cacertificate", Boolean.TRUE);
        defaultBinaryAttrs.put("certificaterevocationlist", Boolean.TRUE);
        defaultBinaryAttrs.put("authorityrevocationlist", Boolean.TRUE);
        defaultBinaryAttrs.put("crosscertificatepair", Boolean.TRUE);
        defaultBinaryAttrs.put("photo", Boolean.TRUE);
        defaultBinaryAttrs.put("personalsignature", Boolean.TRUE);
        defaultBinaryAttrs.put("x500uniqueidentifier", Boolean.TRUE);
        ldap_error_message = new String[]{"Success", "Operations Error", "Protocol Error", "Timelimit Exceeded", "Sizelimit Exceeded", "Compare False", "Compare True", "Authentication Method Not Supported", "Strong Authentication Required", null, "Referral", "Administrative Limit Exceeded", "Unavailable Critical Extension", "Confidentiality Required", "SASL Bind In Progress", null, "No Such Attribute", "Undefined Attribute Type", "Inappropriate Matching", "Constraint Violation", "Attribute Or Value Exists", "Invalid Attribute Syntax", null, null, null, null, null, null, null, null, null, null, "No Such Object", "Alias Problem", "Invalid DN Syntax", null, "Alias Dereferencing Problem", null, null, null, null, null, null, null, null, null, null, null, "Inappropriate Authentication", "Invalid Credentials", "Insufficient Access Rights", "Busy", "Unavailable", "Unwilling To Perform", "Loop Detect", null, null, null, null, null, null, null, null, null, "Naming Violation", "Object Class Violation", "Not Allowed On Non-leaf", "Not Allowed On RDN", "Entry Already Exists", "Object Class Modifications Prohibited", null, "Affects Multiple DSAs", null, null, null, null, null, null, null, null, "Other", null, null, null, null, null, null, null, null, null, null};
    }
}

