/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.ArrayQueue;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBufferFilter;
import com.sun.jmx.remote.internal.ServerNotifForwarder;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayNotificationBuffer
implements NotificationBuffer {
    private boolean disposed = false;
    private static final Object globalLock = new Object();
    private static final HashMap<MBeanServer, ArrayNotificationBuffer> mbsToBuffer = new HashMap(1);
    private final Collection<ShareBuffer> sharers = new HashSet<ShareBuffer>(1);
    private final NotificationListener bufferListener = new BufferListener();
    private static final QueryExp broadcasterQuery = new BroadcasterQuery();
    private static final NotificationFilter creationFilter;
    private final NotificationListener creationListener = new NotificationListener(){

        public void handleNotification(Notification notification, Object object) {
            logger.debug("creationListener", "handleNotification called");
            ArrayNotificationBuffer.this.createdNotification((MBeanServerNotification)notification);
        }
    };
    private static final ClassLogger logger;
    private final MBeanServer mBeanServer;
    private final ArrayQueue<NamedNotification> queue;
    private int queueSize;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private Set<ObjectName> createdDuringQuery;
    static final String broadcasterClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationBuffer getNotificationBuffer(MBeanServer mBeanServer, Map map) {
        ShareBuffer shareBuffer;
        boolean bl;
        ArrayNotificationBuffer arrayNotificationBuffer;
        if (map == null) {
            map = Collections.emptyMap();
        }
        int n = EnvHelp.getNotifBufferSize(map);
        Object object = globalLock;
        synchronized (object) {
            arrayNotificationBuffer = mbsToBuffer.get(mBeanServer);
            boolean bl2 = bl = arrayNotificationBuffer == null;
            if (bl) {
                arrayNotificationBuffer = new ArrayNotificationBuffer(mBeanServer, n);
                mbsToBuffer.put(mBeanServer, arrayNotificationBuffer);
            }
            ArrayNotificationBuffer arrayNotificationBuffer2 = arrayNotificationBuffer;
            arrayNotificationBuffer2.getClass();
            shareBuffer = arrayNotificationBuffer2.new ShareBuffer(n);
        }
        if (bl) {
            arrayNotificationBuffer.createListeners();
        }
        return shareBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNotificationBuffer(MBeanServer mBeanServer) {
        Object object = globalLock;
        synchronized (object) {
            mbsToBuffer.remove(mBeanServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSharer(ShareBuffer shareBuffer) {
        Object object = globalLock;
        synchronized (object) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                if (shareBuffer.getSize() > this.queueSize) {
                    this.resize(shareBuffer.getSize());
                }
            }
            this.sharers.add(shareBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSharer(ShareBuffer shareBuffer) {
        boolean bl;
        Object object = globalLock;
        synchronized (object) {
            this.sharers.remove(shareBuffer);
            bl = this.sharers.isEmpty();
            if (bl) {
                ArrayNotificationBuffer.removeNotificationBuffer(this.mBeanServer);
            } else {
                int n = 0;
                for (ShareBuffer shareBuffer2 : this.sharers) {
                    int n2 = shareBuffer2.getSize();
                    if (n2 <= n) continue;
                    n = n2;
                }
                if (n < this.queueSize) {
                    this.resize(n);
                }
            }
        }
        if (bl) {
            object = this;
            synchronized (object) {
                this.disposed = true;
                this.notifyAll();
            }
            this.destroyListeners();
        }
    }

    private synchronized void resize(int n) {
        if (n == this.queueSize) {
            return;
        }
        while (this.queue.size() > n) {
            this.dropNotification();
        }
        this.queue.resize(n);
        this.queueSize = n;
    }

    private ArrayNotificationBuffer(MBeanServer mBeanServer, int n) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "queueSize=" + n);
        }
        if (mBeanServer == null || n < 1) {
            throw new IllegalArgumentException("Bad args");
        }
        this.mBeanServer = mBeanServer;
        this.queueSize = n;
        this.queue = new ArrayQueue(n);
        this.nextSequenceNumber = this.earliestSequenceNumber = System.currentTimeMillis();
        logger.trace("Constructor", "ends");
    }

    private synchronized boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationResult fetchNotifications(NotificationBufferFilter notificationBufferFilter, long l, long l2, int n) throws InterruptedException {
        TargetedNotification[] targetedNotificationArray;
        logger.trace("fetchNotifications", "starts");
        if (l < 0L || this.isDisposed()) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
            }
        }
        if (notificationBufferFilter == null || l < 0L || l2 < 0L || n < 0) {
            logger.trace("fetchNotifications", "Bad args");
            throw new IllegalArgumentException("Bad args to fetch");
        }
        if (logger.debugOn()) {
            logger.trace("fetchNotifications", "filter=" + notificationBufferFilter + "; startSeq=" + l + "; timeout=" + l2 + "; max=" + n);
        }
        if (l > this.nextSequenceNumber()) {
            String string = "Start sequence number too big: " + l + " > " + this.nextSequenceNumber();
            logger.trace("fetchNotifications", string);
            throw new IllegalArgumentException(string);
        }
        long l3 = System.currentTimeMillis() + l2;
        if (l3 < 0L) {
            l3 = Long.MAX_VALUE;
        }
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "endTime=" + l3);
        }
        long l4 = -1L;
        long l5 = l;
        ArrayList<TargetedNotification> arrayList = new ArrayList<TargetedNotification>();
        while (true) {
            NamedNotification namedNotification;
            logger.debug("fetchNotifications", "main loop starts");
            targetedNotificationArray = this;
            synchronized (targetedNotificationArray) {
                if (l4 < 0L) {
                    l4 = this.earliestSequenceNumber();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "earliestSeq=" + l4);
                    }
                    if (l5 < l4) {
                        l5 = l4;
                        logger.debug("fetchNotifications", "nextSeq=earliestSeq");
                    }
                } else {
                    l4 = this.earliestSequenceNumber();
                }
                if (l5 < l4) {
                    logger.trace("fetchNotifications", "nextSeq=" + l5 + " < " + "earliestSeq=" + l4 + " so may have lost notifs");
                    break;
                }
                if (l5 < this.nextSequenceNumber()) {
                    namedNotification = this.notificationAt(l5);
                    if (!(notificationBufferFilter instanceof ServerNotifForwarder.NotifForwarderBufferFilter)) {
                        try {
                            ServerNotifForwarder.checkMBeanPermission(this.mBeanServer, namedNotification.getObjectName(), "addNotificationListener");
                        }
                        catch (InstanceNotFoundException instanceNotFoundException) {
                            if (logger.debugOn()) {
                                logger.debug("fetchNotifications", "candidate: " + namedNotification + " skipped. exception " + instanceNotFoundException);
                            }
                            ++l5;
                            continue;
                        }
                        catch (SecurityException securityException) {
                            if (logger.debugOn()) {
                                logger.debug("fetchNotifications", "candidate: " + namedNotification + " skipped. exception " + securityException);
                            }
                            ++l5;
                            continue;
                        }
                    }
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "candidate: " + namedNotification);
                        logger.debug("fetchNotifications", "nextSeq now " + l5);
                    }
                } else {
                    if (arrayList.size() > 0) {
                        logger.debug("fetchNotifications", "no more notifs but have some so don't wait");
                        break;
                    }
                    long l6 = l3 - System.currentTimeMillis();
                    if (l6 <= 0L) {
                        logger.debug("fetchNotifications", "timeout");
                        break;
                    }
                    if (this.isDisposed()) {
                        if (logger.debugOn()) {
                            logger.debug("fetchNotifications", "dispose callled, no wait");
                        }
                        return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
                    }
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "wait(" + l6 + ")");
                    }
                    this.wait(l6);
                    continue;
                }
            }
            targetedNotificationArray = namedNotification.getObjectName();
            Notification notification = namedNotification.getNotification();
            ArrayList<TargetedNotification> arrayList2 = new ArrayList<TargetedNotification>();
            logger.debug("fetchNotifications", "applying filter to candidate");
            notificationBufferFilter.apply(arrayList2, (ObjectName)targetedNotificationArray, notification);
            if (arrayList2.size() > 0) {
                if (n <= 0) {
                    logger.debug("fetchNotifications", "reached maxNotifications");
                    break;
                }
                --n;
                if (logger.debugOn()) {
                    logger.debug("fetchNotifications", "add: " + arrayList2);
                }
                arrayList.addAll(arrayList2);
            }
            ++l5;
        }
        int n2 = arrayList.size();
        targetedNotificationArray = new TargetedNotification[n2];
        arrayList.toArray(targetedNotificationArray);
        NotificationResult notificationResult = new NotificationResult(l4, l5, targetedNotificationArray);
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", notificationResult.toString());
        }
        logger.trace("fetchNotifications", "ends");
        return notificationResult;
    }

    synchronized long earliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    synchronized long nextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    synchronized void addNotification(NamedNotification namedNotification) {
        if (logger.traceOn()) {
            logger.trace("addNotification", namedNotification.toString());
        }
        while (this.queue.size() >= this.queueSize) {
            this.dropNotification();
            if (!logger.debugOn()) continue;
            logger.debug("addNotification", "dropped oldest notif, earliestSeq=" + this.earliestSequenceNumber);
        }
        this.queue.add(namedNotification);
        ++this.nextSequenceNumber;
        if (logger.debugOn()) {
            logger.debug("addNotification", "nextSeq=" + this.nextSequenceNumber);
        }
        this.notifyAll();
    }

    private void dropNotification() {
        this.queue.remove(0);
        ++this.earliestSequenceNumber;
    }

    synchronized NamedNotification notificationAt(long l) {
        long l2 = l - this.earliestSequenceNumber;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            String string = "Bad sequence number: " + l + " (earliest " + this.earliestSequenceNumber + ")";
            logger.trace("notificationAt", string);
            throw new IllegalArgumentException(string);
        }
        return this.queue.get((int)l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createListeners() {
        logger.debug("createListeners", "starts");
        HashSet<ObjectName> hashSet = this;
        synchronized (hashSet) {
            this.createdDuringQuery = new HashSet<ObjectName>();
        }
        try {
            this.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.creationListener, creationFilter, null);
            logger.debug("createListeners", "added creationListener");
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Can't add listener to MBean server delegate: " + exception);
            EnvHelp.initCause(illegalArgumentException, exception);
            logger.fine("createListeners", "Can't add listener to MBean server delegate: " + exception);
            logger.debug("createListeners", exception);
            throw illegalArgumentException;
        }
        hashSet = this.queryNames(null, broadcasterQuery);
        hashSet = new HashSet<ObjectName>(hashSet);
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            hashSet.addAll(this.createdDuringQuery);
            this.createdDuringQuery = null;
        }
        for (ObjectName objectName : hashSet) {
            this.addBufferListener(objectName);
        }
        logger.debug("createListeners", "ends");
    }

    private void addBufferListener(ObjectName objectName) {
        this.checkNoLocks();
        if (logger.debugOn()) {
            logger.debug("addBufferListener", objectName.toString());
        }
        try {
            this.addNotificationListener(objectName, this.bufferListener, null, objectName);
        }
        catch (Exception exception) {
            logger.trace("addBufferListener", exception);
        }
    }

    private void removeBufferListener(ObjectName objectName) {
        this.checkNoLocks();
        if (logger.debugOn()) {
            logger.debug("removeBufferListener", objectName.toString());
        }
        try {
            this.removeNotificationListener(objectName, this.bufferListener);
        }
        catch (Exception exception) {
            logger.trace("removeBufferListener", exception);
        }
    }

    private void addNotificationListener(final ObjectName objectName, final NotificationListener notificationListener, final NotificationFilter notificationFilter, final Object object) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(objectName, notificationListener, notificationFilter, object);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw ArrayNotificationBuffer.extractException(exception);
        }
    }

    private void removeNotificationListener(final ObjectName objectName, final NotificationListener notificationListener) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(objectName, notificationListener);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw ArrayNotificationBuffer.extractException(exception);
        }
    }

    private Set<ObjectName> queryNames(final ObjectName objectName, final QueryExp queryExp) {
        PrivilegedAction<Set<ObjectName>> privilegedAction = new PrivilegedAction<Set<ObjectName>>(){

            @Override
            public Set<ObjectName> run() {
                return ArrayNotificationBuffer.this.mBeanServer.queryNames(objectName, queryExp);
            }
        };
        try {
            return AccessController.doPrivileged(privilegedAction);
        }
        catch (RuntimeException runtimeException) {
            logger.fine("queryNames", "Failed to query names: " + runtimeException);
            logger.debug("queryNames", runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isInstanceOf(final MBeanServer mBeanServer, final ObjectName objectName, final String string) {
        PrivilegedExceptionAction<Boolean> privilegedExceptionAction = new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws InstanceNotFoundException {
                return mBeanServer.isInstanceOf(objectName, string);
            }
        };
        try {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (Exception exception) {
            logger.fine("isInstanceOf", "failed: " + exception);
            logger.debug("isInstanceOf", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createdNotification(MBeanServerNotification mBeanServerNotification) {
        if (!mBeanServerNotification.getType().equals("JMX.mbean.registered")) {
            logger.warning("createNotification", "bad type: " + mBeanServerNotification.getType());
            return;
        }
        ObjectName objectName = mBeanServerNotification.getMBeanName();
        if (logger.debugOn()) {
            logger.debug("createdNotification", "for: " + objectName);
        }
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            if (this.createdDuringQuery != null) {
                this.createdDuringQuery.add(objectName);
                return;
            }
        }
        if (ArrayNotificationBuffer.isInstanceOf(this.mBeanServer, objectName, broadcasterClass)) {
            this.addBufferListener(objectName);
            if (this.isDisposed()) {
                this.removeBufferListener(objectName);
            }
        }
    }

    private void destroyListeners() {
        this.checkNoLocks();
        logger.debug("destroyListeners", "starts");
        try {
            this.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.creationListener);
        }
        catch (Exception exception) {
            logger.warning("remove listener from MBeanServer delegate", exception);
        }
        Set<ObjectName> set = this.queryNames(null, broadcasterQuery);
        for (ObjectName objectName : set) {
            if (logger.debugOn()) {
                logger.debug("destroyListeners", "remove listener from " + objectName);
            }
            this.removeBufferListener(objectName);
        }
        logger.debug("destroyListeners", "ends");
    }

    private void checkNoLocks() {
        if (Thread.holdsLock(this) || Thread.holdsLock(globalLock)) {
            logger.warning("checkNoLocks", "lock protocol violation");
        }
    }

    private static Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    static {
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("JMX.mbean.registered");
        creationFilter = notificationFilterSupport;
        logger = new ClassLogger("javax.management.remote.misc", "ArrayNotificationBuffer");
        broadcasterClass = NotificationBroadcaster.class.getName();
    }

    private static class BroadcasterQuery
    extends QueryEval
    implements QueryExp {
        private BroadcasterQuery() {
        }

        public boolean apply(ObjectName objectName) {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            return ArrayNotificationBuffer.isInstanceOf(mBeanServer, objectName, broadcasterClass);
        }
    }

    private class BufferListener
    implements NotificationListener {
        private BufferListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            if (logger.debugOn()) {
                logger.debug("BufferListener.handleNotification", "notif=" + notification + "; handback=" + object);
            }
            ObjectName objectName = (ObjectName)object;
            ArrayNotificationBuffer.this.addNotification(new NamedNotification(objectName, notification));
        }
    }

    private static class NamedNotification {
        private final ObjectName sender;
        private final Notification notification;

        NamedNotification(ObjectName objectName, Notification notification) {
            this.sender = objectName;
            this.notification = notification;
        }

        ObjectName getObjectName() {
            return this.sender;
        }

        Notification getNotification() {
            return this.notification;
        }

        public String toString() {
            return "NamedNotification(" + this.sender + ", " + this.notification + ")";
        }
    }

    private class ShareBuffer
    implements NotificationBuffer {
        private final int size;

        ShareBuffer(int n) {
            this.size = n;
            ArrayNotificationBuffer.this.addSharer(this);
        }

        public NotificationResult fetchNotifications(NotificationBufferFilter notificationBufferFilter, long l, long l2, int n) throws InterruptedException {
            ArrayNotificationBuffer arrayNotificationBuffer = ArrayNotificationBuffer.this;
            return arrayNotificationBuffer.fetchNotifications(notificationBufferFilter, l, l2, n);
        }

        public void dispose() {
            ArrayNotificationBuffer.this.removeSharer(this);
        }

        int getSize() {
            return this.size;
        }
    }
}

