/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import org.openjdk.jmc.common.IMCClassLoader;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.messages.internal.Messages;
import org.openjdk.jmc.common.util.MethodToolkit;
import org.owasp.encoder.Encode;

public class FormatToolkit {
    private static final char LP = '(';
    private static final char RP = ')';
    private static final char LB = '[';
    private static final char CLASS_SUFFIX = ';';
    private static final char CLASS_PREFIX = 'L';
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String COMMA_SEPARATOR = ", ";
    private static final String ARRAY = "[]";

    public static String getHumanReadable(IMCMethod method) {
        return FormatToolkit.getHumanReadable(method, true, true, true, true, true, true);
    }

    public static String getHumanReadable(IMCMethod method, boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage) {
        String ret = "";
        try {
            if (showReturnValue) {
                ret = ret + FormatToolkit.getReturnType(method.getFormalDescriptor(), showReturnValuePackage) + ' ';
            }
            if (showClassName) {
                ret = ret + FormatToolkit.getType(method.getType(), showClassPackageName) + ".";
            }
            ret = ret + method.getMethodName();
            String arguments = FormatToolkit.getParameters(method.getFormalDescriptor(), showArgumentsPackage);
            ret = !"()".equals(arguments) && !showArguments ? ret + "(...)" : ret + arguments;
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public static String getPackage(IMCPackage mcPackage) {
        if (mcPackage == null) {
            return "null";
        }
        String packageName = mcPackage.getName();
        if (packageName == null) {
            return "null";
        }
        if (packageName.length() == 0) {
            return Messages.getString("FormatToolkit_DEFAULT_PACKAGE");
        }
        return packageName;
    }

    public static String getType(IMCType type, boolean qualified) {
        return qualified ? MethodToolkit.formatQualifiedName(type.getPackage(), type.getTypeName()) : type.getTypeName();
    }

    private static String getReturnType(String descriptor, boolean qualified) throws Exception {
        StringBuffer output = new StringBuffer();
        FormatToolkit.parseToken(output, descriptor.substring(descriptor.indexOf(41) + 1), 0, qualified);
        return output.toString();
    }

    private static String getParameters(String descriptor, boolean qualified) throws Exception {
        String input = descriptor.substring(descriptor.indexOf(40) + 1, descriptor.lastIndexOf(41));
        StringBuffer output = new StringBuffer(Character.toString('('));
        int next = -1;
        int current = 0;
        while (current < input.length() && (next = FormatToolkit.parseToken(output, input, current, qualified)) != current) {
            if (next < input.length()) {
                output.append(COMMA_SEPARATOR);
            }
            current = next;
        }
        return output.append(')').toString();
    }

    private static int parseToken(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        if (input.charAt(position) == '[') {
            return FormatToolkit.readArray(output, input, position, qualified);
        }
        if (input.charAt(position) == 'L') {
            return FormatToolkit.readComponentType(output, input, position, qualified);
        }
        return FormatToolkit.readPrimitive(output, input, position, qualified);
    }

    private static int readArray(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return FormatToolkit.write(output, ARRAY, FormatToolkit.parseToken(output, input, position + 1, qualified));
    }

    private static int readPrimitive(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return FormatToolkit.write(output, FormatToolkit.getPrimitiveType(input.charAt(position)), position + 1);
    }

    private static int write(StringBuffer output, String string, int next_position) {
        output.append(string);
        return next_position;
    }

    private static int readComponentType(StringBuffer output, String input, int position, boolean qualified) {
        int endIndex = input.indexOf(59, position);
        return FormatToolkit.write(output, FormatToolkit.getClass(input.substring(position + 1, endIndex).replace('/', '.'), qualified), endIndex + 1);
    }

    private static String getClass(String clazz, boolean qualified) {
        return qualified ? clazz : clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    private static String getPrimitiveType(char ch) {
        if (ch == 'Z') {
            return Boolean.TYPE.toString();
        }
        if (ch == 'B') {
            return Byte.TYPE.toString();
        }
        if (ch == 'S') {
            return Short.TYPE.toString();
        }
        if (ch == 'I') {
            return Integer.TYPE.toString();
        }
        if (ch == 'C') {
            return Character.TYPE.toString();
        }
        if (ch == 'J') {
            return Long.TYPE.toString();
        }
        if (ch == 'F') {
            return Float.TYPE.toString();
        }
        if (ch == 'D') {
            return Double.TYPE.toString();
        }
        if (ch == 'V') {
            return Void.TYPE.toString();
        }
        return null;
    }

    public static String getHumanReadable(IMCStackTrace trace) {
        return FormatToolkit.getHumanReadable(trace, true, true, true, true, true, true, Integer.MAX_VALUE, null, null, null);
    }

    public static String getHumanReadable(IMCStackTrace trace, String indent, String linePrefix, String lineSeparator) {
        return FormatToolkit.getHumanReadable(trace, true, true, true, true, true, true, Integer.MAX_VALUE, indent, linePrefix, lineSeparator);
    }

    public static String getHumanReadable(IMCStackTrace trace, boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage, int maximumVisibleStackTraceElements, String indent, String linePrefix, String lineSeparator) {
        indent = indent != null ? indent : "    ";
        linePrefix = linePrefix != null ? linePrefix : "at ";
        lineSeparator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        if (trace.getFrames() != null && trace.getFrames().size() > 0) {
            int rowIndex = 0;
            int count = trace.getFrames().size();
            for (IMCFrame iMCFrame : trace.getFrames()) {
                IMCMethod method = iMCFrame.getMethod();
                String methodText = Encode.forHtml((String)FormatToolkit.getHumanReadable(method, showReturnValue, showReturnValuePackage, showClassName, showClassPackageName, showArguments, showArgumentsPackage));
                sb.append(indent).append(linePrefix).append(methodText).append(lineSeparator);
                if (rowIndex == maximumVisibleStackTraceElements && rowIndex != count - 1) {
                    sb.append(indent).append("..." + lineSeparator);
                    return sb.toString();
                }
                ++rowIndex;
            }
        }
        return sb.toString();
    }

    public static String getHumanReadable(IMCClassLoader classLoader) {
        return classLoader == null ? null : classLoader.getType() + (classLoader.getName() != null && !classLoader.getName().isEmpty() ? " (\"" + classLoader.getName() + "\")" : "");
    }
}

