/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.tab.TriggerContentProvider;
import org.openjdk.jmc.console.ui.notification.tab.TriggerLabelProvider;
import org.openjdk.jmc.console.ui.notification.wizard.Messages;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;
import org.openjdk.jmc.ui.common.util.StatusFactory;
import org.openjdk.jmc.ui.wizards.ExportTreeToFileWizardPage;
import org.w3c.dom.Document;

public class RuleExportWizard
extends Wizard
implements IExportWizard {
    private RuleExportWizardPage m_wizardPage;
    private NotificationRegistry model;

    public boolean performFinish() {
        if (this.m_wizardPage.isExportToFileOk()) {
            try {
                boolean export = this.export(this.m_wizardPage.getFile(), this.filterOutRules(this.m_wizardPage.getSelectedItems()));
                if (export) {
                    this.m_wizardPage.storeFilename();
                }
                return export;
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RuleExportWizard_ERROR_EXPORTING_RULES_TITLE, (String)(String.valueOf(Messages.RuleExportWizard_ERROR_EXPORTING_RULES_TO_FILE_X_TEXT) + "\n\n" + this.m_wizardPage.getFile()), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    private boolean export(File file, Collection<TriggerRule> selection) throws IOException {
        Document doc = this.model.exportToXml(selection, false);
        XmlToolkit.storeDocumentToFile((Document)doc, (File)file);
        return true;
    }

    private Collection<TriggerRule> filterOutRules(Collection<?> collection) {
        HashSet<TriggerRule> rules = new HashSet<TriggerRule>();
        for (Object next : collection) {
            if (!(next instanceof TriggerRule)) continue;
            rules.add((TriggerRule)next);
        }
        return rules;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(NotificationPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.RuleExportWizard_TITLE_EXPORT_TRIGGER_RULES);
        this.model = NotificationPlugin.getDefault().getNotificationRepository();
        this.m_wizardPage = new RuleExportWizardPage(Messages.RuleExportWizard_RULE_EXPORT_WIZARD_NAME);
        this.m_wizardPage.setImageDescriptor(NotificationPlugin.getDefault().getMCImageDescriptor("new-trigger-wiz.gif"));
        this.m_wizardPage.setTitle(Messages.RuleExportWizard_WINDOW_TITLE_EXPORT_TRIGGER_RULES);
        this.m_wizardPage.setMessage(Messages.RuleExportWizard_DEFAULT_WIZARD_EXPORT_MESSAGE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean canFinish() {
        return this.m_wizardPage != null && this.m_wizardPage.isPageComplete();
    }

    class RuleExportWizardPage
    extends ExportTreeToFileWizardPage {
        public RuleExportWizardPage(String pageName) {
            super(pageName, "xml");
        }

        protected void initializeViewer(TreeViewer viewer) {
            TriggerContentProvider itcp = new TriggerContentProvider(RuleExportWizard.this.model);
            Object[] rootNodes = itcp.getElements("Whatever. The notification model is static!");
            viewer.setAutoExpandLevel(rootNodes.length == 1 ? -1 : 0);
            viewer.setContentProvider((IContentProvider)new TriggerContentProvider(RuleExportWizard.this.model));
            viewer.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider());
            viewer.setComparator(new ViewerComparator());
            viewer.setInput((Object)"Whatever. The notification model is static!");
        }
    }
}

