/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.action;

import java.io.IOException;
import java.text.ParseException;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.console.ui.notification.action.Messages;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfiguration;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;

public class TriggerActionRecordingToolkit {
    private TriggerActionRecordingToolkit() {
        throw new Error("Don't instantiate");
    }

    protected static IConstrainedMap<EventOptionID> getTemplate(String name, IFlightRecorderService service) throws FlightRecorderException {
        for (String templateXML : service.getServerTemplates()) {
            EventConfiguration template;
            try {
                template = new EventConfiguration(EventConfiguration.createModel((String)templateXML));
            }
            catch (ParseException parseException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            if (!template.getName().equals(name)) continue;
            IDescribedMap options = service.getDefaultEventOptions();
            return template.getEventOptions(options.emptyWithSameConstraints());
        }
        return null;
    }

    public static boolean supportsJfrAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IFlightRecorderService.class) != null;
    }

    public static boolean isActivatableJfrAction(IConnectionHandle handle) {
        IFlightRecorderService flrService = (IFlightRecorderService)handle.getServiceOrNull(IFlightRecorderService.class);
        try {
            return flrService != null && (flrService.isEnabled() || ControlPanel.askUserForEnable((IFlightRecorderService)flrService, (String)Messages.TriggerActionRecordingToolkit_COMMERCIAL_FEATURES_QUESTION_TRIGGERS));
        }
        catch (FlightRecorderException flightRecorderException) {
            return false;
        }
    }
}

