/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Set;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class StringDeduplicationRule
extends AbstractRule {
    private static final String NEW_LINE = "\n";
    private static final IItemFilter STRING_FILTER = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (Object)"java.lang.String");
    private static final TypedPreference<String> STRING_ARRAY_ALLOCATION_FRAMES = new TypedPreference("string.array.allocation.frames", Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES"), Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES_DESC"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"java.lang.String.<init>, java.lang.StringBuffer.toString, java.lang.StringBuffer.toString, java.lang.StringUTF16.newString, java.lang.StringLatin1.newString, java.lang.StringUTF16.toBytes, java.lang.StringBuilder.toBytes");
    private static final TypedPreference<IQuantity> STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT = new TypedPreference("string.array.liveset.ratio.and.heap.usage.limit", Messages.getString("StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT"), Messages.getString("StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(50L));
    private static final TypedPreference<IQuantity> STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT = new TypedPreference("string.array.allocation.ratio.and.heap.usage.limit", Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT"), Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(50L));

    public StringDeduplicationRule() {
        super("StringDeduplication", Messages.getString("StringDeduplicationRule_RULE_NAME"), "heap", new TypedPreference[]{STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT, STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT, STRING_ARRAY_ALLOCATION_FRAMES});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        JavaVersion javaVersion = RulesToolkit.getJavaVersion((IItemCollection)items);
        if (javaVersion == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION"));
        }
        String stringInternalArrayType = "byte[]";
        ITypedQuantity averageStringSize = UnitLookup.BYTE.quantity(50L);
        if (!javaVersion.isGreaterOrEqualThan(JavaVersionSupport.STRING_IS_BYTE_ARRAY)) {
            stringInternalArrayType = "char[]";
            Boolean compactStrings = (Boolean)items.getAggregate(JdkAggregators.COMPACT_STRINGS);
            if (Boolean.FALSE.equals(compactStrings)) {
                averageStringSize = UnitLookup.BYTE.quantity(100L);
            }
        }
        IItemFilter stringInternalArrayTypeFilter = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (Object)stringInternalArrayType);
        Boolean useStringDeduplication = (Boolean)items.getAggregate(JdkAggregators.USE_STRING_DEDUPLICATION);
        if (Boolean.TRUE.equals(useStringDeduplication)) {
            return new Result((IRule)this, 0.0, Messages.getString("StringDeduplicationRule_RESULT_USE_STRING_DEDUPLICATION_ENABLED"));
        }
        RulesToolkit.EventAvailability heapSummaryAvailable = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GCHeapSummary"});
        if (heapSummaryAvailable != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)heapSummaryAvailable, (String[])new String[]{"jdk.GCHeapSummary"});
        }
        RulesToolkit.EventAvailability objectCountAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectCount"});
        RulesToolkit.EventAvailability objectCountAfterGcAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectCountAfterGC"});
        RulesToolkit.EventAvailability allocationAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB"});
        if (objectCountAvail != RulesToolkit.EventAvailability.AVAILABLE && objectCountAfterGcAvail != RulesToolkit.EventAvailability.AVAILABLE && allocationAvail != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getRuleRequiresAtLeastOneEventTypeResult((IRule)this, (String[])new String[]{"jdk.ObjectCount", "jdk.ObjectCountAfterGC", "jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        }
        IQuantity stringLivesetRatioAndHeapUsageLimit = (IQuantity)vp.getPreferenceValue(STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT);
        IQuantity stringAllocationRatioAndHeapUsageLimit = (IQuantity)vp.getPreferenceValue(STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT);
        String allocationFramesString = (String)vp.getPreferenceValue(STRING_ARRAY_ALLOCATION_FRAMES);
        IQuantity maxHeapSizeConf = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
        ITypedQuantity maxHeapSizeFlag = UnitLookup.BYTE.quantity(((IQuantity)items.getAggregate(JdkAggregators.LARGEST_MAX_HEAP_SIZE_FROM_FLAG)).longValue());
        IQuantity maxHeapSize = maxHeapSizeConf != null ? maxHeapSizeConf : maxHeapSizeFlag;
        String heapInfo = MessageFormat.format(Messages.getString("StringDeduplicationRule_RESULT_NO_MAX_HEAP_INFO"), "jdk.GCHeapConfiguration", "jdk.UnsignedLongFlag");
        double heapUsedRatio = -1.0;
        if (maxHeapSize != null) {
            IQuantity avgHeapUsed = (IQuantity)items.getAggregate(JdkAggregators.AVG_HEAP_USED_AFTER_GC);
            heapUsedRatio = avgHeapUsed.ratioTo(maxHeapSize) * 100.0;
            heapInfo = MessageFormat.format(Messages.getString("StringDeduplicationRule_RESULT_HEAP_USAGE"), Math.round(heapUsedRatio));
        }
        Boolean useG1GC = (Boolean)items.getAggregate(JdkAggregators.USE_G1_GC);
        String extraCompatInfo = "";
        if (!Boolean.TRUE.equals(useG1GC)) {
            extraCompatInfo = extraCompatInfo + "<p>" + Messages.getString("StringDeduplicationRule_RESULT_NON_G1_LONG");
        }
        if (!javaVersion.isGreaterOrEqualThan(JavaVersionSupport.STRING_DEDUPLICATION_SUPPORTED)) {
            extraCompatInfo = extraCompatInfo + "<p>" + Messages.getString("StringDeduplicationRule_RESULT_PRE_8_20");
        }
        if (objectCountAvail == RulesToolkit.EventAvailability.AVAILABLE || objectCountAfterGcAvail == RulesToolkit.EventAvailability.AVAILABLE) {
            String objectCountEventType = objectCountAvail == RulesToolkit.EventAvailability.AVAILABLE ? "jdk.ObjectCount" : "jdk.ObjectCountAfterGC";
            return this.getLivesetRatioResult(items, stringInternalArrayType, stringInternalArrayTypeFilter, (IQuantity)averageStringSize, stringLivesetRatioAndHeapUsageLimit, objectCountEventType, heapInfo, heapUsedRatio, extraCompatInfo);
        }
        return this.getAllocationRatioResult(items, stringInternalArrayType, stringInternalArrayTypeFilter, stringAllocationRatioAndHeapUsageLimit, allocationFramesString, heapInfo, heapUsedRatio, extraCompatInfo);
    }

    private Result getLivesetRatioResult(IItemCollection items, String stringInternalArrayType, IItemFilter stringInternalArrayTypeFilter, IQuantity averageStringSize, IQuantity stringLivesetRatioAndHeapUsageLimit, String objectCountEventType, String heapInfo, double heapUsedRatio, String extraGcInfo) {
        IItemCollection objectCountItems = items.apply(ItemFilters.type((String)objectCountEventType));
        double stringMaxRatio = 0.0;
        Set gcIds = (Set)objectCountItems.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.GC_ID));
        for (IQuantity gcId : gcIds) {
            IItemCollection livesetForGc = objectCountItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)gcId));
            IItemCollection stringObjectCountItems = livesetForGc.apply(STRING_FILTER);
            IQuantity stringCount = (IQuantity)stringObjectCountItems.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.COUNT));
            if (stringCount == null || stringCount.longValue() <= 0L) continue;
            IItemCollection stringInternalArrayObjectCountItems = livesetForGc.apply(stringInternalArrayTypeFilter);
            IQuantity totalLivesetSize = (IQuantity)livesetForGc.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.HEAP_TOTAL));
            IQuantity arraySize = (IQuantity)stringInternalArrayObjectCountItems.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.HEAP_TOTAL));
            IQuantity stringInternalArrayCount = (IQuantity)stringInternalArrayObjectCountItems.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.COUNT));
            if (stringCount.compareTo((Object)stringInternalArrayCount) == 0) {
                IQuantity stringInternalArraySize = arraySize;
                double newRatio = stringInternalArraySize.ratioTo(totalLivesetSize) * 100.0;
                if (!(newRatio > stringMaxRatio)) continue;
                stringMaxRatio = newRatio;
                continue;
            }
            IQuantity averageStringInternalArraySize = averageStringSize.multiply(stringCount.longValue());
            double newMaxRatio = averageStringInternalArraySize.ratioTo(totalLivesetSize) * 100.0;
            if (!(newMaxRatio > stringMaxRatio)) continue;
            stringMaxRatio = newMaxRatio;
        }
        String description = MessageFormat.format(Messages.getString("StringDeduplicationRule_RESULT_STRING_ARRAY_LIVESET_RATIO"), Math.round(stringMaxRatio), stringInternalArrayType) + NEW_LINE + heapInfo;
        double scoreBase = stringMaxRatio + stringMaxRatio * heapUsedRatio / 100.0;
        double score = RulesToolkit.mapExp74((double)scoreBase, (double)stringLivesetRatioAndHeapUsageLimit.doubleValue());
        String recommendation = stringMaxRatio > stringLivesetRatioAndHeapUsageLimit.doubleValue() ? Messages.getString("StringDeduplicationRule_RESULT_RECOMMEND_STRING_DEDUPLICATION") : Messages.getString("StringDeduplicationRule_RESULT_DONT_RECOMMEND_STRING_DEDUPLICATION");
        String shortMessage = description + " " + recommendation;
        String longMessage = shortMessage + "<p>" + Messages.getString("StringDeduplicationRule_RESULT_LONG_DESCRIPTION") + extraGcInfo;
        return new Result((IRule)this, score, shortMessage, longMessage);
    }

    private Result getAllocationRatioResult(IItemCollection items, String stringInternalArrayType, IItemFilter stringInternalArrayTypeFilter, IQuantity stringAllocationRatioLimit, String allocationFramesString, String heapInfo, double heapUsedRatio, String extraGcInfo) {
        IItemFilter allocationFrameFilter;
        IItemCollection allocItems = items.apply(JdkFilters.ALLOC_ALL);
        IQuantity totalSize = (IQuantity)allocItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        IItemCollection arrayAllocItems = allocItems.apply(stringInternalArrayTypeFilter);
        IItemCollection stringInternalArrayAllocItems = arrayAllocItems.apply(allocationFrameFilter = this.getAllocationFramesFilter(allocationFramesString));
        IQuantity stringInternalArraySizeBasedOnStacktrace = (IQuantity)stringInternalArrayAllocItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        if (stringInternalArraySizeBasedOnStacktrace == null) {
            return new Result((IRule)this, -1.0, Messages.getString("StringDeduplicationRule_RESULT_NO_ALLOC_ITEMS"));
        }
        double stringAllocationRatioBasedOnStacktrace = stringInternalArraySizeBasedOnStacktrace.ratioTo(totalSize) * 100.0;
        double scoreBase = stringAllocationRatioBasedOnStacktrace + stringAllocationRatioBasedOnStacktrace * heapUsedRatio / 100.0;
        double score = RulesToolkit.mapExp74((double)scoreBase, (double)stringAllocationRatioLimit.doubleValue());
        String description = MessageFormat.format(Messages.getString("StringDeduplicationRule_RESULT_STRING_ARRAY_ALLOCATION_RATIO"), Math.round(stringAllocationRatioBasedOnStacktrace), stringInternalArrayType) + NEW_LINE + heapInfo;
        String recommendation = stringAllocationRatioBasedOnStacktrace > stringAllocationRatioLimit.doubleValue() ? Messages.getString("StringDeduplicationRule_RESULT_RECOMMEND_STRING_DEDUPLICATION") : Messages.getString("StringDeduplicationRule_RESULT_DONT_RECOMMEND_STRING_DEDUPLICATION");
        String shortMessage = description + " " + recommendation;
        String longMessage = shortMessage + "<p>" + Messages.getString("StringDeduplicationRule_RESULT_LONG_DESCRIPTION") + extraGcInfo;
        return new Result((IRule)this, score, shortMessage, longMessage);
    }

    private IItemFilter getAllocationFramesFilter(String allocationFramesString) {
        if (allocationFramesString.replace(',', ' ').trim().isEmpty()) {
            return ItemFilters.none();
        }
        String[] allocationFrames = allocationFramesString.split(",");
        IItemFilter[] frameFilters = new IItemFilter[allocationFrames.length];
        for (int i = 0; i < frameFilters.length; ++i) {
            frameFilters[i] = ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_STRING, (String)allocationFrames[i].trim());
        }
        return ItemFilters.or((IItemFilter[])frameFilters);
    }
}

