/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LongGcPauseRule
implements IRule {
    private static final String RESULT_ID = "LongGcPause";
    public static final TypedPreference<IQuantity> GC_PAUSE_INFO_LIMIT = new TypedPreference("gc.pause.info.limit", Messages.getString("LongGcPauseRule_CONFIG_INFO_LIMIT"), Messages.getString("LongGcPauseRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(1000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(GC_PAUSE_INFO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GCPhasePause", "jdk.GCConfiguration", "jdk.GCHeapConfiguration", "jdk.GCPhasePauseLevel1"});
        if (eventAvailability == RulesToolkit.EventAvailability.DISABLED || eventAvailability == RulesToolkit.EventAvailability.UNKNOWN) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.GCPhasePause", "jdk.GCConfiguration", "jdk.GCHeapConfiguration", "jdk.GCPhasePauseLevel1"});
        }
        IQuantity maxPause = (IQuantity)items.getAggregate(JdkAggregators.LONGEST_GC_PAUSE);
        if (maxPause != null) {
            String message = MessageFormat.format(Messages.getString("LongGcPauseRuleFactory_TEXT_INFO"), maxPause.displayUsing("auto"));
            double gcPauseScore = RulesToolkit.mapExp74((double)maxPause.doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)((IQuantity)vp.getPreferenceValue(GC_PAUSE_INFO_LIMIT)).doubleValueIn((IUnit)UnitLookup.MILLISECOND));
            String longMessage = message;
            if (gcPauseScore >= 25.0) {
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getLivesetMessage(items));
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getSemiRefsMessage(items));
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getCollectorMessage(items));
            }
            return new Result((IRule)this, gcPauseScore, message, longMessage);
        }
        return new Result((IRule)this, 0.0, Messages.getString("LongGcPauseRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return LongGcPauseRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private static String appendMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return message + " " + newMessage;
    }

    private static String getCollectorMessage(IItemCollection items) {
        CollectorType oldCollectorType = CollectorType.getOldCollectorType(items);
        if (oldCollectorType != CollectorType.G1_OLD) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_G1");
        }
        return null;
    }

    private static String getLivesetMessage(IItemCollection items) {
        int live;
        IQuantity liveSet = (IQuantity)items.getAggregate(JdkAggregators.AVG_HEAP_USED_AFTER_GC);
        IQuantity maxMx = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
        if (liveSet != null && maxMx != null && (live = (int)(liveSet.ratioTo(maxMx) * 100.0)) < 50) {
            return MessageFormat.format(Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_MX"), liveSet.displayUsing("auto"), maxMx.displayUsing("auto"));
        }
        return null;
    }

    private static String getSemiRefsMessage(IItemCollection items) {
        IQuantity aggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.max((String)"jdk.GCPhasePauseLevel1", (IAttribute)JfrAttributes.DURATION), (IItemFilter)ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_PHASE_NAME, (Object)"References")));
        if (aggregate == null) {
            return null;
        }
        int max = aggregate.compareTo((Object)UnitLookup.MILLISECOND.quantity(50L));
        if (max >= 50) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_REFERENCES");
        }
        return null;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("LongGcPauseRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

