/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeModel;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeObject;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class IncreasingLiveSetRule
implements IRule {
    private static final double PERCENT_OF_HEAP_INCREASE_PER_SECOND = 0.01;
    private static final String RESULT_ID = "IncreasingLiveSet";
    public static final TypedPreference<IQuantity> CLASSES_LOADED_PERCENT = new TypedPreference("memleak.classload.percent", Messages.getString("IncreasingLiveSetRule_LOADED_CLASSES_PERCENT"), Messages.getString("IncreasingLiveSetRule_LOADED_CLASSES_PERCENT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(90L));
    public static final TypedPreference<IQuantity> RELEVANCE_THRESHOLD = new TypedPreference("memleak.reference.tree.depth", Messages.getString("IncreasingLiveSetRule_RELEVANCE_THRESHOLD"), Messages.getString("IncreasingLiveSetRule_RELEVANCE_THRESHOLD_DESC"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    public static final TypedPreference<IQuantity> YOUNG_COLLECTION_THRESHOLD = new TypedPreference("memleak.young.collections", Messages.getString("IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD"), Messages.getString("IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD_DESC"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(4L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CLASSES_LOADED_PERCENT, RELEVANCE_THRESHOLD, YOUNG_COLLECTION_THRESHOLD);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability ea;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GCHeapSummary"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.GCHeapSummary"});
        }
        IQuantity postWarmupTime = this.getPostWarmupTime(items, (IQuantity)valueProvider.getPreferenceValue(CLASSES_LOADED_PERCENT));
        Iterator allAfterItems = items.apply(JdkFilters.HEAP_SUMMARY_AFTER_GC).iterator();
        double score = 0.0;
        ITypedQuantity liveSetIncreasePerSecond = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI).quantity(0L);
        if (allAfterItems.hasNext()) {
            IItemIterable afterItems = (IItemIterable)allAfterItems.next();
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(afterItems.getType());
            IMemberAccessor memAccessor = JdkAttributes.HEAP_USED.getAccessor(afterItems.getType());
            liveSetIncreasePerSecond = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI).quantity(RulesToolkit.leastSquareMemory((Iterator)afterItems.iterator(), (IMemberAccessor)timeAccessor, (IMemberAccessor)memAccessor));
            if (postWarmupTime == null) {
                return RulesToolkit.getTooFewEventsResult((IRule)this);
            }
            IQuantity postWarmupHeapSize = (IQuantity)items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.HEAP_SUMMARY_AFTER_GC, ItemFilters.moreOrEqual((ICanonicalAccessorFactory)JfrAttributes.START_TIME, (Comparable)postWarmupTime)})).getAggregate(JdkAggregators.first((IAttribute)JdkAttributes.HEAP_USED));
            if (postWarmupHeapSize == null) {
                return RulesToolkit.getTooFewEventsResult((IRule)this);
            }
            double relativeIncreasePerSecond = liveSetIncreasePerSecond.ratioTo(postWarmupHeapSize);
            score = RulesToolkit.mapExp100((double)relativeIncreasePerSecond, (double)0.01);
        }
        IQuantity youngCollections = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"jdk.YoungGarbageCollection")));
        IQuantity oldCollections = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)JdkFilters.OLD_GARBAGE_COLLECTION));
        if (oldCollections.longValue() == 0L) {
            if (youngCollections.longValue() <= ((IQuantity)valueProvider.getPreferenceValue(YOUNG_COLLECTION_THRESHOLD)).longValue()) {
                return RulesToolkit.getTooFewEventsResult((IRule)this);
            }
            score = Math.min(score, 74.0);
        }
        if ((ea = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.OldObjectSample"})) == RulesToolkit.EventAvailability.DISABLED || ea == RulesToolkit.EventAvailability.UNKNOWN) {
            if (score >= 25.0) {
                IQuantity timeAfterJVMStart = ((IQuantity)items.getAggregate(JdkAggregators.FIRST_ITEM_START)).subtract((IQuantity)items.getAggregate(JdkAggregators.JVM_START_TIME));
                String shortMessage = MessageFormat.format(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO"), liveSetIncreasePerSecond.displayUsing("auto"));
                String longMessage = shortMessage + "<p>" + MessageFormat.format(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO_LONG"), timeAfterJVMStart.displayUsing("auto"));
                return new Result((IRule)this, score, shortMessage, longMessage, JdkQueries.HEAP_SUMMARY_AFTER_GC);
            }
            return new Result((IRule)this, score, Messages.getString("IncreasingLiveSetRule_TEXT_OK"));
        }
        IItemCollection oldObjectItems = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.OldObjectSample"), ItemFilters.more((ICanonicalAccessorFactory)JfrAttributes.START_TIME, (Comparable)postWarmupTime)}));
        ReferenceTreeModel tree = ReferenceTreeModel.buildReferenceTree((IItemCollection)oldObjectItems);
        boolean anyReferrerChains = false;
        for (ReferenceTreeObject referenceTreeObject : tree.getLeakObjects()) {
            if (referenceTreeObject.getParent() == null) continue;
            anyReferrerChains = true;
            break;
        }
        if (!anyReferrerChains) {
            List calculateGroupingScore = RulesToolkit.calculateGroupingScore((IItemCollection)oldObjectItems, (IAccessorFactory)JdkAttributes.OLD_OBJECT_CLASS);
            double calculateBalanceScore = RulesToolkit.calculateBalanceScore((List)calculateGroupingScore);
            String shortDescription = MessageFormat.format("IncreasingLiveSetRuleFactory_TEXT_INFO", liveSetIncreasePerSecond.displayUsing("auto")) + (calculateBalanceScore >= 25.0 ? Messages.getString("IncreasingLiveSetRule_TEXT_INFO_UNBALANCED") : Messages.getString("IncreasingLiveSetRule_TEXT_INFO_BALANCED"));
            return new Result((IRule)this, Math.min(calculateBalanceScore, 25.0), shortDescription, Messages.getString("IncreasingLiveSetRule_TEXT_INFO_LONG"));
        }
        List leakCandidates = tree.getLeakCandidates(((IQuantity)valueProvider.getPreferenceValue(RELEVANCE_THRESHOLD)).doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY));
        if (leakCandidates.size() > 0) {
            StringBuilder descriptionBuilder = new StringBuilder();
            descriptionBuilder.append(MessageFormat.format(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO"), liveSetIncreasePerSecond.displayUsing("auto")));
            descriptionBuilder.append("<br/>");
            descriptionBuilder.append(MessageFormat.format(Messages.getString("IncreasingLiveSetRule_LEAK_CANDIDATES"), leakCandidates.size()));
            descriptionBuilder.append("<ul>");
            int objectFormat = 19;
            for (ReferenceTreeObject candidate : leakCandidates) {
                descriptionBuilder.append("<li>");
                descriptionBuilder.append(candidate.toString(objectFormat));
                descriptionBuilder.append("<br/>");
                descriptionBuilder.append(Messages.getString("IncreasingLiveSetRule_CANDIDATE_REFERRED_BY"));
                descriptionBuilder.append("<ul>");
                ReferenceTreeObject chainObject = candidate.getParent();
                for (int i = 0; i < 10 && chainObject != null; chainObject = chainObject.getParent(), ++i) {
                    descriptionBuilder.append("<li>");
                    descriptionBuilder.append(chainObject.toString(objectFormat));
                    if (chainObject.getParent() == null) {
                        descriptionBuilder.append(" (");
                        descriptionBuilder.append(chainObject.getRootDescription());
                        descriptionBuilder.append(")</li>");
                        break;
                    }
                    descriptionBuilder.append("</li>");
                }
                if (chainObject != null && chainObject.getParent() != null) {
                    while (chainObject.getParent() != null) {
                        chainObject = chainObject.getParent();
                    }
                    descriptionBuilder.append("<li>");
                    descriptionBuilder.append(Messages.getString("IncreasingLiveSetRule_ELLIPSIS"));
                    descriptionBuilder.append("</li><li>");
                    descriptionBuilder.append(chainObject.toString(objectFormat));
                    descriptionBuilder.append(" (");
                    descriptionBuilder.append(chainObject.getRootDescription());
                    descriptionBuilder.append(")</li>");
                }
                descriptionBuilder.append("</ul>");
                descriptionBuilder.append("</li>");
            }
            descriptionBuilder.append("</ul>");
            return new Result((IRule)this, score, descriptionBuilder.toString());
        }
        String description = "";
        if (score >= 25.0) {
            description = MessageFormat.format(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO"), liveSetIncreasePerSecond.displayUsing("auto")) + "</br>";
        }
        return new Result((IRule)this, score, description + MessageFormat.format(Messages.getString("IncreasingLiveSetRule_TEXT_INFO_NO_CANDIDATES"), postWarmupTime.displayUsing("auto")), null, JdkQueries.HEAP_SUMMARY_AFTER_GC);
    }

    private IQuantity getPostWarmupTime(IItemCollection items, IQuantity classesLoadedPercent) {
        IItemCollection classLoadItems = items.apply(JdkFilters.CLASS_LOAD_STATISTICS);
        IQuantity maxLoadedClasses = (IQuantity)classLoadItems.getAggregate(Aggregators.max((IAttribute)JdkAttributes.CLASSLOADER_LOADED_COUNT));
        if (maxLoadedClasses == null) {
            return null;
        }
        double doubleValue = classesLoadedPercent.doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY);
        IQuantity loadedClassesLimit = maxLoadedClasses.multiply(doubleValue);
        return (IQuantity)classLoadItems.apply(ItemFilters.more((ICanonicalAccessorFactory)JdkAttributes.CLASSLOADER_LOADED_COUNT, (Comparable)loadedClassesLimit)).getAggregate(Aggregators.min((IAttribute)JfrAttributes.START_TIME));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return IncreasingLiveSetRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("IncreasingLiveSetRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "memoryleak";
    }
}

