/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanSquare;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class HighGcRule
implements IRule {
    private static final String RESULT_ID = "HighGc";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GCPhasePause"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.GCPhasePause"});
        }
        SpanSquare longestGcCluster = HighGcRule.calculateLongestGcCluster(items.apply(JdkFilters.GC_PAUSE));
        if (longestGcCluster != null) {
            long sumPauseNanos = longestGcCluster.mass;
            long durationNanos = longestGcCluster.end - longestGcCluster.start;
            ITypedQuantity pausePercent = UnitLookup.PERCENT_UNITY.quantity((double)sumPauseNanos / (double)durationNanos);
            double score = RulesToolkit.mapExp100Y((double)sumPauseNanos, (double)1.0E9, (double)90.0);
            String startTime = KindOfQuantity.format((Number)longestGcCluster.start, (IUnit)UnitLookup.EPOCH_NS);
            String duration = KindOfQuantity.format((Number)durationNanos, (IUnit)UnitLookup.NANOSECOND);
            String message = MessageFormat.format(Messages.getString("HighGcRuleFactory_TEXT_INFO"), duration, startTime, pausePercent.displayUsing("auto"));
            String longMessage = message + " " + Messages.getString("HighGcRuleFactory_TEXT_INFO_LONG");
            if (!RulesToolkit.isEventsEnabled((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"})) {
                longMessage = longMessage + "<p>" + RulesToolkit.getEnabledEventTypesRecommendation((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
            }
            return new Result((IRule)this, score, message, longMessage, JdkQueries.GC_PAUSE);
        }
        return new Result((IRule)this, 0.0, Messages.getString("HighGcRuleFactory_TEXT_OK"), null, JdkQueries.GC_PAUSE);
    }

    private static SpanSquare calculateLongestGcCluster(IItemCollection items) {
        return SpanToolkit.getMaxDurationCluster(items);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return HighGcRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HighGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }
}

