/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;

class GarbageCollectionsInfo
implements IItemConsumer<GarbageCollectionsInfo> {
    private final IMemberAccessor<String, IItem> causeAccessor;
    private final IMemberAccessor<String, IItem> nameAccessor;
    private int gcCount;
    private int systemGcCount;
    private int gcLockers;
    private int objectCountGCs;
    private boolean nonRequestedSerialOldGc;
    public static final IAggregator<GarbageCollectionsInfo, ?> GC_INFO_AGGREGATOR = new Aggregators.MergingAggregator<GarbageCollectionsInfo, GarbageCollectionsInfo>(null, null, (IType)UnitLookup.UNKNOWN){

        public boolean acceptType(IType<IItem> type) {
            return type.getIdentifier().equals("jdk.GarbageCollection");
        }

        public GarbageCollectionsInfo newItemConsumer(IType<IItem> type) {
            IMemberAccessor causeAccessor = JdkAttributes.GC_CAUSE.getAccessor(type);
            IMemberAccessor nameAccessor = JdkAttributes.GC_NAME.getAccessor(type);
            return new GarbageCollectionsInfo((IMemberAccessor<String, IItem>)causeAccessor, (IMemberAccessor<String, IItem>)nameAccessor);
        }

        public GarbageCollectionsInfo getValue(GarbageCollectionsInfo consumer) {
            return consumer == null ? new GarbageCollectionsInfo(null, null) : consumer;
        }
    };

    GarbageCollectionsInfo(IMemberAccessor<String, IItem> causeAccessor, IMemberAccessor<String, IItem> nameAccessor) {
        this.causeAccessor = causeAccessor;
        this.nameAccessor = nameAccessor;
    }

    public int getGcCount() {
        return this.gcCount;
    }

    public int getGcLockers() {
        return this.gcLockers;
    }

    public int getObjectCountGCs() {
        return this.objectCountGCs;
    }

    public int getSystemGcCount() {
        return this.systemGcCount;
    }

    public boolean foundNonRequestedSerialOldGc() {
        return this.nonRequestedSerialOldGc;
    }

    public void consume(IItem item) {
        String cause = (String)this.causeAccessor.getMember((Object)item);
        String string = cause = cause != null ? cause.toLowerCase() : "";
        if ("heap inspection initiated gc".equals(cause)) {
            ++this.objectCountGCs;
        } else if ("system.gc()".equals(cause)) {
            ++this.systemGcCount;
        } else {
            if (cause.contains("gclocker")) {
                ++this.gcLockers;
            }
            if (!this.nonRequestedSerialOldGc && CollectorType.SERIAL_OLD.getCollectorName().equals(this.nameAccessor.getMember((Object)item))) {
                this.nonRequestedSerialOldGc = true;
            }
        }
        ++this.gcCount;
    }

    public GarbageCollectionsInfo merge(GarbageCollectionsInfo other) {
        this.gcCount += other.gcCount;
        this.systemGcCount += other.systemGcCount;
        this.gcLockers += other.gcLockers;
        this.objectCountGCs += other.objectCountGCs;
        this.nonRequestedSerialOldGc |= other.nonRequestedSerialOldGc;
        return this;
    }
}

