/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FullGcRule
implements IRule {
    private static final String FULL_GC_RESULT_ID = "FullGc";

    public RunnableFuture<Result> evaluate(final IItemCollection items, IPreferenceValueProvider valueProvider) {
        return new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                IQuantity c;
                CollectorType collectorType = CollectorType.getOldCollectorType(items);
                if (!CollectorType.CMS.equals((Object)collectorType) && !CollectorType.G1_OLD.equals((Object)collectorType)) {
                    return RulesToolkit.getNotApplicableResult((IRule)FullGcRule.this, (String)Messages.getString("FullGcRule_OTHER_COLLECTOR_IN_USE"));
                }
                String[] eventTypes = CollectorType.CMS.equals((Object)collectorType) ? new String[]{"jdk.OldGarbageCollection"} : G1Aggregator.EVENT_TYPES;
                if (!FullGcRule.this.hasAvailableEvents(items, eventTypes)) {
                    return RulesToolkit.getEventAvailabilityResult((IRule)FullGcRule.this, (IItemCollection)items, (RulesToolkit.EventAvailability)RulesToolkit.getEventAvailability((IItemCollection)items, (String[])eventTypes), (String[])eventTypes);
                }
                int fullGCs = CollectorType.CMS.equals((Object)collectorType) ? ((c = (IQuantity)items.getAggregate(Aggregators.count(null, null, (IItemFilter)JdkFilters.OLD_GARBAGE_COLLECTION))) == null ? 0 : c.clampedIntFloorIn((IUnit)UnitLookup.NUMBER_UNITY)) : ((G1FullGCInfo)items.getAggregate((IAggregator)new G1Aggregator())).fullGCs;
                if (fullGCs > 0) {
                    return new Result((IRule)FullGcRule.this, 100.0, Messages.getString("FullGcRule_FULL_GC_OCCURRED_TITLE"), Messages.getString("FullGcRule_FULL_GC_OCCURRED_DESC"));
                }
                return new Result((IRule)FullGcRule.this, 0.0, Messages.getString("FullGcRule_NO_FULL_GC_OCCURRED"));
            }
        });
    }

    private boolean hasAvailableEvents(IItemCollection items, String[] eventTypes) {
        return RulesToolkit.getEventAvailability((IItemCollection)items, (String[])eventTypes) == RulesToolkit.EventAvailability.AVAILABLE;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return FULL_GC_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FullGcRule_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    private static class G1FullGCInfo
    implements IItemConsumer<G1FullGCInfo> {
        private final IMemberAccessor<String, IItem> accessor;
        int fullGCs = 0;

        G1FullGCInfo(IMemberAccessor<String, IItem> accessor) {
            this.accessor = accessor;
        }

        public G1FullGCInfo merge(G1FullGCInfo other) {
            this.fullGCs += other.fullGCs;
            return this;
        }

        public void consume(IItem item) {
            if (this.accessor == null) {
                return;
            }
            String gcName = (String)this.accessor.getMember((Object)item);
            if (gcName.equals(CollectorType.G1_FULL.getCollectorName())) {
                ++this.fullGCs;
            }
        }
    }

    private static class G1Aggregator
    extends Aggregators.MergingAggregator<G1FullGCInfo, G1FullGCInfo> {
        static final String[] EVENT_TYPES = new String[]{"jdk.GarbageCollection"};

        G1Aggregator() {
            super(null, null, (IType)UnitLookup.UNKNOWN);
        }

        public final boolean acceptType(IType<IItem> type) {
            return Arrays.asList(EVENT_TYPES).contains(type.getIdentifier());
        }

        public G1FullGCInfo newItemConsumer(IType<IItem> type) {
            return new G1FullGCInfo((IMemberAccessor<String, IItem>)JdkAttributes.GC_NAME.getAccessor(type));
        }

        public G1FullGCInfo getValue(G1FullGCInfo consumer) {
            return consumer == null ? new G1FullGCInfo(null) : consumer;
        }
    }
}

