/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class CompressedOopsRule
implements IRule {
    private static final String RESULT_ID = "CompressedOops";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.BooleanFlag", "jdk.UnsignedLongFlag", "jdk.JVMInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.BooleanFlag", "jdk.UnsignedLongFlag", "jdk.JVMInformation"});
        }
        Boolean compressedOops = (Boolean)items.getAggregate(Aggregators.or((String)"jdk.GCHeapConfiguration", (IAttribute)JdkAttributes.HEAP_USE_COMPRESSED_OOPS));
        IQuantity mx = (IQuantity)items.getAggregate(JdkAggregators.LARGEST_MAX_HEAP_SIZE_FROM_FLAG);
        String vmName = (String)items.getAggregate(JdkAggregators.JVM_NAME);
        if (compressedOops != null && mx != null && vmName != null && vmName.toUpperCase().contains("64-BIT") && mx.compareTo((Object)UnitLookup.NUMBER.getUnit((IPrefix)BinaryPrefix.GIBI).quantity(32L)) > 0 && !compressedOops.booleanValue()) {
            return new Result((IRule)this, 50.0, Messages.getString("CompressedOopsRuleFactory_TEXT_INFO"), Messages.getString("CompressedOopsRuleFactory_TEXT_INFO_LONG"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("CompressedOopsRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return CompressedOopsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("CompressedOopsRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "gc_configuration";
    }
}

