/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.concurrent.FutureTask;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.HaltsProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class ApplicationHaltsRule
extends AbstractRule {
    public static final TypedPreference<IQuantity> APP_HALTS_INFO_LIMIT = new TypedPreference("app.halts.info.limit", Messages.getString("ApplicationHaltsRule_HALTS_INFO_LIMIT"), Messages.getString("ApplicationHaltsRule_HALTS_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(5L));
    public static final TypedPreference<IQuantity> APP_HALTS_WARNING_LIMIT = new TypedPreference("app.halts.warning.limit", Messages.getString("ApplicationHaltsRule_HALTS_WARNING_LIMIT"), Messages.getString("ApplicationHaltsRule_HALTS_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(10L));
    public static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("app.halts.window.size", Messages.getString("ApplicationHaltsRule_HALTS_WINDOW_SIZE"), Messages.getString("ApplicationHaltsRule_HALTS_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(60L));

    public ApplicationHaltsRule() {
        super("ApplicationHalts", Messages.getString("ApplicationHaltsRule_RULE_NAME"), "java_application", new TypedPreference[]{APP_HALTS_INFO_LIMIT, APP_HALTS_WARNING_LIMIT, WINDOW_SIZE});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        String shortDescription;
        String[] requiredTypes = new String[]{"jdk.GCPhasePause", "jdk.ExecuteVMOperation"};
        Object[] extraTypes = new String[]{"jdk.SafepointBegin"};
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])requiredTypes);
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE && eventAvailability != RulesToolkit.EventAvailability.ENABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])requiredTypes);
        }
        String extraTypesInfo = null;
        RulesToolkit.EventAvailability extraEventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])extraTypes);
        if (extraEventAvailability != RulesToolkit.EventAvailability.AVAILABLE && extraEventAvailability != RulesToolkit.EventAvailability.ENABLED) {
            extraTypesInfo = MessageFormat.format(Messages.getString("ApplicationHaltsRule_EXTRA_EVENT_TYPES"), StringToolkit.join((Object[])extraTypes, (String)", "));
        }
        IQuantity infoLimit = (IQuantity)vp.getPreferenceValue(APP_HALTS_INFO_LIMIT);
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(APP_HALTS_WARNING_LIMIT);
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(WINDOW_SIZE);
        HaltsProvider.ApplicationHaltsInfoHolder haltsRatios = HaltsProvider.calculateApplicationHaltsRatio(items);
        Pair haltsWindowRatio = SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue((IItemCollection)items, (IQuantity)windowSize, (FutureTask)this.evaluationTask, HaltsProvider.applicationHaltsRatioFunction(), ApplicationHaltsRule.applicationHaltsComparator(), (boolean)true, (boolean)true);
        IQuantity haltsTotalWindowRatio = ((HaltsProvider.ApplicationHaltsInfoHolder)haltsWindowRatio.left).getTotalHaltsRatio();
        IQuantity nonGcHaltsToTotalRatio = ((HaltsProvider.ApplicationHaltsInfoHolder)haltsWindowRatio.left).getNonGcHaltsToTotalRatio();
        double score = RulesToolkit.mapExp100((double)haltsTotalWindowRatio.doubleValue(), (double)infoLimit.doubleValue(), (double)warningLimit.doubleValue());
        String startTimeString = ((IQuantity)((IRange)haltsWindowRatio.right).getStart()).displayUsing("auto");
        String durationString = ((IQuantity)((IRange)haltsWindowRatio.right).getExtent()).displayUsing("auto");
        String longDescription = MessageFormat.format(Messages.getString("ApplicationHaltsRule_RULE_TEXT_LONG"), haltsTotalWindowRatio, durationString, startTimeString, nonGcHaltsToTotalRatio, haltsRatios.getTotalHaltsRatio(), haltsRatios.getNonGcHaltsToTotalRatio());
        if (score >= 25.0) {
            shortDescription = Messages.getString("ApplicationHaltsRule_RULE_TEXT");
            longDescription = longDescription + "<p>" + Messages.getString("ApplicationHaltsRule_RULE_TEXT_RECOMMENDATION");
        } else {
            shortDescription = Messages.getString("ApplicationHaltsRule_RULE_TEXT_OK");
        }
        if (extraTypesInfo != null) {
            longDescription = longDescription + "<p>" + extraTypesInfo;
        }
        longDescription = shortDescription + "<p>" + longDescription;
        return new Result((IRule)this, score, shortDescription, longDescription);
    }

    private static Comparator<HaltsProvider.ApplicationHaltsInfoHolder> applicationHaltsComparator() {
        return new Comparator<HaltsProvider.ApplicationHaltsInfoHolder>(){

            @Override
            public int compare(HaltsProvider.ApplicationHaltsInfoHolder o1, HaltsProvider.ApplicationHaltsInfoHolder o2) {
                return o1.getTotalHaltsRatio().compareTo((Object)o2.getTotalHaltsRatio());
            }
        };
    }
}

