/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.MethodProfilingDataProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class JavaBlockingRule
implements IRule {
    public static final TypedPreference<String> EXCLUDED_THREADS_REGEXP = new TypedPreference("thread.exclude.regexp", Messages.getString("JavaBlockingRule_CONFIG_EXCLUDED_THREADS"), Messages.getString("JavaBlockingRule_CONFIG_EXCLUDED_THREADS_LONG"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"(.*weblogic\\.socket\\.Muxer.*)");
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(EXCLUDED_THREADS_REGEXP);
    public static final IAggregator<IQuantity, ?> MONITOR_BALANCE_BY_INSTANCE = GroupingAggregator.build((String)Messages.getString("JavaBlockingRule_AGGR_BALANCE_BY_INSTANCE"), null, (IAccessorFactory)JdkAttributes.MONITOR_ADDRESS, (IAggregator)JdkAggregators.TOTAL_BLOCKED_TIME, MethodProfilingDataProvider.topFrameBalanceFunction);
    public static final IAggregator<IQuantity, ?> MONITOR_BALANCE_BY_THREAD = GroupingAggregator.build((String)Messages.getString("JavaBlockingRule_AGGR_BALANCE_BY_THREAD"), null, (IAccessorFactory)JfrAttributes.EVENT_THREAD, (IAggregator)JdkAggregators.TOTAL_BLOCKED_TIME, MethodProfilingDataProvider.topFrameBalanceFunction);
    private static final String RESULT_ID = "JavaBlocking";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        String mostBlockingText;
        double weightedValue;
        String threadExcludeRegexp = (String)valueProvider.getPreferenceValue(EXCLUDED_THREADS_REGEXP);
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)(items = items.apply(ItemFilters.not((IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.EVENT_THREAD_NAME, (String)threadExcludeRegexp)))), (String[])new String[]{"jdk.JavaMonitorEnter"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.JavaMonitorEnter"});
        }
        IQuantity startTime = (IQuantity)items.getAggregate(JdkAggregators.FIRST_ITEM_START);
        IQuantity endTime = (IQuantity)items.getAggregate(JdkAggregators.LAST_ITEM_END);
        IQuantity recordingTime = endTime.subtract(startTime);
        IQuantity byInstance = (IQuantity)items.getAggregate(MONITOR_BALANCE_BY_INSTANCE);
        IQuantity byThread = (IQuantity)items.getAggregate(MONITOR_BALANCE_BY_THREAD);
        if (byInstance == null || byThread == null) {
            return new Result((IRule)this, 0.0, Messages.getString("JavaBlockingRule_TEXT_OK"));
        }
        IQuantity totalWait = (IQuantity)items.getAggregate(Aggregators.sum((String)"jdk.JavaMonitorEnter", (IAttribute)JfrAttributes.DURATION));
        ITypedQuantity waitRatio = UnitLookup.NUMBER_UNITY.quantity(totalWait.ratioTo(recordingTime));
        String excludeText = "";
        double balanceScore = 1.0;
        if (!threadExcludeRegexp.isEmpty()) {
            excludeText = "<p>" + MessageFormat.format(Messages.getString("JavaBlockingRule_TEXT_EXCLUDED_THREADS"), Encode.forHtml((String)threadExcludeRegexp));
        }
        if ((weightedValue = RulesToolkit.mapExp100((double)(waitRatio.doubleValue() * balanceScore), (double)1.0)) < 25.0) {
            String shortMessage = Messages.getString("JavaBlockingRule_TEXT_MESSAGE");
            String longMessage = shortMessage + excludeText;
            return new Result((IRule)this, weightedValue, shortMessage, longMessage);
        }
        if (byThread.compareTo((Object)byInstance) > 0) {
            List groupedByThread = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(ItemFilters.type((String)"jdk.JavaMonitorEnter")), (IAccessorFactory)JfrAttributes.EVENT_THREAD);
            MapToolkit.IntEntry mostBlockedThread = (MapToolkit.IntEntry)groupedByThread.get(groupedByThread.size() - 1);
            IItemCollection mostBlockedThreadOccurences = items.apply(ItemFilters.equals((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, (Object)mostBlockedThread.getKey()));
            IQuantity mostBlockingTime = (IQuantity)mostBlockedThreadOccurences.getAggregate(JdkAggregators.TOTAL_BLOCKED_TIME);
            mostBlockingText = MessageFormat.format(Messages.getString("JavaBlockingRule_TEXT_MOST_BLOCKED_THREAD"), Encode.forHtml((String)((IMCThread)mostBlockedThread.getKey()).getThreadName()), mostBlockedThread.getValue(), Encode.forHtml((String)mostBlockingTime.displayUsing("auto")));
        } else {
            List groupedByClass = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(ItemFilters.type((String)"jdk.JavaMonitorEnter")), (IAccessorFactory)JdkAttributes.MONITOR_CLASS);
            MapToolkit.IntEntry mostBlockingClass = (MapToolkit.IntEntry)groupedByClass.get(groupedByClass.size() - 1);
            IItemCollection mostBlockedClassOccurences = items.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.MONITOR_CLASS, (Object)mostBlockingClass.getKey()));
            IQuantity mostBlockingTime = (IQuantity)mostBlockedClassOccurences.getAggregate(JdkAggregators.TOTAL_BLOCKED_TIME);
            mostBlockingText = MessageFormat.format(Messages.getString("JavaBlockingRule_TEXT_MOST_BLOCKED_CLASS"), Encode.forHtml((String)((IMCType)mostBlockingClass.getKey()).getTypeName()), mostBlockingClass.getValue(), Encode.forHtml((String)mostBlockingTime.displayUsing("auto")));
        }
        String shortMessage = MessageFormat.format(Messages.getString("JavaBlockingRule_TEXT_INFO"), totalWait.displayUsing("auto"));
        String longMessage = shortMessage + " " + mostBlockingText + excludeText;
        return new Result((IRule)this, weightedValue, shortMessage, longMessage);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return JavaBlockingRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("JavaBlocking_RULE_NAME");
    }

    public String getTopic() {
        return "lock_instances";
    }
}

