/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public final class BiasedLockingRevocationPauseRule
implements IRule {
    public static final TypedPreference<IQuantity> INFO_LIMIT = new TypedPreference("vm.biasedrevocationpause.info.limit", Messages.getString("BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT"), Messages.getString("BiasedLockingRevocationPauseRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(100L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(INFO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        String shortMessage;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ExecuteVMOperation"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ExecuteVMOperation"});
        }
        IItemCollection revocationEvents = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.VM_OPERATIONS, ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.OPERATION, (String)"RevokeBias")}));
        if (!revocationEvents.hasItems()) {
            return new Result((IRule)this, 0.0, Messages.getString("BiasedLockingRevocationPauseRule_TEXT_OK"));
        }
        ITypedQuantity timeSpentRevoking = revocationEvents.hasItems() ? (IQuantity)revocationEvents.getAggregate(Aggregators.sum((IAttribute)JfrAttributes.DURATION)) : UnitLookup.MILLISECOND.quantity(0L);
        double mappedDuration = RulesToolkit.mapExp100Y((double)timeSpentRevoking.doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)((IQuantity)valueProvider.getPreferenceValue(INFO_LIMIT)).doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)25.0);
        String longMessage = shortMessage = MessageFormat.format(Messages.getString("BiasedLockingRevocationPauseRule_TEXT_MESSAGE"), timeSpentRevoking.displayUsing("auto"));
        if (mappedDuration >= 25.0) {
            longMessage = longMessage + "<p>" + Messages.getString("BiasedLockingRevocationPauseRule_TEXT_INFO_LONG");
        }
        return new Result((IRule)this, mappedDuration, shortMessage, longMessage);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return BiasedLockingRevocationPauseRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return "biasedLockingRevocationPause";
    }

    public String getName() {
        return Messages.getString("BiasedLockingRevocationPauseRule_RULE_NAME");
    }

    public String getTopic() {
        return "vm_operations";
    }
}

