/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class StackDepthSettingRule
implements IRule {
    private static final int DEFAULT_STACK_DEPTH = 64;
    private static final String STACKDEPTH_SETTING_RESULT_ID = "StackdepthSetting";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        IItemFilter truncatedTracesFilter = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TRUNCATED, (Object)true);
        IQuantity numberOfTruncatedTraces = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)truncatedTracesFilter));
        IQuantity numberOfTraces = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_STACKTRACE)));
        if (numberOfTraces == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("StackdepthSettingRule_TEXT_NA"));
        }
        if (numberOfTruncatedTraces.longValue() > 0L) {
            IItemCollection truncatedTraces = items.apply(truncatedTracesFilter);
            Map<String, Integer> truncatedTraceCounts = this.getTraceCount(truncatedTraces);
            HashSet<String> eventTypes = new HashSet<String>();
            for (IType type : (Set)truncatedTraces.getAggregate(Aggregators.distinct((IAttribute)JfrAttributes.EVENT_TYPE))) {
                eventTypes.add(type.getIdentifier());
            }
            Map<String, Integer> allTraceCounts = this.getTraceCount(items.apply(ItemFilters.type(eventTypes)));
            StringBuilder listBuilder = new StringBuilder();
            for (Map.Entry<String, Integer> entry : truncatedTraceCounts.entrySet()) {
                listBuilder.append("<li>");
                ITypedQuantity percentTruncated = UnitLookup.PERCENT_UNITY.quantity((double)entry.getValue().intValue() / (double)allTraceCounts.get(entry.getKey()).intValue());
                listBuilder.append(MessageFormat.format(Messages.getString("StackdepthSettingRule_TYPE_LIST_TEMPLATE"), Encode.forHtml((String)entry.getKey()), percentTruncated.displayUsing("auto")));
                listBuilder.append("</li>");
            }
            double truncatedTracesRatio = numberOfTruncatedTraces.ratioTo(numberOfTraces);
            String shortMessage = Messages.getString("StackdepthSettingRule_TEXT_INFO");
            String stackDepthValue = (String)RulesToolkit.getFlightRecorderOptions((IItemCollection)items).get("stackdepth");
            String longMessage = shortMessage + "<p>" + MessageFormat.format(Messages.getString("StackdepthSettingRule_TEXT_INFO_LONG"), stackDepthValue == null ? Integer.valueOf(64) : Encode.forHtml((String)stackDepthValue), stackDepthValue == null ? Messages.getString("StackdepthSettingRule_TEXT_INFO_LONG_DEFAULT") + " " : "", UnitLookup.PERCENT_UNITY.quantity(truncatedTracesRatio).displayUsing("auto"), listBuilder.toString());
            return new Result((IRule)this, RulesToolkit.mapExp100Y((double)truncatedTracesRatio, (double)0.01, (double)25.0), shortMessage, longMessage);
        }
        return new Result((IRule)this, 0.0, Messages.getString("StackdepthSettingRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return StackDepthSettingRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private Map<String, Integer> getTraceCount(IItemCollection items) {
        final HashMap map = new HashMap();
        IAggregator build = GroupingAggregator.build((String)"", (String)"", (IAccessorFactory)JfrAttributes.EVENT_TYPE, (IAggregator)Aggregators.count(), (GroupingAggregator.IGroupsFinisher)new GroupingAggregator.IGroupsFinisher<IQuantity, IType<?>, Aggregators.CountConsumer>(){

            public IType<IQuantity> getValueType() {
                return UnitLookup.NUMBER;
            }

            public IQuantity getValue(Iterable<? extends GroupingAggregator.GroupEntry<IType<?>, Aggregators.CountConsumer>> groups) {
                for (GroupingAggregator.GroupEntry<IType<?>, Aggregators.CountConsumer> groupEntry : groups) {
                    Aggregators.CountConsumer consumer = (Aggregators.CountConsumer)groupEntry.getConsumer();
                    IType key = (IType)groupEntry.getKey();
                    map.put(key.getName(), consumer.getCount());
                }
                return null;
            }
        });
        items.getAggregate(build);
        return RulesToolkit.sortMap(map, (boolean)false);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return STACKDEPTH_SETTING_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("StackdepthSettingRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

