/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.JvmInternalsDataProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class DuplicateFlagsRule
implements IRule {
    private static final String RESULT_ID = "DuplicateFlags";

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        Collection<ArrayList<String>> dupes;
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.JVMInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.JVMInformation"});
        }
        IItemCollection jvmInfoItems = items.apply(JdkFilters.VM_INFO);
        Set args = (Set)jvmInfoItems.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.JVM_ARGUMENTS));
        if (args != null && !args.isEmpty() && !(dupes = JvmInternalsDataProvider.checkDuplicates((String)args.iterator().next())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<ul>");
            for (ArrayList<String> dupe : dupes) {
                sb.append("<li>" + Encode.forHtml((String)StringToolkit.join(dupe, (String)", ")) + "</li>");
            }
            sb.append("</ul>");
            String shortDescription = dupes.size() > 1 ? MessageFormat.format(Messages.getString("DuplicateFlagsRuleFactory_TEXT_WARN"), dupes.size()) : Messages.getString("DuplicateFlagsRuleFactory_TEXT_WARN_SINGULAR");
            String longDescription = shortDescription + " " + MessageFormat.format(Messages.getString("DuplicateFlagsRuleFactory_TEXT_WARN_LONG"), sb.toString());
            return new Result((IRule)this, 50.0, shortDescription, longDescription, JdkQueries.VM_INFO);
        }
        return new Result((IRule)this, 0.0, Messages.getString("DuplicateFlagsRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DuplicateFlagsRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DuplicateFlagsRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

