/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.cpu;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ManyRunningProcessesRule
implements IRule {
    private static final String MANY_RUNNING_PROCESSES_RESULT_ID = "ManyRunningProcesses";
    public static final TypedPreference<IQuantity> OTHER_PROCESSES_INFO_LIMIT = new TypedPreference("other.processes.info.limit", Messages.getString("ManyRunningProcessesRule_INFO_LIMIT"), Messages.getString("ManyRunningProcessesRule_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(150L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(OTHER_PROCESSES_INFO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.SystemProcess"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.SystemProcess"});
        }
        List entries = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(JdkFilters.PROCESSES), (IAccessorFactory)JfrAttributes.END_TIME);
        MapToolkit.IntEntry maxNumberProcesses = (MapToolkit.IntEntry)entries.get(entries.size() - 1);
        double score = RulesToolkit.mapExp74((double)maxNumberProcesses.getValue(), (double)((IQuantity)vp.getPreferenceValue(OTHER_PROCESSES_INFO_LIMIT)).clampedFloorIn((IUnit)UnitLookup.NUMBER_UNITY));
        String shortMessage = MessageFormat.format(Messages.getString("ManyRunningProcessesRule_TEXT_INFO"), maxNumberProcesses.getValue(), ((IQuantity)maxNumberProcesses.getKey()).displayUsing("auto"));
        String longMessage = MessageFormat.format(Messages.getString("ManyRunningProcessesRule_TEXT_INFO_LONG"), maxNumberProcesses.getValue(), ((IQuantity)maxNumberProcesses.getKey()).displayUsing("auto"));
        if (score >= 25.0) {
            longMessage = longMessage + " " + Messages.getString("ManyRunningProcessesRule_TEXT_RECOMMENDATION");
        }
        return new Result((IRule)this, score, shortMessage, longMessage);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ManyRunningProcessesRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return MANY_RUNNING_PROCESSES_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ManyRunningProcessesRule_RULE_NAME");
    }

    public String getTopic() {
        return "processes";
    }
}

