/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.cpu;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class HighJvmCpuRule
implements IRule {
    private static final int MAX_SAMPLED_THREADS = 5;
    private static final String RESULT_ID = "HighJvmCpu";
    public static final TypedPreference<IQuantity> MISSING_SAMPLE_LIMIT = new TypedPreference("missing.sample.limit", Messages.getString("HighJvmCpuRule_CONFIG_SAMPLE_LIMIT"), Messages.getString("HighJvmCpuRule_CONFIG_SAMPLE_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    public static final TypedPreference<IQuantity> MINIMUM_CPU_LOAD_PERIOD = new TypedPreference("minimum.cpu.period", Messages.getString("HighJvmCpuRule_CONFIG_MIN_CPULOAD"), Messages.getString("HighJvmCpuRule_CONFIG_MIN_CPU_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(10L));
    public static final TypedPreference<IQuantity> JVM_CPU_INFO_LIMIT = new TypedPreference("jvm.cpu.info.limit", Messages.getString("HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT"), Messages.getString("HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(JVM_CPU_INFO_LIMIT, MINIMUM_CPU_LOAD_PERIOD, MISSING_SAMPLE_LIMIT);
    private static final IAggregator<IQuantity, ?> MAX_ENDTIME = Aggregators.max((String)Messages.getString("HighJvmCpuRule_AGGR_MAX_ENDTIME"), null, (String)"jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    private static final IAggregator<IQuantity, ?> MIN_ENDTIME = Aggregators.min((String)Messages.getString("HighJvmCpuRule_AGGR_MIN_ENDTIME"), null, (String)"jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.CPULoad"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.CPULoad"});
        }
        String periodNotBelow = RulesToolkit.getPeriodIfGreaterThan((IItemCollection)items, (IQuantity)((IQuantity)vp.getPreferenceValue(MINIMUM_CPU_LOAD_PERIOD)), (String[])new String[]{"jdk.CPULoad"});
        if (periodNotBelow != null) {
            return new Result((IRule)this, 50.0, Messages.getString("HighJvmCpuRule_LONG_CPU_LOAD_PERIOD"), MessageFormat.format(Messages.getString("HighJvmCpuRule_LONG_CPU_LOAD_PERIOD_LONG"), periodNotBelow));
        }
        IItemCollection cpuItems = items.apply(JdkFilters.CPU_LOAD);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_USER)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_USER);
        }
        IQuantity jvmUsage = (IQuantity)cpuItems.getAggregate(JdkAggregators.AVG_JVM_USER_CPU);
        IQuantity profilingSamples = (IQuantity)items.getAggregate(JdkAggregators.EXECUTION_SAMPLE_COUNT);
        IQuantity maxPeriodProfiling = RulesToolkit.getSettingMaxPeriod((IItemCollection)items, (String[])new String[]{"jdk.ExecutionSample"});
        if (profilingSamples != null && profilingSamples.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) > 0L && maxPeriodProfiling != null) {
            double missingSampleLimit;
            double jvmVal;
            double maximumSamplesPerSecond = UnitLookup.SECOND.quantity(1L).ratioTo(maxPeriodProfiling) * 5.0;
            IQuantity first = (IQuantity)cpuItems.getAggregate(MIN_ENDTIME);
            IQuantity last = (IQuantity)cpuItems.getAggregate(MAX_ENDTIME);
            double lengthInSeconds = last == null ? 0.0 : last.subtract(first).doubleValueIn((IUnit)UnitLookup.SECOND);
            double samples = profilingSamples.doubleValue();
            double samplesPerSecond = samples / lengthInSeconds;
            double lackingSamplesRatio = 1.0 - samplesPerSecond / maximumSamplesPerSecond;
            double lackingSamplesTimesCpu = lackingSamplesRatio * (jvmVal = jvmUsage.doubleValue());
            if (lackingSamplesTimesCpu >= (missingSampleLimit = ((IQuantity)vp.getPreferenceValue(MISSING_SAMPLE_LIMIT)).doubleValue())) {
                double missingSamplesScore = RulesToolkit.mapExp74((double)lackingSamplesTimesCpu, (double)missingSampleLimit);
                String shortMessage = Messages.getString("HighJvmCpuRule_FEW_SAMPLES");
                String longMessage = shortMessage + " " + Messages.getString("HighJvmCpuRule_FEW_SAMPLES_LONG");
                return new Result((IRule)this, missingSamplesScore, shortMessage, longMessage);
            }
        }
        long infoLimit = ((IQuantity)vp.getPreferenceValue(JVM_CPU_INFO_LIMIT)).longValue();
        double jvmUsageScore = RulesToolkit.mapExp74((double)jvmUsage.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)infoLimit);
        if (jvmUsageScore >= (double)infoLimit) {
            return new Result((IRule)this, jvmUsageScore, Messages.getString("HighJvmCpuRule_TEXT_WARN"));
        }
        return new Result((IRule)this, jvmUsageScore, Messages.getString("HighJvmCpuRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return HighJvmCpuRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HighJvmCpuRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }
}

