/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.memory;

import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.memory.MemoryPoolInformation;
import org.openjdk.jmc.console.ui.tabs.memory.MemoryPoolModel;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.BackgroundFractionDrawer;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class MemoryPoolTableSectionPart
extends MCSectionPart
implements IPersistable {
    private final ColumnManager columnManager;

    public MemoryPoolTableSectionPart(Composite parent, FormToolkit toolkit, MemoryPoolModel poolModel, IMemento state) {
        super(parent, toolkit, Messages.PoolTableSectionPart_SECTION_TEXT);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Table table = toolkit.createTable(body, 66306);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)TreeStructureContentProvider.INSTANCE);
        viewer.setInput((Object)poolModel.getAllPools());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        IColumn nameColumn = new ColumnBuilder(Messages.POOL_NAME_NAME_TEXT, "name", MemoryPoolInformation::getPoolName).build();
        IColumn typeColumn = new ColumnBuilder(Messages.POOL_TYPE_NAME_TEXT, "type", MemoryPoolInformation::getPoolType).build();
        IColumn usedColumn = new ColumnBuilder(Messages.POOL_CUR_USED_NAME_TEXT, "currentUsed", MemoryPoolInformation::getCurUsed).style(131072).build();
        IColumn maxColumn = new ColumnBuilder(Messages.POOL_CUR_MAX_NAME_TEXT, "currentMax", MemoryPoolInformation::getCurMax).style(131072).build();
        IColumn usageColumn = new ColumnBuilder(Messages.POOL_CUR_USAGE_NAME_TEXT, "currentUsage", MemoryPoolInformation::getCurUsage).style(131072).columnDrawer(BackgroundFractionDrawer.unchecked(MemoryPoolInformation::getCurUsage)).build();
        IColumn peakColumn = new ColumnBuilder(Messages.POOL_PEAK_USED_NAME_TEXT, "peakUsed", MemoryPoolInformation::getPeakUsed).style(131072).build();
        IColumn peakMaxColumn = new ColumnBuilder(Messages.POOL_PEAK_MAX_NAME_TEXT, "peakMax", MemoryPoolInformation::getPeakMax).style(131072).build();
        List<IColumn> columns = Arrays.asList(nameColumn, typeColumn, usedColumn, maxColumn, usageColumn, peakColumn, peakMaxColumn);
        this.columnManager = ColumnManager.build((TableViewer)viewer, columns, (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)table));
        poolModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!MemoryPoolTableSectionPart.this.columnManager.getViewer().getControl().isDisposed()) {
                            MemoryPoolTableSectionPart.this.columnManager.getViewer().refresh();
                        }
                    }
                });
            }
        });
    }

    public void saveState(IMemento memento) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)memento));
    }
}

