/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.console.ui.tabs.memory.MemoryPoolInformation;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;

public class MemoryPoolModel
extends Observable {
    private final MemoryPoolInformation[] m_pools;

    public MemoryPoolModel(IConnectionHandle connectionHandle) {
        IMBeanHelperService mbeanHelperService = (IMBeanHelperService)connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        ISubscriptionService subscriptionService = (ISubscriptionService)connectionHandle.getServiceOrDummy(ISubscriptionService.class);
        List<ObjectName> memoryPools = this.findPools(mbeanHelperService);
        this.m_pools = this.setupSubscriptions(memoryPools, mbeanHelperService, subscriptionService);
    }

    public MemoryPoolInformation[] getAllPools() {
        return this.m_pools;
    }

    private MemoryPoolInformation[] setupSubscriptions(List<ObjectName> memoryPools, IMBeanHelperService mbeanHelperService, ISubscriptionService subscriptionService) {
        ArrayList<MemoryPoolInformation> pools = new ArrayList<MemoryPoolInformation>();
        for (ObjectName poolName : memoryPools) {
            pools.add(this.setupSubscription(poolName, mbeanHelperService, subscriptionService));
        }
        return pools.toArray(new MemoryPoolInformation[pools.size()]);
    }

    private MemoryPoolInformation setupSubscription(ObjectName poolName, IMBeanHelperService mbeanHelperService, ISubscriptionService subscriptionService) {
        final MemoryPoolInformation info = new MemoryPoolInformation();
        try {
            info.setPoolName(mbeanHelperService.getAttributeValue(new MRI(MRI.Type.ATTRIBUTE, poolName, "Name")).toString());
            info.setPoolType(mbeanHelperService.getAttributeValue(new MRI(MRI.Type.ATTRIBUTE, poolName, "Type")).toString());
            MRI usageMRI = new MRI(MRI.Type.ATTRIBUTE, poolName, "Usage");
            subscriptionService.addMRIValueListener(usageMRI, new IMRIValueListener(){

                public void valueChanged(MRIValueEvent event) {
                    if (event.getValue() instanceof CompositeData) {
                        MemoryPoolModel.this.updateUsage(info, (CompositeData)event.getValue());
                    }
                }
            });
            this.updateUsage(info, (CompositeData)mbeanHelperService.getAttributeValue(usageMRI));
            MRI peakMRI = new MRI(MRI.Type.ATTRIBUTE, poolName, "PeakUsage");
            subscriptionService.addMRIValueListener(peakMRI, new IMRIValueListener(){

                public void valueChanged(MRIValueEvent event) {
                    if (event.getValue() instanceof CompositeData) {
                        MemoryPoolModel.this.updatePeak(info, (CompositeData)event.getValue());
                    }
                }
            });
            this.updatePeak(info, (CompositeData)mbeanHelperService.getAttributeValue(peakMRI));
        }
        catch (Exception exception) {
            return null;
        }
        return info;
    }

    private void updateUsage(MemoryPoolInformation info, CompositeData value) {
        Long used = (Long)value.get("used");
        Long max = (Long)value.get("max");
        if (used != null && max != null) {
            info.setCurUsed((IQuantity)UnitLookup.BYTE.quantity((Number)used));
            info.setCurMax((IQuantity)(max == -1L ? null : UnitLookup.BYTE.quantity((Number)max)));
            info.setCurUsage((IQuantity)(max == -1L ? null : UnitLookup.PERCENT_UNITY.quantity(used.doubleValue() / max.doubleValue())));
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void updatePeak(MemoryPoolInformation info, CompositeData value) {
        Long used = (Long)value.get("used");
        Long max = (Long)value.get("max");
        if (used != null && max != null) {
            info.setPeakUsed((IQuantity)UnitLookup.BYTE.quantity((Number)used));
            info.setPeakMax((IQuantity)(max == -1L ? null : UnitLookup.BYTE.quantity((Number)max)));
            this.setChanged();
            this.notifyObservers();
        }
    }

    private List<ObjectName> findPools(IMBeanHelperService mbeanHelperService) {
        ArrayList<ObjectName> poolNames = new ArrayList<ObjectName>();
        try {
            for (Map.Entry entry : mbeanHelperService.getMBeanInfos().entrySet()) {
                ObjectName o = (ObjectName)entry.getKey();
                if (!o.getDomain().equals("java.lang") || !o.getKeyProperty("type").equals("MemoryPool")) continue;
                poolNames.add(o);
            }
        }
        catch (IOException iOException) {
            poolNames.clear();
        }
        return poolNames;
    }
}

