/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.base.IHelpScopeProducer;
import org.eclipse.help.base.IScopeHandle;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.scope.IntersectionScope;
import org.eclipse.help.internal.base.scope.ScopeHandle;
import org.eclipse.help.internal.base.scope.UnionScope;
import org.eclipse.help.internal.base.scope.UniversalScope;

public class ScopeRegistry {
    public static final String SCOPE_XP_NAME = "org.eclipse.help.base.scope";
    public static final String ENABLEMENT_SCOPE_ID = "org.eclipse.help.enablement";
    public static final String SEARCH_SCOPE_SCOPE_ID = "org.eclipse.help.searchscope";
    public static final String SCOPE_AND = "^";
    public static final String SCOPE_OR = "|";
    private static List<IScopeHandle> scopes = null;
    private static ScopeRegistry instance;
    private boolean initialized = false;

    private ScopeRegistry() {
    }

    public static ScopeRegistry getInstance() {
        if (instance == null) {
            instance = new ScopeRegistry();
        }
        return instance;
    }

    public AbstractHelpScope getScope(String id) {
        if (id == null) {
            return new UniversalScope();
        }
        this.readScopes();
        for (IScopeHandle handle : scopes) {
            if (!id.equals(handle.getId())) continue;
            return handle.getScope();
        }
        return null;
    }

    private synchronized void readScopes() {
        if (this.initialized) {
            return;
        }
        scopes = new ArrayList<IScopeHandle>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(SCOPE_XP_NAME);
        int i = 0;
        while (i < elements.length) {
            Object obj = null;
            try {
                obj = elements[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                HelpBasePlugin.logError("Create extension failed:[org.eclipse.help.base.scope].", e);
            }
            if (obj instanceof AbstractHelpScope) {
                String id = elements[i].getAttribute("id");
                ScopeHandle filter = new ScopeHandle(id, (AbstractHelpScope)obj);
                scopes.add(filter);
            } else if (obj instanceof IHelpScopeProducer) {
                IScopeHandle[] dynamicScopes = ((IHelpScopeProducer)obj).getScopeHandles();
                Collections.addAll(scopes, dynamicScopes);
            }
            ++i;
        }
        this.initialized = true;
    }

    public IScopeHandle[] getScopes() {
        this.readScopes();
        return scopes.toArray(new IScopeHandle[scopes.size()]);
    }

    public AbstractHelpScope parseScopePhrases(String[] phrases) {
        ArrayList<AbstractHelpScope> scopes = new ArrayList<AbstractHelpScope>();
        int p = 0;
        while (p < phrases.length) {
            AbstractHelpScope scope = this.parseScopePhrase(phrases[p]);
            if (scope != null) {
                scopes.add(scope);
            }
            ++p;
        }
        if (scopes.size() == 0) {
            return null;
        }
        if (scopes.size() == 1) {
            return (AbstractHelpScope)scopes.get(0);
        }
        return new IntersectionScope(scopes.toArray(new AbstractHelpScope[scopes.size()]));
    }

    public AbstractHelpScope parseScopePhrase(String phrase) {
        String elem;
        if (!phrase.startsWith("(") || phrase.startsWith("(")) {
            phrase = String.valueOf('(') + phrase + ')';
        }
        Stack<TempScope> scopeStack = new Stack<TempScope>();
        ScopePhrase scopePhrase = new ScopePhrase(phrase);
        while ((elem = scopePhrase.getNextElement()) != null) {
            TempScope scope;
            if (elem.equals("(")) {
                scope = new TempScope();
                scope.setType(0);
                scopeStack.push(scope);
                continue;
            }
            if (elem.equals(")")) {
                scope = (TempScope)scopeStack.pop();
                if (scopeStack.isEmpty()) {
                    return scope.getScope();
                }
                TempScope parent = (TempScope)scopeStack.peek();
                parent.add(scope.getScope());
                continue;
            }
            if (elem.equals(SCOPE_AND)) {
                scope = (TempScope)scopeStack.peek();
                scope.setType(2);
                continue;
            }
            if (elem.equals(SCOPE_OR)) {
                scope = (TempScope)scopeStack.peek();
                scope.setType(1);
                continue;
            }
            scope = (TempScope)scopeStack.peek();
            AbstractHelpScope helpScope = this.getScope(elem);
            if (helpScope == null) continue;
            scope.add(helpScope);
        }
        return null;
    }

    class ScopePhrase {
        private String phrase;
        private int cursor;

        public ScopePhrase(String phrase) {
            this.phrase = phrase;
            this.cursor = 0;
        }

        public String getNextElement() {
            String next = "";
            while (this.cursor < this.phrase.length()) {
                char current = this.phrase.charAt(this.cursor);
                if (current == '(') {
                    return this.format(next, current);
                }
                if (current == ')') {
                    return this.format(next, current);
                }
                if (String.valueOf(current).equals(ScopeRegistry.SCOPE_AND)) {
                    return this.format(next, current);
                }
                if (String.valueOf(current).equals(ScopeRegistry.SCOPE_OR)) {
                    return this.format(next, current);
                }
                next = String.valueOf(next) + current;
                ++this.cursor;
            }
            if (next.equals("")) {
                return null;
            }
            return next;
        }

        private String format(String next, char current) {
            if (next.equals("")) {
                ++this.cursor;
                return String.valueOf(current);
            }
            return next;
        }
    }

    private class TempScope {
        public static final int SELF = 0;
        public static final int UNION = 1;
        public static final int INTERSECTION = 2;
        private ArrayList<AbstractHelpScope> kids = new ArrayList();
        private int type;

        private TempScope() {
        }

        public void setType(int type) {
            this.type = type;
        }

        public void add(AbstractHelpScope kid) {
            this.kids.add(kid);
        }

        public AbstractHelpScope getScope() {
            switch (this.type) {
                case 1: {
                    return new UnionScope(this.kids.toArray(new AbstractHelpScope[this.kids.size()]));
                }
                case 2: {
                    return new IntersectionScope(this.kids.toArray(new AbstractHelpScope[this.kids.size()]));
                }
            }
            if (this.kids.size() >= 1) {
                return this.kids.get(0);
            }
            return null;
        }
    }
}

