/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.util.Arrays;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.ui.internal.AttributeLabelProvider;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSet;
import org.openjdk.jmc.rjmx.ui.internal.Messages;
import org.openjdk.jmc.rjmx.ui.internal.RemoveAttributeAction;
import org.openjdk.jmc.rjmx.ui.internal.StatisticsCalculator;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.DelegatingLabelProvider;
import org.openjdk.jmc.ui.misc.MCArrayContentProvider;
import org.openjdk.jmc.ui.misc.MementoToolkit;

public class StatisticsTable {
    private final TableViewer viewer;
    private final ColumnManager columnManager;

    public StatisticsTable(Composite parent, AttributeLabelProvider attributeLp, IAttributeSet attributes, boolean addResetAction, IMemento state) {
        IMemberAccessor<MRI, StatisticsCalculator> attributeAccessor = StatisticsCalculator.GET_ATTRIBUTE;
        IColumn name = new ColumnBuilder(Messages.StatisticsTable_ATTRIBUTE_NAME, "attribute", (ColumnLabelProvider)new DelegatingLabelProvider((ColumnLabelProvider)attributeLp, attributeAccessor)).description(Messages.StatisticsTable_ATTRIBUTE_DESCRIPTION).build();
        IColumn last = new ColumnBuilder(Messages.StatisticsTable_VALUE_NAME, "value", StatisticsCalculator.GET_LAST).description(Messages.StatisticsTable_VALUE_DESCRIPTION).style(131072).build();
        IColumn min = new ColumnBuilder(Messages.StatisticsTable_MINIMUM_NAME, "min", StatisticsCalculator.GET_MIN).description(Messages.StatisticsTable_MINIMUM_DESCRIPTION).style(131072).build();
        IColumn max = new ColumnBuilder(Messages.StatisticsTable_MAXIMUM_NAME, "max", StatisticsCalculator.GET_MAX).description(Messages.StatisticsTable_MAXIMUM_DESCRIPTION).style(131072).build();
        IColumn av = new ColumnBuilder(Messages.StatisticsTable_AVERAGE_NAME, "average", StatisticsCalculator.GET_AVERAGE).description(Messages.StatisticsTable_AVERAGE_DESCRIPTION).style(131072).build();
        IColumn sigma = new ColumnBuilder("\u03c3", "sigma", StatisticsCalculator.GET_SIGMA).description(Messages.StatisticsTable_SIGMA_DESCRIPTION).style(131072).build();
        this.viewer = new TableViewer(parent, 268503810);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setContentProvider((IContentProvider)MCArrayContentProvider.INSTANCE);
        this.columnManager = ColumnManager.build((TableViewer)this.viewer, Arrays.asList(name, last, min, max, av, sigma), (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        RemoveAttributeAction removeAction = new RemoveAttributeAction((StructuredViewer)this.viewer, attributes);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.viewer.getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)mm);
        mm.appendToGroup("group.edit", (IAction)removeAction);
        if (addResetAction) {
            SelectionProviderAction clearStatisticsAction = new SelectionProviderAction((ISelectionProvider)this.viewer, Messages.AttributeDialSectionPart_CLEAR_STATISTICS_MENU_TEXT){

                public void run() {
                    for (Object o : this.getStructuredSelection().toList()) {
                        ((StatisticsCalculator)o).reset();
                    }
                    StatisticsTable.this.viewer.refresh();
                }

                public void selectionChanged(IStructuredSelection selection) {
                    this.setEnabled(!selection.isEmpty());
                }
            };
            clearStatisticsAction.setEnabled(false);
            mm.appendToGroup("additions", (IAction)clearStatisticsAction);
        }
        InFocusHandlerActivator.install((Control)this.viewer.getControl(), (IAction)removeAction);
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    public TableViewer getViewer() {
        return this.viewer;
    }
}

