/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.IPersistenceService;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRIService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.internal.AddAttibutesAction;
import org.openjdk.jmc.rjmx.ui.internal.AttributeLabelProvider;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSet;
import org.openjdk.jmc.rjmx.ui.internal.Messages;
import org.openjdk.jmc.rjmx.ui.internal.RemoveAttributeAction;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.MCArrayContentProvider;
import org.openjdk.jmc.ui.misc.MCSectionPart;

public class PersistenceSectionPart
extends MCSectionPart
implements IAttributeSet {
    private final IPersistenceService manager;
    private final IMRIMetadataService mds;
    private final IMRIService attributes;
    private final TableViewer table;

    public PersistenceSectionPart(Composite parent, FormToolkit toolkit, int style, IConnectionHandle connection) {
        super(parent, toolkit, style);
        this.manager = (IPersistenceService)connection.getServiceOrDummy(IPersistenceService.class);
        this.mds = (IMRIMetadataService)connection.getServiceOrDummy(IMRIMetadataService.class);
        this.attributes = (IMRIService)connection.getServiceOrDummy(IMRIService.class);
        Section section = this.getSection();
        section.setText(Messages.ConfigurePersistenceAction_TEXT);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        this.table = new TableViewer(container);
        this.table.setContentProvider((IContentProvider)MCArrayContentProvider.INSTANCE);
        this.table.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(this.mds, this.attributes));
        this.table.setInput((Object)this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.table);
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction(this.mds, this.attributes, this));
        this.getMCToolBarManager().add((IAction)new Action(Messages.ConfigurePersistenceAction_ENABLE, 2){
            {
                this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("persistence-toggle-on-16.gif"));
                this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("persistence-toggle-off-16.gif"));
                this.setToolTipText(Messages.ConfigurePersistenceAction_TOOLTIP_TEXT);
                this.setChecked(PersistenceSectionPart.this.manager.isRunning());
            }

            public void run() {
                if (this.isChecked()) {
                    try {
                        PersistenceSectionPart.this.manager.start();
                    }
                    catch (IOException e1) {
                        RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem activating persistence.", e1);
                    }
                } else {
                    PersistenceSectionPart.this.manager.stop();
                }
            }
        });
        container.setLayout((Layout)new GridLayout());
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        this.table.getControl().setLayoutData((Object)gd2);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.table.getTable());
        RemoveAttributeAction removeAction = new RemoveAttributeAction((StructuredViewer)this.table, this);
        mm.appendToGroup("group.edit", (IAction)removeAction);
        InFocusHandlerActivator.install((Control)this.table.getControl(), (IAction)removeAction);
    }

    public boolean isEmpty() {
        return this.manager.getAttributes().length == 0;
    }

    public MRI[] elements() {
        return this.manager.getAttributes();
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.manager.add(mri);
            ++n2;
        }
        this.table.refresh();
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.manager.remove(mri);
            ++n2;
        }
        this.table.refresh();
    }
}

