/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.celleditors;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;
import org.openjdk.jmc.rjmx.ui.celleditors.Messages;
import org.openjdk.jmc.rjmx.ui.celleditors.UnitCellEditor;

class UpdateIntervalCellEditor
extends UnitCellEditor {
    public UpdateIntervalCellEditor(Composite parent) {
        super(parent);
        this.getProposal().setEnabled(false);
        this.setUnit((IUnit)UnitLookup.MILLISECOND, Integer.class.getName());
    }

    public Control getControl() {
        Object currentValue = super.doGetValue();
        if (currentValue == null || currentValue.equals(-1)) {
            return null;
        }
        return super.getControl();
    }

    @Override
    public void activate() {
        Object currentValue = super.doGetValue();
        if (currentValue == null || currentValue.equals(-1)) {
            this.doSetValue(0);
            this.fireApplyEditorValue();
        } else {
            if (currentValue.equals(0)) {
                this.doSetValue(UpdatePolicyToolkit.getDefaultUpdateInterval());
            }
            this.getProposal().setEnabled(true);
            super.activate();
        }
    }

    public void deactivate() {
        if (this.getProposal() != null) {
            this.getProposal().setEnabled(false);
        }
        super.deactivate();
    }

    @Override
    protected Object doGetValue() {
        return super.doGetValue() == null ? Integer.valueOf(-1) : super.doGetValue();
    }

    @Override
    protected Object parse(String str) throws Exception {
        Integer val = (Integer)super.parse(str);
        if (val <= 0) {
            throw new Exception(Messages.UpdateIntervalCellEditor_INTERVAL_TOO_SMALL);
        }
        return val;
    }
}

