/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class PieChartCanvas
extends Canvas {
    private static final int MARGIN = 10;
    private static final int LINE_WIDTH = 1;
    private static final RGB PIE_OUTILNE_COLOR = new RGB(0, 0, 0);
    private static final RGB PIE_NOT_VALID_COLOR = new RGB(192, 192, 192);
    private static final int START_ANGLE_OFFSET = 90;
    private IColorProvider colorProvider;
    private IMemberAccessor<Object, Object> field;
    private Iterable<?> elements;
    private final Object[] elementAtAngle = new Object[360];
    private boolean clockwise;
    private Point center = new Point(0, 0);
    private int radius;

    public PieChartCanvas(Composite parent) {
        super(parent, 0x20000000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = PieChartCanvas.this.getBounds();
                GC gc = e.gc;
                gc.fillRectangle(bounds);
                PieChartCanvas.this.center = new Point(bounds.width / 2, bounds.height / 2);
                PieChartCanvas.this.radius = Math.min(bounds.width / 2, bounds.height / 2) - 10;
                PieChartCanvas.this.drawDropShadow(gc);
                PieChartCanvas.this.drawPie(gc);
            }
        });
    }

    public <T> void configure(Iterable<? extends T> elements, IMemberAccessor<?, T> field, boolean clockwise) {
        this.field = field;
        this.elements = elements;
        this.clockwise = clockwise;
    }

    private double calculateTotal() {
        double total = 0.0;
        if (this.elements != null && this.field != null) {
            for (Object element : this.elements) {
                Object value = this.field.getMember(element);
                if (!(value instanceof Number)) {
                    return 0.0;
                }
                total += ((Number)value).doubleValue();
            }
        }
        return total;
    }

    public <T> void setColorProvider(IColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    private void drawSlices(GC gc) {
        double total = this.calculateTotal();
        PieSliceRenderer sliceRenderer = new PieSliceRenderer(gc, this.center, this.radius);
        if (total <= 0.0 || this.colorProvider == null) {
            sliceRenderer.addElement(1.0, null);
        } else {
            for (Object element : this.elements) {
                double value = ((Number)this.field.getMember(element)).doubleValue();
                double normalizedShare = value / total;
                sliceRenderer.addElement(normalizedShare, element);
            }
            sliceRenderer.addAccumulatedSlice();
        }
    }

    private void fill(int from, int to, Object value) {
        int i = from;
        while (i < to) {
            this.elementAtAngle[i] = value;
            ++i;
        }
    }

    private static int fractionToAngle(double fraction) {
        return (int)(360.0 * fraction + 0.5);
    }

    private void drawPieSliceFromOffset(GC gc, Point center, int radius, int startAngle, int endAngle) {
        int startWithOffset = (this.clockwise ? -startAngle : startAngle) + 90;
        int endWithOffset = (this.clockwise ? -endAngle : endAngle) + 90;
        PieChartCanvas.drawPieSlice(gc, center.x, center.y, radius, startWithOffset, endWithOffset - startWithOffset);
        if (startAngle > 0 || endAngle < 360) {
            PieChartCanvas.drawPieLine(gc, center.x, center.y, radius, endWithOffset);
        }
    }

    protected static void drawPieSlice(GC gc, int x, int y, int radius, int startAngle, int arcAngle) {
        gc.fillArc(x - radius, y - radius, radius * 2, radius * 2, startAngle, arcAngle);
        gc.drawArc(x - radius, y - radius, radius * 2, radius * 2, startAngle, arcAngle);
    }

    private static void drawPieLine(GC gc, int x, int y, int radius, int startWithOffset) {
        int x1 = (int)((double)radius * Math.cos(Math.toRadians(startWithOffset)));
        int y1 = (int)((double)radius * Math.sin(Math.toRadians(startWithOffset)));
        Color oldColor = gc.getForeground();
        int oldAlpha = gc.getAlpha();
        Color color = new Color(gc.getDevice(), 0, 0, 0);
        gc.setAlpha(96);
        gc.setForeground(color);
        gc.drawLine(x, y, x + x1, y - y1);
        color.dispose();
        gc.setForeground(oldColor);
        gc.setAlpha(oldAlpha);
    }

    private void drawPie(GC gc) {
        Color forground = gc.getForeground();
        Color background = gc.getBackground();
        int linewidth = gc.getLineWidth();
        int antiAlising = gc.getAntialias();
        gc.setBackground(SWTColorToolkit.getColor(PIE_NOT_VALID_COLOR));
        gc.setForeground(SWTColorToolkit.getColor(PIE_OUTILNE_COLOR));
        gc.setLineWidth(1);
        gc.setAntialias(1);
        this.drawSlices(gc);
        gc.setBackground(background);
        gc.setForeground(forground);
        gc.setLineWidth(linewidth);
        gc.setAntialias(antiAlising);
    }

    private void drawDropShadow(GC gc) {
        if (this.radius < 1) {
            return;
        }
        gc.setAntialias(1);
        int r = 0;
        while (r < 8) {
            Color d = new Color(gc.getDevice(), 250 - r * 12, 250 - r * 12, 250 - r * 12);
            gc.setBackground(d);
            gc.fillArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2 + 8 - r, this.radius * 2 + 8 - r, 0, 360);
            d.dispose();
            ++r;
        }
        gc.setAntialias(0);
    }

    public Object getElementAt(int x, int y) {
        if (this.center != null && PieChartCanvas.isInsideCircle(x, y, this.center.x, this.center.y, this.radius)) {
            int angle = (int)(-PieChartCanvas.getMathAngle(this.center.x, -this.center.y, x, -y) + 90.0 + 360.0 + 0.5) % 360;
            return this.elementAtAngle[angle];
        }
        return null;
    }

    private static boolean isInsideCircle(int x, int y, int centerX, int centerY, int radius) {
        return (x - centerX) * (x - centerX) + (y - centerY) * (y - centerY) < radius * radius;
    }

    private static double getMathAngle(int centerX, int centerY, int positionX, int positionY) {
        return Math.toDegrees(Math.atan2(positionY - centerY, positionX - centerX));
    }

    public static class AccumulatedSlice {
        private int count;
        private double size;

        public int getCount() {
            return this.count;
        }

        public double getSize() {
            return this.size;
        }
    }

    private class PieSliceRenderer {
        private final GC gc;
        private final Point center;
        private final int radius;
        private AccumulatedSlice accumulated = new AccumulatedSlice();
        private double currentValue = 0.0;
        private int lastAngle = 0;
        private final Color background;

        public PieSliceRenderer(GC gc, Point center, int radius) {
            this.gc = gc;
            this.center = center;
            this.radius = radius;
            this.background = gc.getBackground();
        }

        private void addElement(double elementSize, Object element) {
            if (elementSize > 0.005) {
                this.addAccumulatedSlice();
                this.addSlice(elementSize, element);
            } else {
                AccumulatedSlice accumulatedSlice = this.accumulated;
                accumulatedSlice.count = accumulatedSlice.count + 1;
                AccumulatedSlice accumulatedSlice2 = this.accumulated;
                accumulatedSlice2.size = accumulatedSlice2.size + elementSize;
            }
        }

        private void addAccumulatedSlice() {
            if (this.addSlice(this.accumulated.size, this.accumulated)) {
                this.accumulated = new AccumulatedSlice();
            }
        }

        private boolean addSlice(double size, Object value) {
            int nextAngle = PieChartCanvas.fractionToAngle(size + this.currentValue);
            if (this.lastAngle < nextAngle) {
                this.currentValue += size;
                Color backgroundColor = PieChartCanvas.this.colorProvider.getBackground(value);
                if (backgroundColor != null) {
                    this.gc.setBackground(backgroundColor);
                } else {
                    this.gc.setBackground(this.background);
                }
                PieChartCanvas.this.drawPieSliceFromOffset(this.gc, this.center, this.radius, this.lastAngle, nextAngle);
                PieChartCanvas.this.fill(this.lastAngle, nextAngle, value);
                this.lastAngle = nextAngle;
                return true;
            }
            return false;
        }
    }
}

