/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene80;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.lucene80.IndexedDISI;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;

final class Lucene80NormsProducer
extends NormsProducer
implements Cloneable {
    private final Map<Integer, NormsEntry> norms;
    private final int maxDoc;
    private IndexInput data;
    private boolean merging;
    private Map<Integer, IndexInput> disiInputs;
    private Map<Integer, RandomAccessInput> disiJumpTables;
    private Map<Integer, RandomAccessInput> dataInputs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene80NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    @Override
    public NormsProducer getMergeInstance() throws IOException {
        Lucene80NormsProducer clone;
        try {
            clone = (Lucene80NormsProducer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.data = this.data.clone();
        clone.disiInputs = new HashMap<Integer, IndexInput>();
        clone.disiJumpTables = new HashMap<Integer, RandomAccessInput>();
        clone.dataInputs = new HashMap<Integer, RandomAccessInput>();
        clone.merging = true;
        return clone;
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name, meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.docsWithFieldOffset = meta.readLong();
            entry.docsWithFieldLength = meta.readLong();
            entry.jumpTableEntryCount = meta.readShort();
            entry.denseRankPower = meta.readByte();
            entry.numDocsWithField = meta.readInt();
            entry.bytesPerNorm = meta.readByte();
            switch (entry.bytesPerNorm) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + entry.bytesPerNorm + ", field: " + info.name, meta);
                }
            }
            entry.normsOffset = meta.readLong();
            this.norms.put(info.number, entry);
            fieldNumber = meta.readInt();
        }
    }

    private RandomAccessInput getDataInput(FieldInfo field, NormsEntry entry) throws IOException {
        RandomAccessInput slice = null;
        if (this.merging) {
            slice = this.dataInputs.get(field.number);
        }
        if (slice == null) {
            slice = this.data.randomAccessSlice(entry.normsOffset, (long)entry.numDocsWithField * (long)entry.bytesPerNorm);
            if (this.merging) {
                this.dataInputs.put(field.number, slice);
            }
        }
        return slice;
    }

    private IndexInput getDisiInput(FieldInfo field, NormsEntry entry) throws IOException {
        IndexInput slice = null;
        if (this.merging) {
            slice = this.disiInputs.get(field.number);
        }
        if (slice == null) {
            slice = IndexedDISI.createBlockSlice(this.data, "docs", entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount);
            if (this.merging) {
                this.disiInputs.put(field.number, slice);
            }
        }
        return slice;
    }

    private RandomAccessInput getDisiJumpTable(FieldInfo field, NormsEntry entry) throws IOException {
        RandomAccessInput jumpTable = null;
        if (this.merging) {
            jumpTable = this.disiJumpTables.get(field.number);
        }
        if (jumpTable == null) {
            jumpTable = IndexedDISI.createJumpTable(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount);
            if (this.merging) {
                this.disiJumpTables.put(field.number, jumpTable);
            }
        }
        return jumpTable;
    }

    @Override
    public NumericDocValues getNorms(FieldInfo field) throws IOException {
        final NormsEntry entry = this.norms.get(field.number);
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.bytesPerNorm == 0) {
                return new DenseNormsIterator(this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return entry.normsOffset;
                    }
                };
            }
            final RandomAccessInput slice = this.getDataInput(field, entry);
            switch (entry.bytesPerNorm) {
                case 1: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice.readByte(this.doc);
                        }
                    };
                }
                case 2: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice.readShort((long)this.doc << 1);
                        }
                    };
                }
                case 4: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice.readInt((long)this.doc << 2);
                        }
                    };
                }
                case 8: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice.readLong((long)this.doc << 3);
                        }
                    };
                }
            }
            throw new AssertionError();
        }
        IndexInput disiInput = this.getDisiInput(field, entry);
        RandomAccessInput disiJumpTable = this.getDisiJumpTable(field, entry);
        IndexedDISI disi = new IndexedDISI(disiInput, disiJumpTable, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        if (entry.bytesPerNorm == 0) {
            return new SparseNormsIterator(disi){

                @Override
                public long longValue() throws IOException {
                    return entry.normsOffset;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.normsOffset, (long)entry.numDocsWithField * (long)entry.bytesPerNorm);
        switch (entry.bytesPerNorm) {
            case 1: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice.readByte(this.disi.index());
                    }
                };
            }
            case 2: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice.readShort((long)this.disi.index() << 1);
                    }
                };
            }
            case 4: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice.readInt((long)this.disi.index() << 2);
                    }
                };
            }
            case 8: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice.readLong((long)this.disi.index() << 3);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public long ramBytesUsed() {
        return 64L * (long)this.norms.size();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    static abstract class DenseNormsIterator
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNormsIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    static class NormsEntry {
        byte denseRankPower;
        byte bytesPerNorm;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        int numDocsWithField;
        long normsOffset;

        NormsEntry() {
        }
    }

    static abstract class SparseNormsIterator
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNormsIterator(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }
}

