/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.commands;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openjdk.jmc.commands.Token;

public final class Tokenizer
implements Iterable<Token> {
    public static final char LINE_SEPARATOR = ';';
    private final Token[] m_tokens;
    private Token m_next;
    private int m_tokenPosition;
    private int m_row;
    private final String m_text;

    public Tokenizer(String text) {
        this.m_text = text;
        List<Token> tokens = this.tokenize(text);
        this.m_tokens = tokens.toArray(new Token[tokens.size()]);
        this.skipForward();
    }

    private List<Token> tokenize(String text) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringCharacterIterator ci = new StringCharacterIterator(text);
        while (ci.current() != '\uffff') {
            this.eatSpace(ci);
            Token token = this.getToken(ci);
            if (token == null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    private Token getToken(CharacterIterator ci) {
        Token token = ci.current() != ';' ? this.createStandardToken(ci) : this.createLineSeparatorToken(ci);
        return token.text.length() != 0 ? token : null;
    }

    private Token createLineSeparatorToken(CharacterIterator ci) {
        Token token = new Token();
        token.row = this.m_row++;
        token.start = ci.getIndex();
        token.text = Character.toString(';');
        ci.next();
        return token;
    }

    private Token createStandardToken(CharacterIterator ci) {
        Token token = new Token();
        token.row = this.m_row;
        token.start = ci.getIndex();
        StringBuilder tokenString = new StringBuilder();
        boolean inQuotation = false;
        while (!this.isTokenBreakCharacter(ci.current(), inQuotation)) {
            if (ci.current() == '\"') {
                token.inQuotes = true;
                inQuotation = !inQuotation;
            }
            tokenString.append(ci.current());
            token.end = ci.getIndex();
            ci.next();
        }
        token.text = Tokenizer.stripOuterQuotations(tokenString.toString());
        return token;
    }

    private boolean isTokenBreakCharacter(char c, boolean inQuotations) {
        if (c == '\uffff') {
            return true;
        }
        if (!inQuotations) {
            return this.isTokenSeparator(c);
        }
        return false;
    }

    private boolean isTokenSeparator(char c) {
        return c == ';' || Character.isWhitespace(c);
    }

    public String getText() {
        return this.m_text;
    }

    public static String stripOuterQuotations(String text) {
        if (text.length() >= 2 && text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private void eatSpace(CharacterIterator ci) {
        while (ci.current() != '\uffff') {
            if (Character.isWhitespace(ci.current())) {
                if (ci.current() == '\r') {
                    ++this.m_row;
                }
                ci.next();
                continue;
            }
            return;
        }
    }

    private void skipForward() {
        if (this.m_tokenPosition < this.m_tokens.length) {
            this.m_next = this.m_tokens[this.m_tokenPosition];
            ++this.m_tokenPosition;
            return;
        }
        this.m_next = null;
    }

    public Token peek() {
        return this.m_next;
    }

    public Token next() {
        Token next = this.m_next;
        this.skipForward();
        return next;
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int n = 0;
        while (n < this.m_tokens.length) {
            builder.append("'");
            builder.append(this.m_tokens[n].text);
            builder.append("'");
            if (n < this.m_tokens.length - 1) {
                builder.append(' ');
            }
            ++n;
        }
        return builder.toString();
    }

    public void setCharacterPosition(int position) {
        this.m_tokenPosition = 0;
        while (this.m_tokenPosition < this.m_tokens.length && position > this.m_tokens[this.m_tokenPosition].end) {
            ++this.m_tokenPosition;
        }
        if (this.m_tokenPosition < this.m_tokens.length) {
            this.m_next = this.m_tokens[this.m_tokenPosition];
            ++this.m_tokenPosition;
        } else {
            this.m_next = null;
        }
    }

    public int getPosition() {
        return this.m_tokenPosition;
    }

    public int getTokenCount() {
        return this.m_tokens.length;
    }

    public static boolean isLineSeparator(Token token) {
        return token.text.equals(String.valueOf(';'));
    }

    @Override
    public Iterator<Token> iterator() {
        return Arrays.asList(this.m_tokens).iterator();
    }
}

