/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeModel;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeObject;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.BackgroundFractionDrawer;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

public class MemoryLeakPage
extends AbstractDataPage {
    private static final IItemFilter TABLE_ITEMS = ItemFilters.type((String)"jdk.OldObjectSample");
    private IRange<IQuantity> visibleRange;

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new MemoryLeakPageUI(parent, toolkit, editor, state);
    }

    public MemoryLeakPage(IPageDefinition definition, StreamModel model, IPageContainer editor) {
        super(definition, model, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    public static class MemoryLeakPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.MemoryLeakPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/objectstatistics.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"memoryleak"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition definition, StreamModel items, IPageContainer editor) {
            return new MemoryLeakPage(definition, items, editor);
        }
    }

    private class MemoryLeakPageUI
    implements IPageUI {
        private static final String OBJECT_FORMATTING_OPTIONS = "objectFormattingOptions";
        private ReferenceTreeModel model;
        private int objectFormattingOptions = 0;
        private final ToDoubleFunction<ReferenceTreeObject> getSelectedFraction = o -> {
            if (this.model == null) {
                return 1.0;
            }
            return (double)o.getItems().size() / (double)this.model.getLeakObjects().size();
        };
        private final IColumn OBJECT_COLUMN = new ColumnBuilder(Messages.MemoryLeakPage_OBJECT_SAMPLE_COLUMN_HEADER, "object", (ColumnLabelProvider)new TypedLabelProvider<ReferenceTreeObject>(ReferenceTreeObject.class){

            protected String getTextTyped(ReferenceTreeObject object) {
                if (object.getReferrerSkip() > 0) {
                    MessageFormat.format(Messages.MemoryLeakPage_STEPS_SKIPPED, object.toString(MemoryLeakPageUI.this.objectFormattingOptions), object.getReferrerSkip());
                }
                return object.toString(MemoryLeakPageUI.this.objectFormattingOptions);
            }

            protected Color getForegroundTyped(ReferenceTreeObject object) {
                if (object.getLeakRelevance() > 0.0) {
                    int red = Math.min((int)(object.getLeakRelevance() * 100.0), 255);
                    return new Color((Device)Display.getCurrent(), new RGB(red, 0, 0));
                }
                return new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
            }
        }).build();
        private final IColumn ADDRESS_COLUMN = new ColumnBuilder(Messages.MemoryLeakPage_ADDRESS_COLUMN_HEADER, "address", (ColumnLabelProvider)new TypedLabelProvider<ReferenceTreeObject>(ReferenceTreeObject.class){

            protected String getTextTyped(ReferenceTreeObject object) {
                return object.getAddress().displayUsing("auto");
            }
        }).build();
        private final IColumn COUNT_COLUMN = new ColumnBuilder(Messages.MemoryLeakPage_COUNT_COLUMN_HEADER, "count", (ColumnLabelProvider)new TypedLabelProvider<ReferenceTreeObject>(ReferenceTreeObject.class){

            protected String getTextTyped(ReferenceTreeObject object) {
                IRange selectionRange = MemoryLeakPageUI.this.chart.getSelectionRange();
                if (selectionRange == null) {
                    return object == null ? "" : Integer.toString(object.getObjectsKeptAliveCount());
                }
                return object == null || selectionRange == null ? "" : Integer.toString(MemoryLeakPageUI.this.model.getLeakCountInRange(selectionRange, object));
            }
        }).style(131072).comparator((o1, o2) -> {
            if (o1 instanceof ReferenceTreeObject && o2 instanceof ReferenceTreeObject) {
                return ((ReferenceTreeObject)o1).getObjectsKeptAliveCount() - ((ReferenceTreeObject)o2).getObjectsKeptAliveCount();
            }
            return -1;
        }).columnDrawer(BackgroundFractionDrawer.unchecked(this.getSelectedFraction)).build();
        private final IColumn RELEVANCE_COLUMN = new ColumnBuilder(Messages.MemoryLeakPage_RELEVANCE_COLUMN_HEADER, "relevance", (ColumnLabelProvider)new TypedLabelProvider<ReferenceTreeObject>(ReferenceTreeObject.class){

            protected String getTextTyped(ReferenceTreeObject object) {
                return Double.toString(object.getLeakRelevance());
            }
        }).build();
        private final IColumn DESCRIPTION_COLUMN = new ColumnBuilder(Messages.MemoryLeakPage_DESCRIPTION_COLUMN_HEADER, "description", (ColumnLabelProvider)new TypedLabelProvider<ReferenceTreeObject>(ReferenceTreeObject.class){

            protected String getTextTyped(ReferenceTreeObject object) {
                if (object == null) {
                    return "";
                }
                if (object.getParent() == null) {
                    return object.getRootDescription();
                }
                return object.getDescription();
            }
        }).build();
        private static final String MAIN_SASH = "mainSash";
        private static final String REFERENCE_TREE = "referenceTree";
        private Form form;
        private TreeViewer aggregatedReferenceTree;
        private Composite chartContainer;
        private ChartCanvas chartCanvas;
        private XYChart chart;
        private SashForm mainSash;
        private ColumnManager referenceTree;

        public MemoryLeakPageUI(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
            this.objectFormattingOptions = StateToolkit.readInt((IState)state, (String)OBJECT_FORMATTING_OPTIONS, (Integer)0);
            this.form = DataPageToolkit.createForm(parent, toolkit, MemoryLeakPage.this.getName(), MemoryLeakPage.this.getImageDescriptor().createImage());
            MemoryLeakPage.this.addResultActions(this.form);
            this.mainSash = new SashForm(this.form.getBody(), 512);
            toolkit.adapt((Composite)this.mainSash);
            this.buildChart(toolkit, editor, (Composite)this.mainSash);
            this.aggregatedReferenceTree = new TreeViewer((Composite)this.mainSash, 2818);
            this.aggregatedReferenceTree.setContentProvider((IContentProvider)new ReferenceTreeContentProvider());
            this.referenceTree = ColumnManager.build((TreeViewer)this.aggregatedReferenceTree, Arrays.asList(this.OBJECT_COLUMN, this.COUNT_COLUMN, this.DESCRIPTION_COLUMN, this.ADDRESS_COLUMN, this.RELEVANCE_COLUMN), (TableSettings)TableSettings.forState((IState)state.getChild(REFERENCE_TREE)));
            this.configureColumnManager(editor, this.referenceTree, null, Messages.MemoryLeakPage_OBJECT_SAMPLES_SELECTION, state.getChild(REFERENCE_TREE), null);
            this.model = ReferenceTreeModel.buildReferenceTree((IItemCollection)MemoryLeakPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            this.model.getLeakCandidates(0.5);
            this.aggregatedReferenceTree.setInput((Object)this.model.getLeakObjects());
            this.chartCanvas.replaceRenderer(this.createChart());
            PersistableSashForm.loadState((SashForm)this.mainSash, (IState)state.getChild(MAIN_SASH));
        }

        private void configureColumnManager(IPageContainer editor, ColumnManager manager, Supplier<IItemCollection> selectionStoreSupplier, String selectionName, IState state, FilterComponent filter) {
            MCContextMenuManager menuManager = MCContextMenuManager.create((Control)manager.getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)manager, (MCContextMenuManager)menuManager);
            if (selectionStoreSupplier != null) {
                SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)manager.getViewer(), editor.getSelectionStore(), selectionStoreSupplier, selectionName, (IContributionManager)menuManager);
            }
            manager.getViewer().addSelectionChangedListener(e -> {
                TreeSelection selection = (TreeSelection)e.getSelection();
                ReferenceTreeObject element = (ReferenceTreeObject)selection.getFirstElement();
                if (element != null) {
                    editor.showSelection(ItemCollectionToolkit.build(element.getItems().stream()));
                }
            });
            this.addObjectFormattingOptions(menuManager);
            if (filter != null) {
                filter.loadState(state);
                menuManager.add(filter.getShowFilterAction());
                menuManager.add(filter.getShowSearchAction());
            }
        }

        private void addObjectFormattingOptions(MCContextMenuManager menuManager) {
            MenuManager displayOptions = new MenuManager(Messages.MemoryLeakPage_OBJECT_FORMATTING_OPTIONS);
            displayOptions.add((IContributionItem)new GroupMarker(OBJECT_FORMATTING_OPTIONS));
            menuManager.appendToGroup("additions", (IContributionItem)displayOptions);
            this.addOption(displayOptions, 1, Messages.MemoryLeakPage_OBJECT_FORMAT_PACKAGE);
            this.addOption(displayOptions, 2, Messages.MemoryLeakPage_OBJECT_FORMAT_FIELD);
            this.addOption(displayOptions, 4, Messages.MemoryLeakPage_OBJECT_FORMAT_STATIC_MOD);
            this.addOption(displayOptions, 8, Messages.MemoryLeakPage_OBJECT_FORMAT_OTHER_MOD);
            this.addOption(displayOptions, 16, Messages.MemoryLeakPage_OBJECT_FORMAT_ARRAY);
        }

        private void addOption(MenuManager displayOptions, int option, String text) {
            IAction formatAction = ActionToolkit.checkAction(b -> this.setDisplayOption(option), (String)text, null);
            formatAction.setChecked((this.objectFormattingOptions & option) != 0);
            displayOptions.appendToGroup(OBJECT_FORMATTING_OPTIONS, formatAction);
        }

        private void setDisplayOption(int option) {
            this.objectFormattingOptions ^= option;
            this.aggregatedReferenceTree.refresh();
        }

        private void buildChart(FormToolkit toolkit, IPageContainer editor, Composite parent) {
            this.chartContainer = toolkit.createComposite(parent);
            this.chartContainer.setLayout((Layout)new GridLayout(2, false));
            this.chartCanvas = new ChartCanvas(this.chartContainer);
            this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
            DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
            this.chart = new XYChart(editor.getRecordingRange(), RendererToolkit.empty(), 180);
            DataPageToolkit.setChart(this.chartCanvas, this.chart, (IAttribute<IQuantity>)JdkAttributes.ALLOCATION_TIME, i -> {
                if (this.aggregatedReferenceTree != null && this.model != null) {
                    IRange selectionRange = this.chart.getSelectionRange();
                    if (selectionRange != null) {
                        ((ReferenceTreeContentProvider)this.aggregatedReferenceTree.getContentProvider()).timeRange = selectionRange;
                        this.aggregatedReferenceTree.setInput((Object)this.model.getLeakObjects(selectionRange));
                    } else {
                        ((ReferenceTreeContentProvider)this.aggregatedReferenceTree.getContentProvider()).timeRange = null;
                        this.aggregatedReferenceTree.setInput((Object)this.model.getRootObjects());
                    }
                }
            });
            this.chart.setVisibleRange((IQuantity)MemoryLeakPage.this.visibleRange.getStart(), (IQuantity)MemoryLeakPage.this.visibleRange.getEnd());
        }

        private IXDataRenderer createChart() {
            ArrayList<ItemRow> rows = new ArrayList<ItemRow>();
            IItemCollection items = MemoryLeakPage.this.getDataSource().getItems().apply(TABLE_ITEMS);
            rows.add(DataPageToolkit.buildTimestampHistogram(Messages.HeapPage_ROW_ALLOCATION, JdkAggregators.ALLOCATION_TOTAL.getDescription(), items, Aggregators.count((IItemFilter)TABLE_ITEMS), (IAttribute<IQuantity>)JdkAttributes.ALLOCATION_TIME, DataPageToolkit.ALLOCATION_COLOR));
            IXDataRenderer root = RendererToolkit.uniformRows(rows);
            return new ItemRow(root, items);
        }

        public void saveTo(IWritableState state) {
            this.referenceTree.getSettings().saveState(state.createChild(REFERENCE_TREE));
            PersistableSashForm.saveState((SashForm)this.mainSash, (IWritableState)state.createChild(MAIN_SASH));
            StateToolkit.writeInt((IWritableState)state, (String)OBJECT_FORMATTING_OPTIONS, (Integer)this.objectFormattingOptions);
            this.saveToLocal();
        }

        private void saveToLocal() {
            MemoryLeakPage.this.visibleRange = this.chart.getVisibleRange();
        }
    }

    private static class ReferenceTreeContentProvider
    extends AbstractStructuredContentProvider
    implements ITreeContentProvider {
        IRange<IQuantity> timeRange = null;
        private final Predicate<ReferenceTreeObject> withinTimeRangePredicateFromRootObject = rto -> {
            if (this.timeRange != null) {
                if (rto.getTimestamp().compareTo((Object)((IQuantity)this.timeRange.getStart())) >= 0 && rto.getTimestamp().compareTo((Object)((IQuantity)this.timeRange.getEnd())) <= 0) {
                    return true;
                }
                if (rto.getRootObject().getOldObjectSamples() != null && rto.getRootObject().getOldObjectSamples().size() > 1) {
                    for (Map.Entry rt : rto.getRootObject().getOldObjectSamples().entrySet()) {
                        if (((IQuantity)rt.getKey()).compareTo((Object)((IQuantity)this.timeRange.getStart())) < 0 || ((IQuantity)rt.getKey()).compareTo((Object)((IQuantity)this.timeRange.getEnd())) > 0) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        };
        private final Predicate<ReferenceTreeObject> withinTimeRangePredicate = rto -> {
            if (this.timeRange != null) {
                return rto.getTimestamp().compareTo((Object)((IQuantity)this.timeRange.getStart())) >= 0 && rto.getTimestamp().compareTo((Object)((IQuantity)this.timeRange.getEnd())) <= 0;
            }
            return true;
        };

        private ReferenceTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ReferenceTreeObject) {
                ReferenceTreeObject object = (ReferenceTreeObject)element;
                List children = object.getChildren();
                if (this.timeRange != null) {
                    return children.stream().anyMatch(this.withinTimeRangePredicateFromRootObject);
                }
                return !children.isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof ReferenceTreeObject) {
                return ((ReferenceTreeObject)element).getParent();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection collection = (Collection)inputElement;
                if (this.timeRange != null) {
                    return collection.stream().filter(this.withinTimeRangePredicateFromRootObject).toArray();
                }
                return collection.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ReferenceTreeObject) {
                ReferenceTreeObject object = (ReferenceTreeObject)element;
                List children = object.getChildren();
                if (this.timeRange != null) {
                    if (children.size() > 1) {
                        return children.stream().filter(this.withinTimeRangePredicate).toArray();
                    }
                    return children.stream().filter(this.withinTimeRangePredicateFromRootObject).toArray();
                }
                return children.toArray();
            }
            return new Object[0];
        }
    }
}

