/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.ObjectStatisticsDataProvider;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.ItemIterableToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYDataRenderer;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;

public class HeapPage
extends AbstractDataPage {
    private static final IItemFilter TABLE_ITEMS = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.OBJECT_COUNT, JdkFilters.ALLOC_ALL});
    private static final String INSTANCES_COL = "instances";
    private static final String SIZE_COL = "size";
    private static final String INCREASE_COL = "increase";
    private static final String ALLOCATION_COL = "allocation";
    private static final String INSIDE_TLAB_COL = "insideTlabSize";
    private static final String OUTSIDE_TLAB_COL = "outsideTlabSize";
    private static final String GC_PAUSE_ID = "gcPause";
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private IRange<IQuantity> visibleRange;
    private IItemFilter tableFilter;
    private ColumnManager.SelectionState histogramState;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addColumn(INSTANCES_COL, JdkAggregators.OBJECT_COUNT_MAX_INSTANCES);
        HISTOGRAM.addColumn(SIZE_COL, JdkAggregators.OBJECT_COUNT_MAX_SIZE);
        HISTOGRAM.addColumn(INCREASE_COL, ObjectStatisticsDataProvider.getIncreaseAggregator());
        HISTOGRAM.addColumn(ALLOCATION_COL, JdkAggregators.ALLOCATION_TOTAL);
        HISTOGRAM.addColumn(INSIDE_TLAB_COL, JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
        HISTOGRAM.addColumn(OUTSIDE_TLAB_COL, JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings(SIZE_COL, Arrays.asList(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(500), null), new TableSettings.ColumnSettings(INSTANCES_COL, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(SIZE_COL, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(INCREASE_COL, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(ALLOCATION_COL, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false))));
        }
        return new TableSettings(state);
    }

    private static String classCount(int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return " (" + Messages.HeapPage_SELECTED_CLASS + ")";
            }
        }
        return " (" + NLS.bind((String)Messages.HeapPage_SELECTED_CLASSES, (Object)count) + ")";
    }

    public HeapPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.visibleRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{TABLE_ITEMS, JdkFilters.HEAP_SUMMARY});
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new ObjectStatisticsUi(parent, toolkit, pageContainer, state);
    }

    public static class HeapPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.HeapPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/objectstatistics.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"heap"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new HeapPage(dpd, items, editor);
        }
    }

    private static class ObjectCountLane {
        private final XYDataRenderer renderer = new XYDataRenderer((IQuantity)UnitLookup.MEMORY.getDefaultUnit().quantity(0L));
        private final boolean plot;

        ObjectCountLane(boolean plot) {
            this.plot = plot;
        }

        private Optional<Object> addClass(Object klass, IItemCollection items) {
            return ItemCollectionToolkit.join(items, "jdk.ObjectCount").map(ocItems -> this.addClass(klass, (IItemIterable)ocItems));
        }

        private Object addClass(Object klass, IItemIterable ocItems) {
            Iterator sorted = ItemIterableToolkit.sorted(ocItems, JfrAttributes.END_TIME, Comparator.naturalOrder()).iterator();
            IQuantitySeries<?> qs = DataPageToolkit.buildQuantitySeries(sorted, (IType<IItem>)ocItems.getType(), (IAttribute<IQuantity>)JfrAttributes.END_TIME, (IAttribute<IQuantity>)JdkAttributes.HEAP_TOTAL);
            String text = NLS.bind((String)Messages.HeapPage_LIVE_SIZE_OF_CLASS, (Object)klass);
            if (this.plot) {
                this.renderer.addPlotChart(text, qs, ColorToolkit.getDistinguishableColor((Object)klass), true);
            } else {
                this.renderer.addLineChart(text, qs, ColorToolkit.getDistinguishableColor((Object)klass), false);
            }
            return klass;
        }

        static /* synthetic */ Optional access$0(ObjectCountLane objectCountLane, Object object, IItemCollection iItemCollection) {
            return objectCountLane.addClass(object, iItemCollection);
        }
    }

    private class ObjectStatisticsUi
    extends ChartAndTableUI {
        private static final String HEAP_FILTER = "heapFilter";
        private IAction gcPauseAction;
        private IAction sizeAction;
        private IAction allocationAction;

        ObjectStatisticsUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            super(TABLE_ITEMS, HeapPage.this.getDataSource(), parent, toolkit, pageContainer, state, HeapPage.this.getName(), HeapPage.this.tableFilter, HeapPage.this.getIcon(), HeapPage.this.flavorSelectorState);
            this.tableFilterComponent.loadState(state.getChild(HEAP_FILTER));
            HeapPage.this.addResultActions(this.form);
            this.chart.setVisibleRange((IQuantity)HeapPage.this.visibleRange.getStart(), (IQuantity)HeapPage.this.visibleRange.getEnd());
            this.chart.addVisibleRangeListener(r -> {
                IRange iRange = r;
                IRange iRange2 = iRange;
                HeapPage.this.visibleRange = iRange;
            });
            this.table.getManager().setSelectionState(HeapPage.this.histogramState);
        }

        @Override
        public void saveTo(IWritableState writableState) {
            super.saveTo(writableState);
            this.tableFilterComponent.saveState(writableState.createChild(HEAP_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            HeapPage.this.histogramState = this.table.getManager().getSelectionState();
            HeapPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        @Override
        protected ItemHistogram buildHistogram(Composite parent, IState state) {
            return HISTOGRAM.buildWithoutBorder(parent, JdkAttributes.OBJECT_CLASS, HeapPage.getTableSettings(state));
        }

        @Override
        protected IXDataRenderer getChartRenderer(IItemCollection itemsInTable, ItemHistogram.HistogramSelection selection) {
            Stream<IAttribute<IQuantity>> msAttributes;
            IItemCollection memorySummaryEvents;
            Stream<IAttribute<IQuantity>> hsAttributes;
            IItemCollection selectedItems;
            ArrayList<ItemRow> rows = new ArrayList<ItemRow>();
            IItemCollection allItems = HeapPage.this.getDataSource().getItems();
            String classCount = HeapPage.classCount(selection.getRowCount());
            IItemCollection iItemCollection = selectedItems = selection.getRowCount() == 0 ? itemsInTable : selection.getItems();
            if (this.allocationAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(String.valueOf(Messages.HeapPage_ROW_ALLOCATION) + classCount, JdkAggregators.ALLOCATION_TOTAL.getDescription(), selectedItems.apply(JdkFilters.ALLOC_ALL), JdkAggregators.ALLOCATION_TOTAL, DataPageToolkit.ALLOCATION_COLOR));
            }
            XYDataRenderer heapRenderer = new XYDataRenderer((IQuantity)UnitLookup.MEMORY.getDefaultUnit().quantity(0L), Messages.HeapPage_ROW_MEMORY_USAGE, Messages.HeapPage_ROW_MEMORY_USAGE_DESC);
            IItemCollection allEvents = null;
            IItemCollection heapSummaryEvents = allItems.apply(JdkQueries.HEAP_SUMMARY.getFilter());
            if (DataPageToolkit.addEndTimeLines(heapRenderer, heapSummaryEvents, false, hsAttributes = DataPageToolkit.getQuantityAttributes(JdkQueries.HEAP_SUMMARY).filter(this::isAttributeEnabled))) {
                allEvents = heapSummaryEvents;
            }
            if (DataPageToolkit.addEndTimeLines(heapRenderer, memorySummaryEvents = allItems.apply(JdkQueries.OS_MEMORY_SUMMARY.getFilter()), false, msAttributes = DataPageToolkit.getQuantityAttributes(JdkQueries.OS_MEMORY_SUMMARY).filter(this::isAttributeEnabled))) {
                IItemCollection iItemCollection2 = allEvents = allEvents == null ? memorySummaryEvents : ItemCollectionToolkit.merge(() -> Stream.of(heapSummaryEvents, memorySummaryEvents));
            }
            if (allEvents != null) {
                rows.add(new ItemRow(Messages.HeapPage_ROW_MEMORY_USAGE, Messages.HeapPage_ROW_MEMORY_USAGE_DESC, (IXDataRenderer)heapRenderer, allEvents));
            }
            if (this.sizeAction.isChecked()) {
                boolean noSelection = selection.getRowCount() == 0;
                ItemHistogram.HistogramSelection selectedOrAll = noSelection ? this.table.getAllRows() : selection;
                ObjectCountLane ocLane = new ObjectCountLane(noSelection);
                long noClasses = selectedOrAll.getSelectedRows((arg_0, arg_1) -> ObjectCountLane.access$0(ocLane, arg_0, arg_1)).filter(Optional::isPresent).count();
                if (noClasses > 0L) {
                    rows.add(new ItemRow(String.valueOf(Messages.HeapPage_ROW_LIVE_SIZE) + HeapPage.classCount((int)noClasses), Messages.HeapPage_ROW_LIVE_SIZE_DESC, (IXDataRenderer)ocLane.renderer, selectedItems.apply(JdkFilters.OBJECT_COUNT)));
                }
            }
            IXDataRenderer rr = RendererToolkit.uniformRows(rows);
            IXDataRenderer root = this.gcPauseAction.isChecked() ? RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{rr, DataPageToolkit.buildGcPauseRow(allItems)}) : rr;
            return new ItemRow(root, selectedItems.apply(JdkFilters.ALLOC_ALL));
        }

        @Override
        protected void onFilterChange(IItemFilter filter) {
            super.onFilterChange(filter);
            HeapPage.this.tableFilter = filter;
        }

        @Override
        protected List<IAction> initializeChartConfiguration(IState state) {
            this.gcPauseAction = DataPageToolkit.createCheckAction(Messages.HeapPage_OVERLAY_GC, Messages.HeapPage_OVERLAY_GC_DESC, HeapPage.GC_PAUSE_ID, DataPageToolkit.GC_LEGEND_ICON, b -> this.buildChart());
            this.sizeAction = DataPageToolkit.createCheckAction(Messages.HeapPage_ROW_LIVE_SIZE, Messages.HeapPage_ROW_LIVE_SIZE_DESC, HeapPage.SIZE_COL, FlightRecorderUI.getDefault().getMCImageDescriptor("pages/objectstatistics.png"), b -> this.buildChart());
            this.allocationAction = DataPageToolkit.createAggregatorCheckAction(JdkAggregators.ALLOCATION_TOTAL, HeapPage.ALLOCATION_COL, DataPageToolkit.ALLOCATION_COLOR, b -> this.buildChart());
            Stream<IAction> attributeActions = Stream.concat(JdkQueries.HEAP_SUMMARY.getAttributes().stream(), JdkQueries.OS_MEMORY_SUMMARY.getAttributes().stream()).map(a -> DataPageToolkit.createAttributeCheckAction(a, b -> this.buildChart()));
            return Stream.concat(Stream.concat(Stream.of(this.gcPauseAction, this.allocationAction), attributeActions), Stream.of(this.sizeAction)).collect(Collectors.toList());
        }
    }
}

