/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.CompositeKeyAccessorFactory;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogramWithInput;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.QuantitySeries;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.charts.XYDataRenderer;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class ExceptionsPage
extends AbstractDataPage {
    private static final String SASH_ELEMENT = "sash";
    private static final String LIST_ELEMENT = "eventList";
    private static final String EXCEPTIONS_TABLE = "exceptionsTable";
    private static final String SECONDARY_EXCEPTIONS_TABLE = "secondaryExceptionsTable";
    private static final String HISTGRAM_TYPE = "histogramType";
    private static final Color STATISTICS_EVENT_COLOR = TypeLabelProvider.getColorOrDefault("jdk.ExceptionStatistics");
    private static final Color EXCEPTIONS_EVENT_COLOR = TypeLabelProvider.getColorOrDefault("jdk.JavaExceptionThrow");
    private static final Color ERRORS_EVENT_COLOR = TypeLabelProvider.getColorOrDefault("jdk.JavaErrorThrow");
    private static final IAccessorFactory<IDisplayable> CLASS_AND_MESSAGE_AF = CompositeKeyAccessorFactory.displayable(" : ", new IAccessorFactory[]{JdkAttributes.EXCEPTION_THROWNCLASS, JdkAttributes.EXCEPTION_MESSAGE});
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemList.ItemListBuilder LIST = new ItemList.ItemListBuilder();
    private Map<HistogramType, ColumnManager.SelectionState> primaryTableSelection;
    private Map<HistogramType, ColumnManager.SelectionState> secondaryTableSelection;
    private ColumnManager.SelectionState eventListSelection;
    private Map<HistogramType, IItemFilter> primaryTableFilter;
    private Map<HistogramType, IItemFilter> secondaryTableFilter;
    private IItemFilter eventListFilter;
    private IRange<IQuantity> timelineRange;
    private int tabFolderIndex = 0;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addCountColumn();
        LIST.addColumn(JfrAttributes.START_TIME);
        LIST.addColumn(JdkAttributes.EXCEPTION_THROWNCLASS);
        LIST.addColumn(JfrAttributes.EVENT_THREAD);
        LIST.addColumn(JdkAttributes.EXCEPTION_MESSAGE);
        LIST.addColumn(JfrAttributes.END_TIME);
        LIST.addColumn(JfrAttributes.EVENT_TYPE);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new ExceptionsUi(parent, toolkit, pageContainer, state);
    }

    public ExceptionsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
        this.primaryTableSelection = new HashMap<HistogramType, ColumnManager.SelectionState>();
        this.secondaryTableSelection = new HashMap<HistogramType, ColumnManager.SelectionState>();
        this.primaryTableFilter = new HashMap<HistogramType, IItemFilter>();
        this.secondaryTableFilter = new HashMap<HistogramType, IItemFilter>();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.THROWABLES;
    }

    public static class ExceptionsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ExceptionsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/exceptions.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"exceptions"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ExceptionsPage(dpd, items, editor);
        }
    }

    private class ExceptionsUi
    implements IPageUI {
        private static final String EVENTS_FILTER = "eventFilter";
        private static final String PRIMARY_FILTER = "primaryFilter";
        private static final String SECONDARY_FILTER = "secondaryFilter";
        private final IPageContainer pageContainer;
        private final ChartCanvas exceptionChartCanvas;
        private final ItemList eventList;
        private final SashForm sash;
        private final Composite histogramParent;
        private ItemHistogram primaryHistogram;
        private FilterComponent primaryFilter;
        private FilterComponent secondaryFilter;
        private FilterComponent eventFilter;
        private ItemHistogram secondaryHistogram;
        private Supplier<TableSettings> secondaryHistogramSettings;
        private Consumer<IItemCollection> itemConsumerRoot;
        private HistogramType histogramType;
        private XYChart exceptionsChart;
        private IItemCollection selectionItems;
        private IRange<IQuantity> currentRange;
        private CTabFolder tabFolder;
        private FlavorSelector flavorSelector;

        ExceptionsUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, ExceptionsPage.this.getName(), ExceptionsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            this.histogramParent = toolkit.createComposite((Composite)this.sash);
            this.histogramParent.setLayout((Layout)new FillLayout(512));
            this.histogramType = (HistogramType)StateToolkit.readEnum((IState)state, (String)ExceptionsPage.HISTGRAM_TYPE, (Enum)HistogramType.CLASS, HistogramType.class);
            this.buildHistograms(TableSettings.forState((IState)state.getChild(ExceptionsPage.EXCEPTIONS_TABLE)), TableSettings.forState((IState)state.getChild(ExceptionsPage.SECONDARY_EXCEPTIONS_TABLE)));
            this.tabFolder = new CTabFolder((Composite)this.sash, 0);
            toolkit.adapt((Composite)this.tabFolder);
            CTabItem t1 = new CTabItem(this.tabFolder, 0);
            this.exceptionChartCanvas = new ChartCanvas((Composite)this.tabFolder);
            DataPageToolkit.createChartTimestampTooltip(this.exceptionChartCanvas);
            t1.setText(Messages.PAGES_TIMELINE);
            t1.setControl((Control)this.exceptionChartCanvas);
            this.tabFolder.setSelection(ExceptionsPage.this.tabFolderIndex);
            this.exceptionsChart = this.createExceptionsChart(pageContainer);
            this.hookUpExceptionsChart();
            CTabItem t2 = new CTabItem(this.tabFolder, 0);
            this.eventList = LIST.buildWithoutBorder((Composite)this.tabFolder, TableSettings.forState((IState)state.getChild(ExceptionsPage.LIST_ELEMENT)));
            MCContextMenuManager eventListMm = MCContextMenuManager.create((Control)this.eventList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.eventList.getManager(), (MCContextMenuManager)eventListMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.eventList, Messages.ExceptionsPage_THROWABLES_LOG_SELECTION, (IContributionManager)eventListMm);
            this.eventList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.eventList.getSelection().get())));
            t2.setText(Messages.PAGES_EVENT_LOG);
            this.eventFilter = FilterComponent.createFilterComponent(this.eventList, ExceptionsPage.this.eventListFilter, ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES), pageContainer.getSelectionStore()::getSelections, this::onEventFilterChange);
            eventListMm.add(this.eventFilter.getShowFilterAction());
            eventListMm.add(this.eventFilter.getShowSearchAction());
            t2.setControl((Control)this.eventFilter.getComponent());
            this.eventFilter.loadState(state.getChild(EVENTS_FILTER));
            this.onEventFilterChange(ExceptionsPage.this.eventListFilter);
            this.eventList.getManager().setSelectionState(ExceptionsPage.this.eventListSelection);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(ExceptionsPage.SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkFilters.THROWABLES, ExceptionsPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, ExceptionsPage.this.flavorSelectorState);
            form.getToolBarManager().appendToGroup("pageSetup", this.buildHistogramTypeAction(HistogramType.CLASS, Messages.ExceptionsPage_GROUP_BY_CLASS_ACTION, FlightRecorderUI.getDefault().getMCImageDescriptor("exceptions_by_class.png")));
            form.getToolBarManager().appendToGroup("pageSetup", this.buildHistogramTypeAction(HistogramType.MESSAGE, Messages.ExceptionsPage_GROUP_BY_MESSAGE_ACTION, FlightRecorderUI.getDefault().getMCImageDescriptor("exceptions_by_message.png")));
            form.getToolBarManager().appendToGroup("pageSetup", this.buildHistogramTypeAction(HistogramType.CLASS_AND_MESSAGE, Messages.ExceptionsPage_GROUP_BY_CLASS_AND_MESSAGE_ACTION, FlightRecorderUI.getDefault().getMCImageDescriptor("exceptions_by_class_and_message.png")));
            ExceptionsPage.this.addResultActions(form);
            form.getToolBarManager().update(true);
        }

        private XYChart createExceptionsChart(IPageContainer pageContainer) {
            XYChart chart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 100);
            chart.setVisibleRange((IQuantity)ExceptionsPage.this.timelineRange.getStart(), (IQuantity)ExceptionsPage.this.timelineRange.getEnd());
            chart.addVisibleRangeListener(r -> {
                IRange iRange = r;
                IRange iRange2 = iRange;
                ExceptionsPage.this.timelineRange = iRange;
            });
            return chart;
        }

        private IAction buildHistogramTypeAction(HistogramType histogramType, String text, ImageDescriptor icon) {
            IAction a = ActionToolkit.radioAction(() -> this.setHistogramType(histogramType), (String)text, (ImageDescriptor)icon);
            a.setChecked(histogramType == this.histogramType);
            return a;
        }

        private void setHistogramType(HistogramType histogramType) {
            if (histogramType != this.histogramType) {
                ExceptionsPage.this.primaryTableSelection.put(this.histogramType, this.primaryHistogram.getManager().getSelectionState());
                if (this.secondaryHistogram != null) {
                    ExceptionsPage.this.secondaryTableSelection.put(this.histogramType, this.secondaryHistogram.getManager().getSelectionState());
                }
                this.histogramType = histogramType;
                TableSettings primarySettings = this.primaryHistogram.getManager().getSettings();
                TableSettings secondarySettings = this.secondaryHistogramSettings.get();
                Control[] controlArray = this.histogramParent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                this.buildHistograms(primarySettings, secondarySettings);
                this.refreshPageItems();
            }
        }

        private void buildHistograms(TableSettings primarySettings, TableSettings secondarySettings) {
            if (this.histogramType == HistogramType.CLASS_AND_MESSAGE) {
                this.primaryHistogram = HISTOGRAM.buildWithoutBorder(this.histogramParent, Messages.ExceptionsPage_CLASS_AND_MESSAGE, UnitLookup.UNKNOWN, CLASS_AND_MESSAGE_AF, primarySettings);
                this.primaryFilter = FilterComponent.createFilterComponent(this.primaryHistogram, (IItemFilter)ExceptionsPage.this.primaryTableFilter.get((Object)this.histogramType), ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES), this.pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
                this.secondaryHistogram = null;
                this.secondaryHistogramSettings = () -> secondarySettings;
                this.secondaryFilter = null;
                this.onFilterChange((IItemFilter)ExceptionsPage.this.primaryTableFilter.get((Object)this.histogramType));
                this.primaryHistogram.getManager().setSelectionState((ColumnManager.SelectionState)ExceptionsPage.this.primaryTableSelection.get((Object)this.histogramType));
                this.itemConsumerRoot = ItemHistogramWithInput.chain(this.primaryHistogram, this::updateChartAndListDetails, new ItemHistogram[0]);
            } else {
                SashForm s2 = new SashForm(this.histogramParent, 512);
                IAttribute masterAttr = this.histogramType == HistogramType.CLASS ? JdkAttributes.EXCEPTION_THROWNCLASS : JdkAttributes.EXCEPTION_MESSAGE;
                IAttribute slaveAttr = this.histogramType == HistogramType.CLASS ? JdkAttributes.EXCEPTION_MESSAGE : JdkAttributes.EXCEPTION_THROWNCLASS;
                this.primaryHistogram = HISTOGRAM.buildWithoutBorder((Composite)s2, masterAttr, primarySettings);
                this.primaryFilter = FilterComponent.createFilterComponent(this.primaryHistogram, (IItemFilter)ExceptionsPage.this.primaryTableFilter.get((Object)this.histogramType), ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES), this.pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
                this.secondaryHistogram = HISTOGRAM.buildWithoutBorder((Composite)s2, slaveAttr, secondarySettings);
                this.secondaryFilter = FilterComponent.createFilterComponent(this.secondaryHistogram, (IItemFilter)ExceptionsPage.this.secondaryTableFilter.get((Object)this.histogramType), ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES), this.pageContainer.getSelectionStore()::getSelections, this::onSecondaryFilterChange);
                this.secondaryHistogramSettings = () -> ((ColumnManager)this.secondaryHistogram.getManager()).getSettings();
                this.onFilterChange((IItemFilter)ExceptionsPage.this.primaryTableFilter.get((Object)this.histogramType));
                this.primaryHistogram.getManager().setSelectionState((ColumnManager.SelectionState)ExceptionsPage.this.primaryTableSelection.get((Object)this.histogramType));
                this.onSecondaryFilterChange((IItemFilter)ExceptionsPage.this.secondaryTableFilter.get((Object)this.histogramType));
                this.secondaryHistogram.getManager().setSelectionState((ColumnManager.SelectionState)ExceptionsPage.this.secondaryTableSelection.get((Object)this.histogramType));
                this.itemConsumerRoot = ItemHistogramWithInput.chain(this.primaryHistogram, this::updateChartAndListDetails, this.secondaryHistogram);
                this.addContextMenu(this.secondaryHistogram, this.secondaryFilter);
                this.secondaryFilter.loadState(ExceptionsPage.this.getState().getChild(SECONDARY_FILTER));
            }
            this.addContextMenu(this.primaryHistogram, this.primaryFilter);
            this.primaryFilter.loadState(ExceptionsPage.this.getState().getChild(PRIMARY_FILTER));
            this.histogramParent.layout();
        }

        private void onFilterChange(IItemFilter filter) {
            this.primaryFilter.filterChangeHelper(filter, this.primaryHistogram, ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES));
            if (this.secondaryFilter != null) {
                this.secondaryFilter.notifyListener();
            }
            ExceptionsPage.this.primaryTableFilter.put(this.histogramType, filter);
        }

        private void onSecondaryFilterChange(IItemFilter filter) {
            this.secondaryFilter.filterChangeHelper(filter, this.secondaryHistogram, ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES));
            ExceptionsPage.this.secondaryTableFilter.put(this.histogramType, filter);
        }

        private void onEventFilterChange(IItemFilter filter) {
            this.eventFilter.filterChangeHelper(filter, this.eventList, ExceptionsPage.this.getDataSource().getItems().apply(JdkFilters.THROWABLES));
            ExceptionsPage.this.eventListFilter = filter;
        }

        private void addContextMenu(ItemHistogram h, FilterComponent filter) {
            MCContextMenuManager mm = MCContextMenuManager.create((Control)h.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)h.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(this.pageContainer.getSelectionStore(), h, Messages.ExceptionsPage_THROWABLES_HISTOGRAM_SELECTION, (IContributionManager)mm);
            if (filter != null) {
                mm.add(filter.getShowFilterAction());
                mm.add(filter.getShowSearchAction());
            }
        }

        public void saveTo(IWritableState state) {
            StateToolkit.writeEnum((IWritableState)state, (String)ExceptionsPage.HISTGRAM_TYPE, (Enum)this.histogramType);
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)state.createChild(ExceptionsPage.SASH_ELEMENT));
            this.primaryHistogram.getManager().getSettings().saveState(state.createChild(ExceptionsPage.EXCEPTIONS_TABLE));
            Optional.ofNullable(this.secondaryHistogramSettings.get()).ifPresent(settings -> settings.saveState(state.createChild(ExceptionsPage.SECONDARY_EXCEPTIONS_TABLE)));
            this.eventList.getManager().getSettings().saveState(state.createChild(ExceptionsPage.LIST_ELEMENT));
            this.primaryFilter.saveState(state.createChild(PRIMARY_FILTER));
            if (this.secondaryFilter != null) {
                this.secondaryFilter.saveState(state.createChild(SECONDARY_FILTER));
            }
            this.eventFilter.saveState(state.createChild(EVENTS_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            ExceptionsPage.this.eventListSelection = this.eventList.getManager().getSelectionState();
            ExceptionsPage.this.primaryTableSelection.put(this.histogramType, this.primaryHistogram.getManager().getSelectionState());
            if (this.secondaryHistogram != null) {
                ExceptionsPage.this.secondaryTableSelection.put(this.histogramType, this.secondaryHistogram.getManager().getSelectionState());
            }
            ExceptionsPage.this.tabFolderIndex = this.tabFolder.getSelectionIndex();
            ExceptionsPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void hookUpExceptionsChart() {
            DataPageToolkit.setChart(this.exceptionChartCanvas, this.exceptionsChart, selection -> this.pageContainer.showSelection((IItemCollection)selection));
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.pageContainer.getSelectionStore(), this.exceptionsChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.ExceptionsPage_THROWABLES_TIMELINE_SELECTION, (IContributionManager)this.exceptionChartCanvas.getContextMenu());
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.currentRange : this.pageContainer.getRecordingRange();
            this.exceptionsChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.hookUpExceptionsChart();
            this.refreshPageItems();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items;
            this.currentRange = timeRange;
            this.refreshPageItems();
        }

        private void refreshPageItems() {
            IItemCollection items = this.selectionItems != null ? this.selectionItems : ExceptionsPage.this.getDataSource().getItems();
            this.itemConsumerRoot.accept(items.apply(JdkFilters.THROWABLES));
        }

        private void updateChartAndListDetails(IItemCollection selectedItems) {
            IItemCollection errorItems;
            ArrayList<ItemRow> rows = new ArrayList<ItemRow>();
            XYDataRenderer xyRenderer = new XYDataRenderer((IQuantity)UnitLookup.NUMBER.getDefaultUnit().quantity(0L), Messages.ExceptionsPage_ROW_STATISTICS, JdkAttributes.EXCEPTION_THROWABLES_COUNT.getDescription());
            IItemCollection statsItems = ExceptionsPage.this.getDataSource().getItems().apply(JdkQueries.THROWABLES_STATISTICS.getFilter());
            IQuantitySeries<?> adjustedStatsSeries = this.zeroIndexStatisticsEvents(statsItems);
            xyRenderer.addLineChart(JdkAttributes.EXCEPTION_THROWABLES_COUNT.getName(), adjustedStatsSeries, STATISTICS_EVENT_COLOR, false);
            rows.add(new ItemRow(Messages.ExceptionsPage_ROW_STATISTICS, Messages.ExceptionsPage_ROW_STATISTICS, (IXDataRenderer)xyRenderer, statsItems));
            IItemCollection exceptionItems = selectedItems.apply(JdkFilters.EXCEPTIONS);
            if (exceptionItems.hasItems()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(Messages.ExceptionsPage_ROW_EXCEPTIONS, JdkAggregators.EXCEPTIONS_COUNT.getDescription(), exceptionItems, JdkAggregators.EXCEPTIONS_COUNT, EXCEPTIONS_EVENT_COLOR));
            }
            if ((errorItems = selectedItems.apply(JdkFilters.ERRORS)).hasItems()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(Messages.ExceptionsPage_ROW_ERRORS, JdkAggregators.ERROR_COUNT.getDescription(), errorItems, JdkAggregators.ERROR_COUNT, ERRORS_EVENT_COLOR));
            }
            this.exceptionChartCanvas.replaceRenderer(RendererToolkit.uniformRows(rows));
            this.eventList.show(selectedItems);
            this.pageContainer.showSelection(selectedItems);
        }

        private IQuantitySeries<?> zeroIndexStatisticsEvents(IItemCollection statsItems) {
            IQuantity first = this.findFirstStatEvent(statsItems);
            ArrayList<IQuantity> xValues = new ArrayList<IQuantity>();
            ArrayList<IQuantity> yValues = new ArrayList<IQuantity>();
            for (IItemIterable next : statsItems) {
                IMemberAccessor xValueAccessor = JfrAttributes.END_TIME.getAccessor(next.getType());
                IMemberAccessor yValueAccessor = JdkAttributes.EXCEPTION_THROWABLES_COUNT.getAccessor(next.getType());
                for (IItem item : next) {
                    xValues.add((IQuantity)xValueAccessor.getMember((Object)item));
                    yValues.add(((IQuantity)yValueAccessor.getMember((Object)item)).subtract(first));
                }
            }
            IQuantitySeries adjustedStatsSeries = QuantitySeries.all(xValues, yValues);
            return adjustedStatsSeries;
        }

        private IQuantity findFirstStatEvent(IItemCollection stats) {
            IQuantity firstValue = null;
            for (IItemIterable next : stats) {
                IMemberAccessor yValueAccessor = JdkAttributes.EXCEPTION_THROWABLES_COUNT.getAccessor(next.getType());
                for (IItem item : next) {
                    IQuantity itemValue = (IQuantity)yValueAccessor.getMember((Object)item);
                    if (firstValue != null && firstValue.subtract(itemValue).longValue() <= 0L) continue;
                    firstValue = itemValue;
                }
            }
            return firstValue;
        }
    }

    private static enum HistogramType {
        CLASS,
        MESSAGE,
        CLASS_AND_MESSAGE;

    }
}

