/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.misc.CompositeToolkit;

public class ItemAggregateViewer {
    private static final boolean SCROLL_WORKAROUND = !Boolean.getBoolean("org.openjdk.jmc.ui.disablescrollworkaround");
    private final ScrolledComposite scroller;
    private final Composite infoContainer;
    private final FormToolkit toolkit;
    private final List<Pair<Function<IItemCollection, ?>, Text>> infos = new ArrayList();
    private int lineHeight;

    public ItemAggregateViewer(Composite container, FormToolkit toolkit) {
        this(container, toolkit, 1);
    }

    public ItemAggregateViewer(Composite container, FormToolkit toolkit, int columns) {
        this.toolkit = toolkit;
        this.scroller = CompositeToolkit.createVerticalScrollComposite((Composite)container);
        this.infoContainer = ItemAggregateViewer.createInfoContainer((Composite)this.scroller, toolkit, columns);
        this.scroller.setContent((Control)this.infoContainer);
    }

    public Control getControl() {
        return this.scroller;
    }

    public void addCaption(String text) {
        this.addCaption(text, null);
    }

    public void addCaption(String text, String tooltip) {
        Label caption = this.toolkit.createLabel(this.infoContainer, text);
        caption.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        caption.setLayoutData((Object)new TableWrapData(128, 32, 1, 2));
        caption.setToolTipText(tooltip);
    }

    public void addAggregate(IAggregator<?, ?> aggregator) {
        this.addAggregate(aggregator, aggregator.getName(), aggregator.getDescription());
    }

    public void addAggregate(IAggregator<?, ?> aggregator, String name, String description) {
        this.addValueFunction(i -> i.getAggregate(aggregator), name, description);
    }

    public void addValueFunction(Function<IItemCollection, ?> valueFunction, String name, String description) {
        Text valueText = ItemAggregateViewer.createInfoText(this.infoContainer, this.toolkit, name, description, 2138);
        this.infos.add(new Pair(valueFunction, (Object)valueText));
        if (SCROLL_WORKAROUND) {
            if (this.lineHeight <= 1) {
                this.lineHeight = valueText.getLineHeight();
            }
            valueText.addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    int deltaPoints;
                    Point pos = ItemAggregateViewer.this.scroller.getOrigin();
                    switch (event.detail) {
                        case 2: {
                            deltaPoints = event.count * ((ItemAggregateViewer)ItemAggregateViewer.this).scroller.getClientArea().height;
                            break;
                        }
                        case 1: {
                            deltaPoints = event.count * ItemAggregateViewer.this.lineHeight;
                            break;
                        }
                        default: {
                            deltaPoints = event.count;
                        }
                    }
                    ItemAggregateViewer.this.scroller.setOrigin(pos.x, pos.y - deltaPoints);
                    event.doit = false;
                }
            });
        }
    }

    public void setValues(IItemCollection items) {
        for (Pair<Function<IItemCollection, ?>, Text> i : this.infos) {
            Object aggregate = ((Function)i.left).apply(items);
            ((Text)i.right).setText(aggregate == null ? Messages.INFORMATION_COMPONENT_NOT_AVAILABLE : TypeHandling.getValueString(aggregate));
            ((Text)i.right).setToolTipText(aggregate == null ? Messages.INFORMATION_COMPONENT_NOT_AVAILABLE : TypeHandling.getVerboseString(aggregate));
        }
    }

    public static Composite createInfoContainer(Composite container, FormToolkit toolkit, int columns) {
        Composite infoContainer = toolkit.createComposite(container, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = columns * 2;
        infoContainer.setLayout((Layout)layout);
        return infoContainer;
    }

    public static Text createInfoText(Composite infoContainer, FormToolkit toolkit, String text, String tooltip, int style) {
        Label nameLabel = toolkit.createLabel(infoContainer, text);
        nameLabel.setLayoutData((Object)new TableWrapData(128, 32));
        nameLabel.setToolTipText(tooltip);
        Text valueText = toolkit.createText(infoContainer, "", style);
        valueText.setLayoutData((Object)new TableWrapData(256, 256));
        return valueText;
    }
}

