/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.util.ExceptionToolkit;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.ui.BasicConfig;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.JfrNavigationLocation;
import org.openjdk.jmc.flightrecorder.ui.JfrOutlinePage;
import org.openjdk.jmc.flightrecorder.ui.JfrPropertySheet;
import org.openjdk.jmc.flightrecorder.ui.RecordingLoader;
import org.openjdk.jmc.flightrecorder.ui.ResultPage;
import org.openjdk.jmc.flightrecorder.ui.RuleManager;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.IFlavoredSelection;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStore;
import org.openjdk.jmc.ui.MCPathEditorInput;
import org.openjdk.jmc.ui.idesupport.IDESupportUIToolkit;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.SelectionProvider;

public class JfrEditor
extends EditorPart
implements INavigationLocationProvider,
IPageContainer {
    public static final String RULE_CONFIGURATION_PREFERENCE_ID = "ruleConfiguration";
    public static final String EDITOR_ID = "org.openjdk.jmc.flightrecorder.ui.JfrEditor";
    private static final String CONTENT_OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final String RESULT_VIEW_ID = "org.openjdk.jmc.flightrecorder.ui.ResultView";
    private static final String NO_PAGES_HELP_CONTEXT_ID = "org.openjdk.jmc.flightrecorder.ui.NoPages";
    private FormToolkit toolkit;
    private Composite resultContainer;
    private StreamModel items;
    private IRange<IQuantity> fullRange;
    private final Map<DataPageDescriptor, IDisplayablePage> pageMap = new HashMap<DataPageDescriptor, IDisplayablePage>();
    private DataPageDescriptor currentPage;
    private IPageUI currentPageUI;
    private Reference<JfrOutlinePage> outlinePageRef = new WeakReference<Object>(null);
    private final SelectionStore selectionStore = new SelectionStore();
    private Reference<ResultPage> resultPageRef = new WeakReference<Object>(null);
    private RuleManager ruleEngine = new RuleManager(() -> DisplayToolkit.safeAsyncExec(() -> this.refreshOutline()));
    private IPropertyChangeListener analysisEnabledListener = e -> {
        if (e.getProperty().equals("flightrecorder.controlpanel.enable.recording.analysis") && ((Boolean)e.getNewValue()).booleanValue()) {
            this.ruleEngine.evaluateAllRules();
        }
    };

    public JfrEditor() {
        FlightRecorderUI.getDefault().getPreferenceStore().addPropertyChangeListener(this.analysisEnabledListener);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(FlightRecorderUI.getDefault().getFormColors(Display.getCurrent()));
        this.toolkit.setBorderStyle(0);
        this.resultContainer = parent;
        this.resultContainer.addDisposeListener(e -> this.saveCurrentPageState());
        ProgressIndicator progressIndicator = CompositeToolkit.createWaitIndicator((Composite)this.toolkit.createComposite(parent), (FormToolkit)this.toolkit);
        new RecordingLoader(this, progressIndicator).schedule();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContentOutlinePage.class) {
            JfrOutlinePage outlinePage = new JfrOutlinePage(this);
            this.outlinePageRef = new WeakReference<JfrOutlinePage>(outlinePage);
            return adapter.cast((Object)outlinePage);
        }
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast((Object)new JfrPropertySheet(this));
        }
        return (T)super.getAdapter(adapter);
    }

    ResultPage createResultPage() {
        ResultPage p = new ResultPage();
        p.setEditor(this);
        this.resultPageRef = new WeakReference<ResultPage>(p);
        this.ruleEngine.addResultListener(r -> {
            ResultPage resultPage = this.resultPageRef.get();
            if (resultPage != null) {
                resultPage.updateRule((Result)r);
            }
        });
        return p;
    }

    @Override
    public IDisplayablePage getDisplayablePage(DataPageDescriptor page) {
        return this.pageMap.computeIfAbsent(page, this::buildPage);
    }

    private IDisplayablePage buildPage(DataPageDescriptor dpd) {
        return dpd == null ? null : dpd.createPage(this.items, this);
    }

    @Override
    public void showSelection(IItemCollection items) {
        IItemCollection selectionItems = items;
        if (!items.hasItems() && this.currentPage != null) {
            selectionItems = this.getModel().getItems().apply(this.getDisplayablePage(this.currentPage).getDefaultSelectionFilter());
        }
        this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)selectionItems));
    }

    @Override
    public void showSelection(IFlavoredSelection selection) {
        this.getSite().getSelectionProvider().setSelection((ISelection)selection);
    }

    @Override
    public IRange<IQuantity> getRecordingRange() {
        return this.fullRange;
    }

    StreamModel getModel() {
        return this.items;
    }

    DataPageDescriptor getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean navigateTo(DataPageDescriptor page) {
        if (this.currentPage == page) {
            return false;
        }
        this.saveCurrentPageState();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.resultContainer, page.getHelpContextId());
        this.displayPage(page);
        this.setTopics(Arrays.asList(page.getTopics()));
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
        this.refreshOutline();
        return true;
    }

    void displayPage(DataPageDescriptor page) {
        this.disposeOldPageContent();
        this.currentPageUI = null;
        try {
            if (page != null) {
                IDisplayablePage displayPage = this.getDisplayablePage(page);
                this.currentPage = page;
                this.showSelection(this.items.getItems().apply(displayPage.getDefaultSelectionFilter()));
                this.currentPageUI = displayPage.display(this.resultContainer, this.toolkit, this, (IState)page.getPageState());
            } else {
                Label label = new Label(this.resultContainer, 64);
                label.setText(Messages.JFR_EDITOR_NO_PAGES_TO_SHOW);
                this.setTopics(Collections.emptyList());
            }
        }
        catch (RuntimeException e1) {
            this.displayErrorPage(this.currentPage, e1);
        }
        this.resultContainer.layout();
    }

    private void disposeOldPageContent() {
        Control[] controlArray = this.resultContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    private void displayErrorPage(DataPageDescriptor page, RuntimeException cause) {
        this.disposeOldPageContent();
        Composite composite = new Composite(this.resultContainer, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        CLabel errorTitleLabel = new CLabel(composite, 64);
        errorTitleLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        errorTitleLabel.setImage(FlightRecorderUI.getDefault().getMCImageDescriptor("Erreur-icon.png").createImage());
        errorTitleLabel.setText(NLS.bind((String)Messages.JFR_EDITOR_PAGE_CANNOT_BE_DISPLAYED, (Object)page.getName()).replaceAll("&", "&&"));
        errorTitleLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        Label errorTextLabel = new Label(composite, 64);
        errorTextLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        errorTextLabel.setText(Messages.JFR_EDITOR_INVALID_RECORDING_TEXT);
        ExpandableComposite ec = this.toolkit.createExpandableComposite(composite, 20);
        ec.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ec.setText(Messages.STACKTRACE_VIEW_STACK_TRACE);
        Text stackTraceText = new Text((Composite)ec, 2824);
        stackTraceText.setBackground(Display.getCurrent().getSystemColor(1));
        stackTraceText.setText(ExceptionToolkit.toString((Throwable)cause));
        ec.setClient((Control)stackTraceText);
    }

    void refreshPages() {
        List<DataPageDescriptor> rootPages = FlightRecorderUI.getDefault().getPageManager().getRootPages();
        this.ruleEngine.refreshTopics();
        if (this.currentPage != null && rootPages.stream().anyMatch(p -> p.contains(this.currentPage))) {
            this.refreshOutline();
        } else if (rootPages.isEmpty()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.resultContainer, NO_PAGES_HELP_CONTEXT_ID);
            this.displayPage(null);
            this.refreshOutline();
        } else if (this.getModel() != null) {
            this.navigateTo(rootPages.get(0));
        }
    }

    private void refreshOutline() {
        Optional.ofNullable(this.outlinePageRef.get()).ifPresent(JfrOutlinePage::refresh);
    }

    @Override
    public void currentPageRefresh() {
        this.saveCurrentPageState();
        this.showResults(this.currentPage.getTopics());
        this.displayPage(this.currentPage);
        this.refreshOutline();
    }

    private void saveCurrentPageState() {
        if (this.currentPageUI != null) {
            this.currentPage.readPageStateFrom(this.currentPageUI);
        }
    }

    @Override
    public SelectionStore getSelectionStore() {
        return this.selectionStore;
    }

    public void setFocus() {
        this.resultContainer.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        File srcFile = MCPathEditorInput.getFile((IEditorInput)this.getEditorInput());
        if (srcFile != null) {
            File saveAsFile;
            do {
                if ((saveAsFile = IDESupportUIToolkit.browseForSaveAsFile((String)Messages.SAVE_AS_TITLE, (File)srcFile, (String)"jfr", (String)Messages.SAVE_AS_JFR_DESCRIPTION)) != null) continue;
                return;
            } while (IDESupportUIToolkit.checkAlreadyExists((File)saveAsFile));
            try {
                IOToolkit.copyFile((File)srcFile, (File)saveAsFile);
                this.setInput((IEditorInput)new MCPathEditorInput(saveAsFile, false));
            }
            catch (IOException e) {
                DialogToolkit.showException((Shell)this.getSite().getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (Throwable)e);
            }
        } else {
            DialogToolkit.showError((Shell)this.getSite().getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (String)Messages.SAVE_AS_NO_SRC_ERROR_MSG);
        }
    }

    public void setInput(IEditorInput ei) {
        super.setInput(ei);
        this.setPartName(ei.getName());
    }

    void repositoryLoaded(EventArray[] repo, IRange<IQuantity> fullRange) {
        if (!this.resultContainer.isDisposed()) {
            this.items = new StreamModel(repo);
            this.fullRange = fullRange;
            try {
                this.getSite().getPage().showView(CONTENT_OUTLINE_VIEW_ID, null, 2);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            this.ruleEngine.setStreamModel(this.items);
            this.refreshPages();
            this.ruleEngine.evaluateAllRules();
        }
    }

    @Override
    public RuleManager getRuleManager() {
        return this.ruleEngine;
    }

    public void dispose() {
        this.ruleEngine.dispose();
        FlightRecorderUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.analysisEnabledListener);
        super.dispose();
    }

    @Override
    public BasicConfig getConfig() {
        return this.ruleEngine.getConfig();
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new JfrNavigationLocation(this, null);
    }

    public INavigationLocation createNavigationLocation() {
        if (this.currentPage == null) {
            return null;
        }
        return new JfrNavigationLocation(this, this.currentPage);
    }

    @Override
    public void showResults(String ... topics) {
        try {
            if (this.resultPageRef.get() == null) {
                this.getSite().getWorkbenchWindow().getActivePage().showView(RESULT_VIEW_ID, null, 3);
            }
            this.getSite().getWorkbenchWindow().getActivePage().showView(RESULT_VIEW_ID, null, 2);
        }
        catch (PartInitException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Could not show Result view.", e);
        }
        this.setTopics(Arrays.asList(topics));
    }

    private void setTopics(Collection<String> topics) {
        Optional.ofNullable(this.resultPageRef.get()).ifPresent(rp -> rp.setTopics(topics));
    }
}

