/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.util.PredicateToolkit;

public class ItemIterableToolkit {
    public static IItemIterable build(Supplier<Stream<IItem>> items, IType<IItem> type) {
        return new StreamBackedItemIterable(items, type);
    }

    public static Stream<IItemIterable> filter(Stream<? extends IItemIterable> items, IItemFilter on) {
        Function<IItemIterable, IItemIterable> streamMapper = itemStream -> {
            IPredicate predicate = on.getPredicate(itemStream.getType());
            if (PredicateToolkit.isTrueGuaranteed((IPredicate)predicate)) {
                return itemStream;
            }
            if (PredicateToolkit.isFalseGuaranteed((IPredicate)predicate)) {
                return null;
            }
            return itemStream.apply(predicate);
        };
        return items.map(streamMapper).filter(Objects::nonNull);
    }

    public static <V, C extends IItemConsumer<C>> V aggregate(IAggregator<V, C> a, Stream<? extends IItemIterable> items) {
        Function<IItemIterable, IItemConsumer> itemsToValue = itemsStream -> (IItemConsumer)ItemIterableToolkit.parallelStream(itemsStream).collect(ItemIterableToolkit.valueCollector(a, (IType<IItem>)itemsStream.getType()));
        Stream<IItemConsumer> consumers = items.filter(is -> a.acceptType(is.getType())).map(itemsToValue);
        return (V)a.getValue(consumers.iterator());
    }

    private static <C extends IItemConsumer<C>> Collector<IItem, C, C> valueCollector(IAggregator<?, C> a, IType<IItem> type) {
        return Collector.of(() -> a.newItemConsumer(type), IItemConsumer::consume, IItemConsumer::merge, Collector.Characteristics.UNORDERED);
    }

    public static <V> Stream<? extends IItem> sorted(IItemIterable items, IAttribute<V> onAttribute, Comparator<? super V> valueComparator) {
        IMemberAccessor va = onAttribute.getAccessor(items.getType());
        return ItemIterableToolkit.stream(items).sorted((i1, i2) -> Objects.compare(va.getMember(i1), va.getMember(i2), valueComparator));
    }

    public static Stream<IItem> stream(IItemIterable items) {
        return StreamSupport.stream(items.spliterator(), false);
    }

    public static Stream<IItem> parallelStream(IItemIterable items) {
        return StreamSupport.stream(items.spliterator(), true);
    }

    private static class StreamBackedItemIterable
    implements IItemIterable {
        private final Supplier<Stream<IItem>> items;
        private final IType<IItem> type;

        StreamBackedItemIterable(Supplier<Stream<IItem>> items, IType<IItem> type) {
            this.items = items;
            this.type = type;
        }

        public IType<IItem> getType() {
            return this.type;
        }

        public boolean hasItems() {
            return this.items.get().findAny().isPresent();
        }

        public long getItemCount() {
            long exactSizeIfKnown = this.spliterator().getExactSizeIfKnown();
            return exactSizeIfKnown >= 0L ? exactSizeIfKnown : this.items.get().count();
        }

        public Iterator<IItem> iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        public Spliterator<IItem> spliterator() {
            return this.items.get().spliterator();
        }

        public IItemIterable apply(IPredicate<IItem> filter) {
            return new StreamBackedItemIterable(() -> this.items.get().filter(arg_0 -> ((IPredicate)filter).evaluate(arg_0)), this.getType());
        }
    }
}

