/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree.traversal;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LongestDurationIterator
implements Iterator<IItem> {
    private ITreeNode<IItem> currentNode;

    public LongestDurationIterator(ITreeNode<IItem> node) {
        this.currentNode = this.getFirstNode(node);
    }

    private ITreeNode<IItem> getFirstNode(ITreeNode<IItem> initNode) {
        if (initNode.getValue() == null) {
            return this.getLongestLastingChild(initNode.getChildren());
        }
        return initNode;
    }

    @Override
    public boolean hasNext() {
        return this.currentNode != null;
    }

    @Override
    public IItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IItem value = this.currentNode.getValue();
        this.currentNode = this.getLongestLastingChild(this.currentNode.getChildren());
        return value;
    }

    private ITreeNode<IItem> getLongestLastingChild(List<ITreeNode<IItem>> children) {
        ITreeNode<IItem> longestLasting = null;
        IQuantity longestDuration = null;
        for (ITreeNode<IItem> node : children) {
            IItem nodeItem = node.getValue();
            if (nodeItem == null || longestDuration != null && longestDuration.compareTo((Object)RulesToolkit.getDuration(nodeItem)) >= 0) continue;
            longestDuration = RulesToolkit.getDuration(nodeItem);
            longestLasting = node;
        }
        return longestLasting;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removals!");
    }
}

