/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;

public abstract class AbstractRule
implements IRule {
    protected FutureTask<Result> evaluationTask;
    private final String id;
    private final String name;
    private final String topic;
    private final Collection<TypedPreference<?>> configAttributes;

    public AbstractRule(String id, String name, String topic, TypedPreference<?> ... configAttributes) {
        this.id = id;
        this.name = name;
        this.topic = topic;
        this.configAttributes = Arrays.asList(configAttributes);
    }

    protected abstract Result getResult(IItemCollection var1, IPreferenceValueProvider var2);

    @Override
    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        this.evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return AbstractRule.this.getResult(items, valueProvider);
            }
        });
        return this.evaluationTask;
    }

    @Override
    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return this.configAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }
}

