/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs;

import java.io.Closeable;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs.DumpRecordingJob;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.rjmx.services.jfr.IRecordingDescriptor;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.common.util.StatusFactory;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public final class StartRecordingJob
extends Job {
    private final IConstrainedMap<String> m_recordingOptions;
    private final IConstrainedMap<EventOptionID> m_eventOptions;
    private final MCFile m_path;
    private final FlightRecorderProvider m_recorder;
    private volatile boolean m_canceling;

    public StartRecordingJob(FlightRecorderProvider recorder, String name, IConstrainedMap<String> recordingOptions, IConstrainedMap<EventOptionID> eventOptions, MCFile path) {
        super(NLS.bind((String)org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages.RECORDING_JOB_NAME, (Object)name));
        this.m_recordingOptions = recordingOptions;
        this.m_eventOptions = eventOptions;
        this.m_path = path;
        this.m_recorder = recorder;
        this.setUser(true);
    }

    protected void canceling() {
        this.m_canceling = true;
        this.getThread().interrupt();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IRecordingDescriptor startedRecording;
        String connectionName;
        IConnectionHandle connection;
        block7: {
            connection = null;
            connectionName = null;
            startedRecording = null;
            connectionName = this.m_recorder.getServerHandle().getServerDescriptor().getDisplayName();
            connection = this.m_recorder.getServerHandle().connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
            startedRecording = flightRecorderService.start(this.m_recordingOptions, this.m_eventOptions);
            RecordingProvider recording = this.m_recorder.getRecording(startedRecording);
            recording.setDumpToFile(this.m_path);
            if (startedRecording.isContinuous()) break block7;
            IStatus iStatus2 = this.monitorRecording(recording, monitor, connection, flightRecorderService);
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        try {
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            block9: {
                block8: {
                    IStatus iStatus3;
                    try {
                        IServerHandle.State state = this.m_recorder.getServerHandle().getState();
                        if (state != IServerHandle.State.DISPOSED) break block8;
                        iStatus3 = Status.OK_STATUS;
                    }
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(connection);
                        throw throwable;
                    }
                    IOToolkit.closeSilently((Closeable)connection);
                    return iStatus3;
                }
                if (startedRecording == null) break block9;
                this.showMonitoringWarning(startedRecording, connectionName, e);
                IStatus iStatus4 = Status.OK_STATUS;
                IOToolkit.closeSilently((Closeable)connection);
                return iStatus4;
            }
            this.showStartingWarning(connectionName, e);
            IStatus iStatus5 = Status.OK_STATUS;
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus5;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }

    private void showStartingWarning(final String connectionName, final Exception exception) {
        DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages.START_RECORDING_JOB_SERVICE_ERROR_TITLE, (String)NLS.bind((String)org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages.START_RECORDING_JOB_SERVICE_ERROR_MESSAGE, (Object)connectionName), (Throwable)exception);
            }
        });
    }

    private void showMonitoringWarning(IRecordingDescriptor startedRecording, String connectionName, Exception e) {
        final String detailedMessage = NLS.bind((String)org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages.START_RECORDING_JOB_ERROR_WHILE_MONITORING_RECORDING_MESSAGE, (Object)startedRecording.getName(), (Object)connectionName);
        if (FlightRecorderUI.getDefault().getShowMonitoringWarning()) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, detailedMessage, e);
            DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle warnDialog = MessageDialogWithToggle.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages.START_RECORDING_JOB_ERROR_WHILE_MONITORING_RECORDING_TITLE, (String)detailedMessage, (String)Messages.PREFERENCES_SHOW_MONITORING_WARNING_TEXT, (boolean)true, null, null);
                    if (warnDialog.getReturnCode() == 0 && !warnDialog.getToggleState()) {
                        FlightRecorderUI.getDefault().setShowMonitoringWarning(false);
                    }
                }
            });
        } else {
            ControlPanel.getDefault().getLogger().log(Level.FINER, detailedMessage, e);
        }
    }

    private IStatus monitorRecording(RecordingProvider rec, IProgressMonitor monitor, IConnectionHandle connection, IFlightRecorderService flightRecorderService) throws Exception {
        block8: {
            String recordingName = rec.getRecordingDescriptor().getName();
            int totalWork = rec.getRecordingDescriptor().getDuration().clampedIntFloorIn((IUnit)UnitLookup.SECOND);
            monitor.beginTask(recordingName, totalWork);
            int progress = 0;
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (rec.wasClosed()) {
                    monitor.done();
                    break block8;
                }
                if ((rec = this.m_recorder.findRecording(rec.getRecordingDescriptor().getId(), connection)) == null) break;
                if (rec.isStopped() || this.m_canceling) {
                    if (rec.isAlive()) {
                        flightRecorderService.stop(rec.getRecordingDescriptor());
                    }
                    new DumpRecordingJob(rec, rec.getDumpToFile()).schedule();
                    monitor.done();
                    break block8;
                }
                IQuantity remaining = rec.getTimeRemaining();
                IQuantity duration = rec.getRecordingDescriptor().getDuration();
                float partOfWorkDone = duration != null && remaining != null ? 1.0f - (float)remaining.ratioTo(duration) : 0.0f;
                int newProgress = Math.max(Math.round((float)totalWork * partOfWorkDone), progress);
                int worked = newProgress - progress;
                progress = newProgress;
                try {
                    monitor.worked(worked);
                }
                catch (RuntimeException e) {
                    ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not update progress", e);
                }
            }
            monitor.done();
            return StatusFactory.createErr((String)NLS.bind((String)org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages.START_FLIGHT_RECORDING_JOB_MISSING_RECORDING, (Object)recordingName));
        }
        return Status.OK_STATUS;
    }
}

